/*
 * Decompiled with CFR 0.152.
 */
package simulate.units;

import simulate.units.Amu;
import simulate.units.Angstrom;
import simulate.units.Picosecond;
import simulate.units.Unit;

public abstract class UnitSystem {
    public abstract Unit.Charge charge();

    public abstract Unit.Energy energy();

    public abstract Unit.Length length();

    public abstract Unit.Mass mass();

    public Unit.Pressure pressure() {
        return this.pressure(2);
    }

    public abstract Unit.Pressure pressure(int var1);

    public abstract Unit.Temperature temperature();

    public abstract Unit.Time time();

    public Unit.Volume volume() {
        return this.volume(2);
    }

    public abstract Unit.Volume volume(int var1);

    public static class Sim
    extends UnitSystem {
        public Unit.Charge charge() {
            return Unit.Charge.Sim.UNIT;
        }

        public Unit.Energy energy() {
            return Unit.Energy.Sim.UNIT;
        }

        public Unit.Length length() {
            return Angstrom.UNIT;
        }

        public Unit.Mass mass() {
            return Amu.UNIT;
        }

        public Unit.Pressure pressure(int D) {
            return D == 2 ? Unit.Pressure2D.Sim.UNIT : Unit.Pressure.Sim.UNIT;
        }

        public Unit.Temperature temperature() {
            return Unit.Temperature.Sim.UNIT;
        }

        public Unit.Time time() {
            return Picosecond.UNIT;
        }

        public Unit.Volume volume(int D) {
            return D == 2 ? Unit.Volume2D.Sim.UNIT : Unit.Volume.Sim.UNIT;
        }
    }
}

