/*
 * Decompiled with CFR 0.152.
 */
package simulate.electrostatics;

import simulate.Atom;
import simulate.AtomPair;
import simulate.MeterFunction;
import simulate.MeterMultiFunction;
import simulate.Phase;
import simulate.Simulation;
import simulate.Space2D;
import simulate.electrostatics.ElectroType;
import utility.Functions;

public class EwaldSum
extends MeterMultiFunction {
    AtomPair.Iterator.All iteratorAll;
    Atom.Iterator atomIterator;
    double[] xDirect;
    double[] xRecip;
    double[] yDirect;
    double[] yRecip;
    int nDirect;
    int nRecip;
    private double z2Sum;
    private static final double selfC = -1.0 / Math.sqrt(Math.PI);
    private static final double recipC = 0.15915494309189535;
    private static final double pi2 = Math.PI * Math.PI;
    private double alpha;
    public static final int TOTAL = 0;
    public static final int DIRECT = 1;
    public static final int RECIP = 2;
    public static final int SELF = 3;

    public EwaldSum() {
        super(4);
        this.setNDirect(5);
        this.setNRecip(5);
        this.meters[0] = new TotalMeter();
        this.meters[1] = new DirectMeter();
        this.meters[2] = new RecipMeter();
        this.meters[3] = new SelfMeter();
    }

    public double[] currentValue() {
        return this.meters[0].currentValue();
    }

    private double direct(Space2D.Vector M) {
        double pe = 0.0;
        this.iteratorAll.reset();
        double m2 = M.squared();
        while (this.iteratorAll.hasNext()) {
            AtomPair pair = this.iteratorAll.next();
            if (m2 > 0.0) {
                ((Space2D.CoordinatePair)pair.cPair).reset(M);
            }
            double r = Math.sqrt(pair.r2());
            double z1 = ((ElectroType.Monopole)pair.atom1.type.electroType()).z();
            double z2 = ((ElectroType.Monopole)pair.atom2.type.electroType()).z();
            pe += z1 * z2 * Functions.erfc(this.alpha * r) / r;
        }
        double m = Math.sqrt(m2);
        double self = m2 > 0.0 ? this.z2Sum * Functions.erfc(this.alpha * m) / m : 0.0;
        return pe + 0.5 * self;
    }

    double[] directSum() {
        double peSum;
        this.phase.parentSimulation();
        Space2D.Vector M = (Space2D.Vector)Simulation.space.makeVector();
        double L = this.phase.boundary().dimensions().component(0);
        this.yDirect[0] = peSum = this.direct(M);
        int m = 1;
        while (m < this.nDirect) {
            M.x = (double)m * L;
            M.y = (double)m * L;
            peSum += this.direct(M);
            M.x = (double)(-m) * L;
            peSum += this.direct(M);
            M.y = (double)(-m) * L;
            peSum += this.direct(M);
            M.x = (double)m * L;
            peSum += this.direct(M);
            int i = -m + 1;
            while (i < m) {
                M.x = (double)m * L;
                M.y = (double)i * L;
                peSum += this.direct(M);
                M.x = (double)(-m) * L;
                peSum += this.direct(M);
                M.x = (double)i * L;
                M.y = (double)m * L;
                peSum += this.direct(M);
                M.y = (double)(-m) * L;
                peSum += this.direct(M);
                ++i;
            }
            this.yDirect[m] = peSum;
            ++m;
        }
        return this.yDirect;
    }

    public double getAlpha() {
        return this.alpha;
    }

    private double recip(Space2D.Vector M) {
        this.atomIterator.reset();
        double cSum = 0.0;
        double sSum = 0.0;
        while (this.atomIterator.hasNext()) {
            Atom a = this.atomIterator.next();
            double z = ((ElectroType.Monopole)a.type.electroType()).z();
            double arg = Math.PI * 2 * M.dot(a.r);
            cSum += z * Math.cos(arg);
            sSum += z * Math.sin(arg);
        }
        double m2 = M.squared();
        return 0.15915494309189535 / this.phase.volume() * Math.exp(-9.869604401089358 * m2 / (this.alpha * this.alpha)) / m2 * (cSum * cSum + sSum * sSum);
    }

    double[] recipSum() {
        double peSum;
        this.phase.parentSimulation();
        Space2D.Vector M = (Space2D.Vector)Simulation.space.makeVector();
        double L = this.phase.boundary().dimensions().component(0);
        double c = 1.0 / L;
        this.yRecip[0] = peSum = 0.0;
        int m = 1;
        while (m < this.nRecip) {
            M.x = c * (double)m;
            M.y = c * (double)m;
            peSum += this.recip(M);
            M.x = -c * (double)m;
            peSum += this.recip(M);
            M.y = -c * (double)m;
            peSum += this.recip(M);
            M.x = c * (double)m;
            peSum += this.recip(M);
            int i = -m + 1;
            while (i < m) {
                M.x = c * (double)m;
                M.y = c * (double)i;
                peSum += this.recip(M);
                M.x = -c * (double)m;
                peSum += this.recip(M);
                M.x = c * (double)i;
                M.y = c * (double)m;
                peSum += this.recip(M);
                M.y = -c * (double)m;
                peSum += this.recip(M);
                ++i;
            }
            this.yRecip[m] = peSum;
            ++m;
        }
        return this.yRecip;
    }

    public double self() {
        this.atomIterator.reset();
        this.z2Sum = 0.0;
        while (this.atomIterator.hasNext()) {
            Atom a = this.atomIterator.next();
            double z = ((ElectroType.Monopole)a.type.electroType()).z();
            this.z2Sum += z * z;
        }
        return selfC * this.alpha * this.z2Sum;
    }

    public void setAlpha(double a) {
        if (this.phase != null) {
            this.alpha = a / this.phase.boundary().dimensions().component(0);
        }
    }

    public void setNDirect(int n) {
        this.nDirect = n;
        this.xDirect = new double[n];
        this.yDirect = new double[n];
        int i = 0;
        while (i < this.nDirect) {
            this.xDirect[i] = i;
            ++i;
        }
        this.meters[1] = new DirectMeter();
    }

    public void setNRecip(int n) {
        this.nRecip = n;
        this.xRecip = new double[n];
        this.yRecip = new double[n];
        int i = 0;
        while (i < this.nRecip) {
            this.xRecip[i] = i;
            ++i;
        }
        this.meters[2] = new RecipMeter();
    }

    public void setPhase(Phase p) {
        super.setPhase(p);
        this.iteratorAll = p.iterator.makeAtomPairIteratorAll();
        this.atomIterator = p.iterator.makeAtomIteratorUp();
        this.setAlpha(5.0);
    }

    private class DirectMeter
    extends MeterFunction {
        DirectMeter() {
            this.setNPoints(EwaldSum.this.nDirect);
            this.setLabel("Direct");
        }

        public double[] currentValue() {
            return EwaldSum.this.yDirect;
        }

        public void setX(double xmin, double xmax, int n) {
            super.setX(xmin, xmax, n);
            int i = 0;
            while (i < n) {
                this.x[i] = i;
                ++i;
            }
        }
    }

    private class RecipMeter
    extends MeterFunction {
        RecipMeter() {
            this.setNPoints(EwaldSum.this.nRecip);
            this.setLabel("Reciprocal");
        }

        public double[] currentValue() {
            return EwaldSum.this.yRecip;
        }

        public void setX(double xmin, double xmax, int n) {
            super.setX(xmin, xmax, n);
            int i = 0;
            while (i < n) {
                this.x[i] = i;
                ++i;
            }
        }
    }

    private class SelfMeter
    extends MeterFunction {
        SelfMeter() {
            this.setNPoints(2);
            this.setLabel("Self");
        }

        public double[] currentValue() {
            this.y[0] = this.y[1] = EwaldSum.this.self();
            return this.y;
        }

        public void setX(double xmin, double xmax, int n) {
            super.setX(xmin, xmax, n);
            int i = 0;
            while (i < n) {
                this.x[i] = i;
                ++i;
            }
        }
    }

    private class TotalMeter
    extends MeterFunction {
        TotalMeter() {
            this.setNPoints(Math.max(EwaldSum.this.nRecip, EwaldSum.this.nDirect));
            this.setLabel("Total");
        }

        public double[] currentValue() {
            double s = EwaldSum.this.self();
            double[] r = EwaldSum.this.recipSum();
            double[] d = EwaldSum.this.directSum();
            int i = 0;
            while (i < this.nPoints) {
                this.y[i] = s + r[Math.min(i, EwaldSum.this.nRecip - 1)] + d[Math.min(i, EwaldSum.this.nDirect - 1)];
                ++i;
            }
            return this.y;
        }

        public void setX(double xmin, double xmax, int n) {
            super.setX(xmin, xmax, n);
            int i = 0;
            while (i < n) {
                this.x[i] = i;
                ++i;
            }
        }
    }
}

