/*
 * Decompiled with CFR 0.152.
 */
package simulate.electrostatics;

import simulate.units.Electron;
import simulate.units.Unit;

public abstract class ElectroType {

    public static class Null
    extends ElectroType {
    }

    public static class Monopole
    extends ElectroType {
        private double z;
        private Unit.Charge zUnit;

        public Monopole() {
            this.setZ(0.0, Electron.UNIT);
        }

        public Monopole(double z) {
            this.setZ(z, Electron.UNIT);
        }

        public final double getZ() {
            return this.zUnit.fromSim(this.z);
        }

        public Unit.Charge getZUnit() {
            return this.zUnit;
        }

        public void setZ(double t) {
            this.z = this.zUnit.toSim(t);
        }

        public final void setZ(double t, Unit.Charge u) {
            this.zUnit = u;
            this.setZ(t);
        }

        public final void setZUnit(Unit.Charge u) {
            this.zUnit = u;
        }

        public final double z() {
            return this.z;
        }
    }
}

