/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import java.awt.Color;
import java.awt.Graphics;
import java.util.Random;
import simulate.Atom;
import simulate.AtomPair;
import simulate.AtomType;
import simulate.DisplayConfiguration;
import simulate.PotentialHard;
import simulate.Simulation;
import simulate.Space;

public class Space2D
extends Space {
    public static final int D = 2;

    public final int D() {
        return 2;
    }

    public Space.Boundary makeBoundary(int b) {
        switch (b) {
            case 0: {
                return new BoundaryNone();
            }
            case 1: {
                return new BoundaryPeriodicSquare();
            }
            case 2: {
                return new BoundaryHard();
            }
        }
        return null;
    }

    public Space.Coordinate makeCoordinate(Space.Occupant o) {
        return new Coordinate(o);
    }

    public Space.CoordinatePair makeCoordinatePair(Space.Boundary boundary) {
        return new CoordinatePair((Boundary)boundary);
    }

    public Space.Vector makeVector() {
        return new Vector();
    }

    public double sphereArea(double r) {
        return Math.PI * 2 * r;
    }

    public double sphereVolume(double r) {
        return Math.PI * r * r;
    }

    public static final class Vector
    extends Space.Vector {
        public static final Random random = new Random();
        public static final Vector ORIGIN = new Vector(0.0, 0.0);
        public double x;
        public double y;

        public Vector() {
            this.x = 0.0;
            this.y = 0.0;
        }

        public Vector(double a1, double a2) {
            this.x = a1;
            this.y = a2;
        }

        public void DE(double a) {
            this.x /= a;
            this.y /= a;
        }

        public void DE(Space.Vector u) {
            this.DE((Vector)u);
        }

        public void E(double a) {
            this.x = a;
            this.y = a;
        }

        public void E(int i, double a) {
            if (i == 0) {
                this.x = a;
            } else {
                this.y = a;
            }
        }

        public void E(Space.Vector u) {
            this.E((Vector)u);
        }

        public void E(Vector u) {
            this.x = u.x;
            this.y = u.y;
        }

        public void Ea1Tv1(double a1, Space.Vector u) {
            Vector u1 = (Vector)u;
            this.x = a1 * u1.x;
            this.y = a1 * u1.y;
        }

        public void ME(Space.Vector u) {
            this.ME((Vector)u);
        }

        public void ME(Vector u) {
            this.x -= u.x;
            this.y -= u.y;
        }

        public void PE(int i, double a) {
            if (i == 0) {
                this.x += a;
            } else {
                this.y += a;
            }
        }

        public void PE(Space.Vector u) {
            this.PE((Vector)u);
        }

        public void PE(Vector u) {
            this.x += u.x;
            this.y += u.y;
        }

        public void PEa1Tv1(double a1, Space.Vector u) {
            Vector u1 = (Vector)u;
            this.x += a1 * u1.x;
            this.y += a1 * u1.y;
        }

        public void TE(double a) {
            this.x *= a;
            this.y *= a;
        }

        public void TE(int i, double a) {
            if (i == 0) {
                this.x *= a;
            } else {
                this.y *= a;
            }
        }

        public void TE(Space.Vector u) {
            this.TE((Vector)u);
        }

        public double component(int i) {
            return i == 0 ? this.x : this.y;
        }

        public double dot(Space.Vector u) {
            return this.dot((Vector)u);
        }

        public double dot(Vector u) {
            return this.x * u.x + this.y * u.y;
        }

        public void randomDirection() {
            this.x = Math.cos(Math.PI * random.nextDouble());
            this.y = Math.sqrt(1.0 - this.x * this.x);
            if (random.nextDouble() < 0.5) {
                this.y = -this.y;
            }
        }

        public void randomStep(double d) {
            this.x += (2.0 * random.nextDouble() - 1.0) * d;
            this.y += (2.0 * random.nextDouble() - 1.0) * d;
        }

        public void setComponent(int i, double d) {
            if (i == 0) {
                this.x = d;
            } else {
                this.y = d;
            }
        }

        public void setRandom(double d) {
            this.x = random.nextDouble() * d;
            this.y = random.nextDouble() * d;
        }

        public void setRandom(double dx, double dy) {
            this.x = random.nextDouble() * dx;
            this.y = random.nextDouble() * dy;
        }

        public void setRandom(Vector u) {
            this.setRandom(u.x, u.y);
        }

        public void setRandomCube() {
            this.x = random.nextDouble() - 0.5;
            this.y = random.nextDouble() - 0.5;
        }

        public void setRandomSphere() {
            this.x = Math.cos(Math.PI * 2 * random.nextDouble());
            this.y = Math.sqrt(1.0 - this.x * this.x);
            if (random.nextDouble() < 0.5) {
                this.y = -this.y;
            }
        }

        public void setToOrigin() {
            this.x = Vector.ORIGIN.x;
            this.y = Vector.ORIGIN.y;
        }

        public double squared() {
            return this.x * this.x + this.y * this.y;
        }
    }

    public static final class CoordinatePair
    extends Space.CoordinatePair {
        Coordinate c1;
        Coordinate c2;
        final Boundary boundary;
        final Vector dimensions;
        private final Vector dr = new Vector();
        private double drx;
        private double dry;
        private double dvx;
        private double dvy;

        public CoordinatePair() {
            this.boundary = new BoundaryNone();
            this.dimensions = (Vector)this.boundary.dimensions();
        }

        public CoordinatePair(Space.Boundary b) {
            this.boundary = (Boundary)b;
            this.dimensions = (Vector)this.boundary.dimensions();
        }

        public Space.Vector dr() {
            return this.dr;
        }

        public double dr(int i) {
            return i == 0 ? this.drx : this.dry;
        }

        public double dv(int i) {
            return i == 0 ? this.dvx : this.dvy;
        }

        public void push(double impulse) {
            this.c1.p.x += impulse * this.drx;
            this.c1.p.y += impulse * this.dry;
            this.c2.p.x -= impulse * this.drx;
            this.c2.p.y -= impulse * this.dry;
        }

        public void reset() {
            this.dr.x = this.c2.r.x - this.c1.r.x;
            this.dr.y = this.c2.r.y - this.c1.r.y;
            this.boundary.nearestImage(this.dr);
            this.drx = this.dr.x;
            this.dry = this.dr.y;
            this.r2 = this.drx * this.drx + this.dry * this.dry;
            double rm1 = this.c1.parent().rm();
            double rm2 = this.c2.parent().rm();
            this.dvx = rm2 * this.c2.p.x - rm1 * this.c1.p.x;
            this.dvy = rm2 * this.c2.p.y - rm1 * this.c1.p.y;
        }

        public void reset(Space.Coordinate coord1, Space.Coordinate coord2) {
            this.c1 = (Coordinate)coord1;
            this.c2 = (Coordinate)coord2;
            this.reset();
        }

        public void reset(Vector M) {
            this.dr.x = this.c2.r.x - this.c1.r.x + M.x;
            this.dr.y = this.c2.r.y - this.c1.r.y + M.y;
            this.drx = this.dr.x;
            this.dry = this.dr.y;
            this.r2 = this.drx * this.drx + this.dry * this.dry;
        }

        public void setSeparation(double r2New) {
            double ratio = this.c2.parent().mass() * this.c1.parent().rm();
            double delta = (Math.sqrt(r2New / this.r2()) - 1.0) / (1.0 + ratio);
            this.c1.r.x -= ratio * delta * this.drx;
            this.c1.r.y -= ratio * delta * this.dry;
            this.c2.r.x += delta * this.drx;
            this.c2.r.y += delta * this.dry;
        }

        public double v2() {
            return this.dvx * this.dvx + this.dvy * this.dvy;
        }

        public double vDotr() {
            return this.drx * this.dvx + this.dry * this.dvy;
        }
    }

    static class Coordinate
    extends Space.Coordinate {
        public final Vector r = new Vector();
        public final Vector p = new Vector();

        public Coordinate(Space.Occupant o) {
            super(o);
        }

        public final double kineticEnergy(double mass) {
            return 0.5 * this.p.squared() / mass;
        }

        public Space.Vector makeVector() {
            return new Vector();
        }

        public Space.Vector momentum() {
            return this.p;
        }

        public double momentum(int i) {
            return this.p.component(i);
        }

        public Space.Vector position() {
            return this.r;
        }

        public double position(int i) {
            return this.r.component(i);
        }
    }

    public static abstract class Boundary
    extends Space.Boundary {
        public static final int NONE = 0;
        public static final int PERIODIC_SQUARE = 1;
        public static final int HARD = 2;

        public abstract void centralImage(Vector var1);

        public abstract void nearestImage(Vector var1);
    }

    protected static final class BoundaryNone
    extends Boundary {
        private final Vector temp = new Vector();
        private final double[][] shift0 = new double[0][2];
        public final Vector dimensions = new Vector();
        public static final Random random = new Random();

        protected BoundaryNone() {
        }

        public void centralImage(Space.Vector r) {
        }

        public void centralImage(Vector r) {
        }

        public final Space.Vector dimensions() {
            return this.dimensions;
        }

        public void draw(Graphics g, int[] origin, double scale) {
        }

        public double[][] getOverflowShifts(Space.Vector rr, double distance) {
            return this.shift0;
        }

        public double[][] imageOrigins(int nShells) {
            return new double[0][2];
        }

        public void inflate(double s) {
        }

        public void nearestImage(Space.Vector dr) {
        }

        public void nearestImage(Vector dr) {
        }

        public Space.Vector randomPosition() {
            this.temp.x = random.nextDouble();
            this.temp.y = random.nextDouble();
            return this.temp;
        }

        public double volume() {
            return Double.MAX_VALUE;
        }
    }

    public static final class BoundaryHard
    extends BoundaryPeriodicSquare {
        private double collisionRadius = 0.0;
        public double pAccumulator = 0.0;

        public BoundaryHard() {
        }

        public BoundaryHard(double lx, double ly) {
            super(lx, ly);
        }

        public void bump(AtomPair pair) {
            double dy;
            Atom a = pair.atom1();
            Vector r = (Vector)a.coordinate().position();
            Vector p = (Vector)a.coordinate().momentum();
            double dx = p.x > 0.0 ? Math.abs(this.dimensions.x - r.x - this.collisionRadius) : Math.abs(-r.x + this.collisionRadius);
            double d = dy = p.y > 0.0 ? Math.abs(this.dimensions.y - r.y - this.collisionRadius) : Math.abs(-r.y + this.collisionRadius);
            if (dx < dy) {
                this.pAccumulator += 2.0 * Math.abs(p.x);
                p.x *= -1.0;
            } else {
                this.pAccumulator += 2.0 * Math.abs(p.y);
                p.y *= -1.0;
            }
        }

        public void centralImage(Space.Vector r) {
        }

        public void centralImage(Vector r) {
        }

        public double collisionTime(AtomPair pair) {
            Atom a = pair.atom1();
            Vector r = (Vector)a.coordinate().position();
            Vector p = (Vector)a.coordinate().momentum();
            double tx = p.x > 0.0 ? (this.dimensions.x - r.x - this.collisionRadius) / (p.x * a.rm()) : (-r.x + this.collisionRadius) / (p.x * a.rm());
            double ty = p.y > 0.0 ? (this.dimensions.y - r.y - this.collisionRadius) / (p.y * a.rm()) : (-r.y + this.collisionRadius) / (p.y * a.rm());
            return Math.min(tx, ty);
        }

        public double getCollisionRadius() {
            return this.collisionRadius;
        }

        public double lastCollisionVirial() {
            return 0.0;
        }

        public void nearestImage(Space.Vector dr) {
        }

        public void nearestImage(Vector dr) {
        }

        public void setCollisionRadius(double d) {
            this.collisionRadius = d;
        }
    }

    protected static class BoundaryPeriodicSquare
    extends Boundary
    implements PotentialHard {
        private final Vector temp = new Vector();
        public static final Random random = new Random();
        private final double[][] shift0 = new double[0][2];
        private final double[][] shift1 = new double[1][2];
        private final double[][] shift3 = new double[3][2];
        public final Vector dimensions = new Vector();
        private Simulation simulation;

        public BoundaryPeriodicSquare() {
            this(30.0, 30.0);
        }

        public BoundaryPeriodicSquare(double lx, double ly) {
            this.dimensions.x = lx;
            this.dimensions.y = ly;
        }

        public void bump(AtomPair pair) {
        }

        public void centralImage(Space.Vector r) {
            this.centralImage((Vector)r);
        }

        public void centralImage(Vector r) {
            r.x = r.x - this.dimensions.x * (r.x > 0.0 ? Math.floor(r.x / this.dimensions.x) : Math.ceil(r.x / this.dimensions.x - 1.0));
            r.y = r.y - this.dimensions.y * (r.y > 0.0 ? Math.floor(r.y / this.dimensions.y) : Math.ceil(r.y / this.dimensions.y - 1.0));
        }

        public double collisionTime(AtomPair pair) {
            Atom a = pair.atom1();
            Vector p = (Vector)a.coordinate().momentum();
            double diameter = ((AtomType.Disk)a.type).diameter();
            return 0.5 * (this.dimensions.y - 1.0001 * diameter) / (a.rm() * Math.sqrt(p.squared()));
        }

        public final Space.Vector dimensions() {
            return this.dimensions;
        }

        public void draw(Graphics g, int[] origin, double scale) {
            g.setColor(Color.gray);
            double toPixels = scale * DisplayConfiguration.SIM2PIXELS;
            g.drawRect(origin[0], origin[1], (int)(toPixels * this.dimensions.component(0)) - 1, (int)(toPixels * this.dimensions.component(1)) - 1);
        }

        public double energy(AtomPair pair) {
            return 0.0;
        }

        public double energyLRC(int n1, int n2, double V) {
            return 0.0;
        }

        public double[][] getOverflowShifts(Space.Vector rr, double distance) {
            Vector r = (Vector)rr;
            int shiftX = 0;
            int shiftY = 0;
            if (r.x - distance < 0.0) {
                shiftX = 1;
            } else if (r.x + distance > this.dimensions.x) {
                shiftX = -1;
            }
            if (r.y - distance < 0.0) {
                shiftY = 1;
            } else if (r.y + distance > this.dimensions.y) {
                shiftY = -1;
            }
            if (shiftX == 0) {
                if (shiftY == 0) {
                    return this.shift0;
                }
                this.shift1[0][0] = 0.0;
                this.shift1[0][1] = (double)shiftY * this.dimensions.y;
                return this.shift1;
            }
            if (shiftY == 0) {
                this.shift1[0][0] = (double)shiftX * this.dimensions.x;
                this.shift1[0][1] = 0.0;
                return this.shift1;
            }
            this.shift3[0][0] = (double)shiftX * this.dimensions.x;
            this.shift3[0][1] = 0.0;
            this.shift3[1][0] = 0.0;
            this.shift3[1][1] = (double)shiftY * this.dimensions.y;
            this.shift3[2][0] = this.shift3[0][0];
            this.shift3[2][1] = this.shift3[1][1];
            return this.shift3;
        }

        public Simulation getParentSimulation() {
            return this.simulation;
        }

        public double[][] imageOrigins(int nShells) {
            int nImages = (2 * nShells + 1) * (2 * nShells + 1) - 1;
            double[][] origins = new double[nImages][2];
            int k = 0;
            int i = -nShells;
            while (i <= nShells) {
                int j = -nShells;
                while (j <= nShells) {
                    if (i != 0 || j != 0) {
                        origins[k][0] = (double)i * this.dimensions.x;
                        origins[k][1] = (double)j * this.dimensions.y;
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            return origins;
        }

        public void inflate(double scale) {
            this.dimensions.TE(scale);
        }

        public double lastCollisionVirial() {
            return 0.0;
        }

        public void nearestImage(Space.Vector dr) {
            this.nearestImage((Vector)dr);
        }

        public void nearestImage(Vector dr) {
            dr.x = dr.x - this.dimensions.x * (dr.x > 0.0 ? Math.floor(dr.x / this.dimensions.x + 0.5) : Math.ceil(dr.x / this.dimensions.x - 0.5));
            dr.y = dr.y - this.dimensions.y * (dr.y > 0.0 ? Math.floor(dr.y / this.dimensions.y + 0.5) : Math.ceil(dr.y / this.dimensions.y - 0.5));
        }

        public boolean overlap(AtomPair pair) {
            return false;
        }

        public Space.Vector randomPosition() {
            this.temp.x = this.dimensions.x * random.nextDouble();
            this.temp.y = this.dimensions.y * random.nextDouble();
            return this.temp;
        }

        public void setParentSimulation(Simulation s) {
            this.simulation = s;
        }

        public double volume() {
            return this.dimensions.x * this.dimensions.y;
        }
    }
}

