/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import java.awt.Color;
import java.awt.Graphics;
import java.util.Random;
import simulate.DisplayConfiguration;
import simulate.Space;

public class Space1D
extends Space {
    public static final int D = 1;
    public static int drawingHeight = 10;

    public final int D() {
        return 1;
    }

    public Space.Boundary makeBoundary(int b) {
        switch (b) {
            case 0: {
                return new BoundaryNone();
            }
            case 1: {
                return new BoundaryPeriodicSquare();
            }
        }
        return null;
    }

    public Space.Coordinate makeCoordinate(Space.Occupant o) {
        return new Coordinate(o);
    }

    public Space.CoordinatePair makeCoordinatePair(Space.Boundary boundary) {
        return new CoordinatePair((Boundary)boundary);
    }

    public Space.Vector makeVector() {
        return new Vector();
    }

    public double sphereArea(double r) {
        return 2.0;
    }

    public double sphereVolume(double r) {
        return 2.0 * r;
    }

    public static final class Vector
    extends Space.Vector {
        public static final Random random = new Random();
        public static final Vector ORIGIN = new Vector(0.0);
        double x;

        public Vector() {
            this.x = 0.0;
        }

        public Vector(double a1) {
            this.x = a1;
        }

        public void DE(double a) {
            this.x /= a;
        }

        public void DE(Space.Vector u) {
            this.DE((Vector)u);
        }

        public void E(double a) {
            this.x = a;
        }

        public void E(int i, double a) {
            this.x = a;
        }

        public void E(Space.Vector u) {
            this.E((Vector)u);
        }

        public void E(Vector u) {
            this.x = u.x;
        }

        public void Ea1Tv1(double a1, Space.Vector u) {
            Vector u1 = (Vector)u;
            this.x = a1 * u1.x;
        }

        public void ME(Space.Vector u) {
            this.ME((Vector)u);
        }

        public void ME(Vector u) {
            this.x -= u.x;
        }

        public void PE(int i, double a) {
            this.x += a;
        }

        public void PE(Space.Vector u) {
            this.PE((Vector)u);
        }

        public void PE(Vector u) {
            this.x += u.x;
        }

        public void PEa1Tv1(double a1, Space.Vector u) {
            Vector u1 = (Vector)u;
            this.x += a1 * u1.x;
        }

        public void TE(double a) {
            this.x *= a;
        }

        public void TE(int i, double a) {
            this.x *= a;
        }

        public void TE(Space.Vector u) {
            this.TE((Vector)u);
        }

        public double component(int i) {
            return this.x;
        }

        public double dot(Space.Vector u) {
            return this.dot((Vector)u);
        }

        public double dot(Vector u) {
            return this.x * u.x;
        }

        public void randomDirection() {
            this.x = random.nextDouble() < 0.5 ? -1.0 : 1.0;
        }

        public void randomStep(double d) {
            this.x += (2.0 * random.nextDouble() - 1.0) * d;
        }

        public void setComponent(int i, double d) {
            this.x = d;
        }

        public void setRandom(double d) {
            this.x = random.nextDouble() * d;
        }

        public void setRandom(double dx, double dy) {
            this.x = random.nextDouble() * dx;
        }

        public void setRandom(Vector u) {
            this.setRandom(u.x);
        }

        public void setRandomCube() {
            this.x = random.nextDouble() - 0.5;
        }

        public void setRandomSphere() {
            this.setRandomCube();
        }

        public void setToOrigin() {
            this.x = Vector.ORIGIN.x;
        }

        public double squared() {
            return this.x * this.x;
        }
    }

    protected static final class CoordinatePair
    extends Space.CoordinatePair {
        Coordinate c1;
        Coordinate c2;
        final Boundary boundary;
        final Vector dimensions;
        private final Vector dr = new Vector();
        private double drx;
        private double dvx;

        public CoordinatePair() {
            this.boundary = new BoundaryNone();
            this.dimensions = (Vector)this.boundary.dimensions();
        }

        public CoordinatePair(Space.Boundary b) {
            this.boundary = (Boundary)b;
            this.dimensions = (Vector)this.boundary.dimensions();
        }

        public Space.Vector dr() {
            return this.dr;
        }

        public double dr(int i) {
            return this.drx;
        }

        public double dv(int i) {
            return this.dvx;
        }

        public void push(double impulse) {
            this.c1.p.x += impulse * this.drx;
            this.c2.p.x -= impulse * this.drx;
        }

        public void reset() {
            this.dr.x = this.c2.r.x - this.c1.r.x;
            this.boundary.nearestImage(this.dr);
            this.drx = this.dr.x;
            this.r2 = this.drx * this.drx;
            double rm1 = this.c1.parent().rm();
            double rm2 = this.c2.parent().rm();
            this.dvx = rm2 * this.c2.p.x - rm1 * this.c1.p.x;
        }

        public void reset(Space.Coordinate coord1, Space.Coordinate coord2) {
            this.c1 = (Coordinate)coord1;
            this.c2 = (Coordinate)coord2;
            this.reset();
        }

        public void reset(Vector M) {
            this.drx = this.dr.x = this.c2.r.x - this.c1.r.x + M.x;
            this.r2 = this.drx * this.drx;
        }

        public void setSeparation(double r2New) {
            double ratio = this.c2.parent().mass() * this.c1.parent().rm();
            double delta = (Math.sqrt(r2New / this.r2()) - 1.0) / (1.0 + ratio);
            this.c1.r.x -= ratio * delta * this.drx;
            this.c2.r.x += delta * this.drx;
        }

        public double v2() {
            return this.dvx * this.dvx;
        }

        public double vDotr() {
            return this.drx * this.dvx;
        }
    }

    static class Coordinate
    extends Space.Coordinate {
        public final Vector r = new Vector();
        public final Vector p = new Vector();

        public Coordinate(Space.Occupant o) {
            super(o);
        }

        public final double kineticEnergy(double mass) {
            return 0.5 * this.p.squared() / mass;
        }

        public Space.Vector makeVector() {
            return new Vector();
        }

        public Space.Vector momentum() {
            return this.p;
        }

        public double momentum(int i) {
            return this.p.component(i);
        }

        public Space.Vector position() {
            return this.r;
        }

        public double position(int i) {
            return this.r.component(i);
        }
    }

    public static abstract class Boundary
    extends Space.Boundary {
        public static final int NONE = 0;
        public static final int PERIODIC_SQUARE = 1;

        public abstract void centralImage(Vector var1);

        public abstract void nearestImage(Vector var1);
    }

    protected static final class BoundaryNone
    extends Boundary {
        private final Vector temp = new Vector();
        private final double[][] shift0 = new double[0][1];
        public final Vector dimensions = new Vector();
        public static final Random random = new Random();

        protected BoundaryNone() {
        }

        public void centralImage(Space.Vector r) {
        }

        public void centralImage(Vector r) {
        }

        public final Space.Vector dimensions() {
            return this.dimensions;
        }

        public void draw(Graphics g, int[] origin, double scale) {
        }

        public double[][] getOverflowShifts(Space.Vector rr, double distance) {
            return this.shift0;
        }

        public double[][] imageOrigins(int nShells) {
            return new double[0][1];
        }

        public void inflate(double s) {
        }

        public void nearestImage(Space.Vector dr) {
        }

        public void nearestImage(Vector dr) {
        }

        public Space.Vector randomPosition() {
            this.temp.x = random.nextDouble();
            return this.temp;
        }

        public double volume() {
            return Double.MAX_VALUE;
        }
    }

    protected static final class BoundaryPeriodicSquare
    extends Boundary {
        private final Vector temp = new Vector();
        public static final Random random = new Random();
        private final double[][] shift0 = new double[0][2];
        private final double[][] shift1 = new double[1][2];
        public final Vector dimensions = new Vector();

        public BoundaryPeriodicSquare() {
            this(1.0);
        }

        public BoundaryPeriodicSquare(double lx) {
            this.dimensions.x = lx;
        }

        public void centralImage(Space.Vector r) {
            this.centralImage((Vector)r);
        }

        public void centralImage(Vector r) {
            r.x = r.x - this.dimensions.x * (r.x > 0.0 ? Math.floor(r.x / this.dimensions.x) : Math.ceil(r.x / this.dimensions.x - 1.0));
        }

        public final Space.Vector dimensions() {
            return this.dimensions;
        }

        public void draw(Graphics g, int[] origin, double scale) {
            g.setColor(Color.gray);
            double toPixels = scale * DisplayConfiguration.SIM2PIXELS;
            g.drawRect(origin[0], origin[1], (int)(toPixels * this.dimensions.component(0)) - 1, (int)(toPixels * this.dimensions.component(1)) - 1);
        }

        public double[][] getOverflowShifts(Space.Vector rr, double distance) {
            Vector r = (Vector)rr;
            int shiftX = 0;
            if (r.x - distance < 0.0) {
                shiftX = 1;
            } else if (r.x + distance > this.dimensions.x) {
                shiftX = -1;
            }
            if (shiftX == 0) {
                return this.shift0;
            }
            this.shift1[0][0] = (double)shiftX * this.dimensions.x;
            return this.shift1;
        }

        public double[][] imageOrigins(int nShells) {
            int nImages = 2 * nShells;
            double[][] origins = new double[nImages][1];
            int k = 0;
            int i = -nShells;
            while (i <= nShells) {
                if (i != 0) {
                    origins[k][0] = (double)i * this.dimensions.x;
                    ++k;
                }
                ++i;
            }
            return origins;
        }

        public void inflate(double scale) {
            this.dimensions.TE(scale);
        }

        public void nearestImage(Space.Vector dr) {
            this.nearestImage((Vector)dr);
        }

        public void nearestImage(Vector dr) {
            dr.x = dr.x - this.dimensions.x * (dr.x > 0.0 ? Math.floor(dr.x / this.dimensions.x + 0.5) : Math.ceil(dr.x / this.dimensions.x - 0.5));
        }

        public Space.Vector randomPosition() {
            this.temp.x = this.dimensions.x * random.nextDouble();
            return this.temp;
        }

        public double volume() {
            return this.dimensions.x;
        }
    }
}

