/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import simulate.AtomPair;
import simulate.PotentialSoft;
import simulate.Simulation;
import simulate.Space;
import simulate.electrostatics.ElectroType;

public class PotentialPrimitive
implements PotentialSoft {
    private double sigma;
    private double sigmaSquared;
    private double cutoffRadius;
    private double cutoffRadiusSquared;
    private double cutoff;
    private double eLRC;
    private double pLRC;
    private Space.Vector force;
    Simulation parentSimulation;

    public PotentialPrimitive(double sigma, double cutoff) {
        this.setSigma(sigma);
        this.setCutoff(cutoff);
    }

    private void calculateLRC() {
    }

    public double energy(AtomPair pair) {
        double r2 = pair.r2();
        if (r2 > this.cutoffRadiusSquared) {
            return 0.0;
        }
        if (r2 < this.sigmaSquared) {
            return Double.MAX_VALUE;
        }
        double z1 = ((ElectroType.Monopole)pair.atom1.type.electroType()).z();
        double z2 = ((ElectroType.Monopole)pair.atom2.type.electroType()).z();
        return z1 * z2 / Math.sqrt(r2);
    }

    public double energyLRC(int n1, int n2, double V) {
        return (double)(n1 * n2) * this.eLRC / V;
    }

    public Space.Vector force(AtomPair pair) {
        double r2 = pair.r2();
        if (r2 > this.cutoffRadiusSquared) {
            this.force.E(0.0);
        } else if (r2 < this.sigmaSquared) {
            this.force.E(Double.MAX_VALUE);
        } else {
            double z1 = ((ElectroType.Monopole)pair.atom1.type.electroType()).z();
            double z2 = ((ElectroType.Monopole)pair.atom2.type.electroType()).z();
            double c = z1 * z2 / Math.sqrt(r2);
            this.force.E(pair.dr());
            this.force.TE(-c / r2);
        }
        return this.force;
    }

    public double getCutoff() {
        return this.cutoff;
    }

    public Simulation getParentSimulation() {
        return this.parentSimulation;
    }

    public double getSigma() {
        return this.sigma;
    }

    public boolean overlap(AtomPair pair) {
        return pair.r2() < this.sigmaSquared;
    }

    public double pressureLRC(int n1, int n2, double V) {
        return (double)(n1 * n2) * this.pLRC / (V * V);
    }

    public void setCutoff(double rc) {
        this.cutoff = rc;
        this.cutoffRadius = this.sigma * this.cutoff;
        this.cutoffRadiusSquared = this.cutoffRadius * this.cutoffRadius;
        this.calculateLRC();
    }

    public void setParentSimulation(Simulation s) {
        this.parentSimulation = s;
        this.force = Simulation.space().makeVector();
    }

    public void setSigma(double s) {
        this.sigma = s;
        this.sigmaSquared = s * s;
        this.setCutoff(this.cutoff);
    }

    public double virial(AtomPair pair) {
        return 0.0;
    }
}

