/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import java.awt.Component;
import simulate.Integrator;
import simulate.Phase;

public abstract class MCMove
extends Component {
    int frequency;
    int nominalFrequency;
    double acceptanceRatio;
    double acceptanceTarget;
    double stepSize;
    double stepSizeMax;
    double stepSizeMin;
    int nTrials = 0;
    int nAccept = 0;
    int nTrialsSum;
    int nAcceptSum;
    int adjustInterval;
    boolean perParticleFrequency;
    Integrator parentIntegrator;
    protected MCMove nextMove;
    protected boolean tunable;

    public MCMove() {
        this.setAcceptanceTarget(0.5);
        this.setFrequency(1);
        this.setPerParticleFrequency(false);
        this.setAdjustInterval(100);
    }

    public double acceptanceRatio() {
        return this.acceptanceRatio;
    }

    public void adjustStepSize() {
        if (this.nTrials == 0) {
            return;
        }
        this.nTrialsSum += this.nTrials;
        this.nAcceptSum += this.nAccept;
        if (this.nTrialsSum != 0) {
            this.acceptanceRatio = (double)this.nAcceptSum / (double)this.nTrialsSum;
        }
        if (!this.tunable) {
            return;
        }
        this.stepSize = this.nAccept > (int)(this.acceptanceTarget * (double)this.nTrials) ? (this.stepSize *= 1.05) : (this.stepSize *= 0.95);
        this.stepSize = Math.min(this.stepSize, this.stepSizeMax);
        this.stepSize = Math.max(this.stepSize, this.stepSizeMin);
        this.nTrials = 0;
        this.nAccept = 0;
    }

    public void doTrial(Phase phase) {
        ++this.nTrials;
        this.thisTrial(phase);
        if (this.nTrials > this.adjustInterval * this.frequency) {
            this.adjustStepSize();
        }
    }

    public final double getAcceptanceTarget() {
        return this.acceptanceTarget;
    }

    public final int getAdjustInterval() {
        return this.adjustInterval;
    }

    public final int getFrequency() {
        return this.frequency;
    }

    public final double getStepSize() {
        return this.stepSize;
    }

    public final double getStepSizeMax() {
        return this.stepSizeMax;
    }

    public final double getStepSizeMin() {
        return this.stepSizeMin;
    }

    public final boolean getTunable() {
        return this.tunable;
    }

    public final boolean isPerParticleFrequency() {
        return this.perParticleFrequency;
    }

    public final MCMove nextMove() {
        return this.nextMove;
    }

    public void resetFrequency(Phase phase) {
        this.frequency = this.perParticleFrequency ? this.nominalFrequency * phase.moleculeCount : this.nominalFrequency;
    }

    public final void setAcceptanceTarget(double a) {
        this.nTrialsSum = 0;
        this.nAcceptSum = 0;
        this.acceptanceTarget = a;
    }

    public final void setAdjustInterval(int i) {
        this.adjustInterval = i;
    }

    public void setFrequency(int f) {
        this.nominalFrequency = f;
        this.frequency = f;
    }

    public final void setNextMove(MCMove move) {
        this.nextMove = move;
    }

    public final void setPerParticleFrequency(boolean b) {
        this.perParticleFrequency = b;
    }

    public final void setStepSize(double step) {
        this.stepSize = step;
    }

    public final void setStepSizeMax(double step) {
        this.stepSizeMax = step;
    }

    public final void setStepSizeMin(double step) {
        this.stepSizeMin = step;
    }

    public final void setTunable(boolean b) {
        this.tunable = b;
    }

    public abstract void thisTrial(Phase var1);
}

