/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import java.awt.Button;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import simulate.Controller;
import simulate.Integrator;

public class ControllerButton
extends Controller
implements MouseListener {
    public Button button = new Button("Start");
    public boolean autoStart;
    private boolean firstClick = true;
    private boolean running = false;

    public ControllerButton() {
        this.button.setBounds(0, 0, 60, 40);
        this.button.setBackground(new Color(0xC0C0C0));
        this.add(this.button);
        this.autoStart = false;
        this.button.addMouseListener(this);
    }

    public void add(Integrator i) {
        super.add(i);
        if (this.autoStart) {
            this.clickButton();
        }
    }

    public void clickButton() {
        this.mouseClicked(new MouseEvent(this.button, 500, 1L, 0, 0, 0, 0, false));
    }

    public void clickForPause() {
        if (this.running) {
            this.clickButton();
        }
    }

    public boolean getAutoStart() {
        return this.autoStart;
    }

    public Color getButtonColor() {
        return this.button.getBackground();
    }

    public Color getButtonTextColor() {
        return this.button.getForeground();
    }

    public void mouseClicked(MouseEvent evt) {
        if (this.firstClick) {
            Integrator i = this.firstIntegrator;
            while (i != null) {
                i.start();
                i = i.nextIntegrator;
            }
            this.running = true;
            this.firstClick = false;
            this.button.setLabel("Pause");
        } else if (this.running) {
            this.running = false;
            Integrator i = this.firstIntegrator;
            while (i != null) {
                i.pause();
                i = i.nextIntegrator;
            }
            this.button.setLabel("Continue");
        } else {
            Integrator i = this.firstIntegrator;
            while (i != null) {
                i.unPause();
                i = i.nextIntegrator;
            }
            this.running = true;
            this.button.setLabel("Pause");
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void reset() {
        this.firstClick = true;
        this.button.setLabel("Start");
    }

    public void run() {
    }

    public void setAutoStart(boolean b) {
        this.autoStart = b;
    }

    public void setButtonColor(Color c) {
        this.button.setBackground(c);
    }

    public void setButtonTextColor(Color c) {
        this.button.setForeground(c);
    }
}

