/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import java.awt.Graphics;
import java.awt.Rectangle;
import simulate.DisplayConfiguration;
import simulate.MeterLocalDensity;
import simulate.Molecule;
import simulate.Space2D;

public class MeterLocalDensityCube
extends MeterLocalDensity {
    double xCenter;
    double yCenter;
    double halfWidth;
    double halfHeight;

    public MeterLocalDensityCube() {
        this.setBounds(0, 0, 300, 300);
    }

    public void computeVolume() {
        Rectangle rectangle = this.getBounds();
        this.halfWidth = 0.5 * (double)rectangle.width / DisplayConfiguration.SIM2PIXELS;
        this.halfHeight = 0.5 * (double)rectangle.height / DisplayConfiguration.SIM2PIXELS;
        this.volume = 4.0 * this.halfWidth * this.halfHeight;
        this.xCenter = (double)rectangle.x / DisplayConfiguration.SIM2PIXELS + this.halfWidth;
        this.yCenter = (double)rectangle.y / DisplayConfiguration.SIM2PIXELS + this.halfHeight;
    }

    public boolean contains(Molecule m) {
        Space2D.Vector r = (Space2D.Vector)m.COM();
        if (Math.abs(r.x - this.xCenter) > this.halfWidth) {
            return false;
        }
        return !(Math.abs(r.y - this.yCenter) > this.halfHeight);
    }

    public void draw(Graphics g, int[] origin, double scale) {
        Rectangle rectangle = this.getBounds();
        int x0 = origin[0] + (int)((double)rectangle.x * scale);
        int y0 = origin[1] + (int)((double)rectangle.y * scale);
        int w = (int)((double)rectangle.width * scale);
        int h = (int)((double)rectangle.height * scale);
        g.drawRect(x0, y0, w, h);
    }
}

