/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.Beans;

public abstract class DisplayCanvas
extends Canvas
implements MouseListener,
MouseMotionListener,
KeyListener {
    Image offScreen;
    Graphics osg;
    int pixels = 300;
    static final int DEFAULT_AREA = 0;
    static final int MOVE_AREA = 1;
    static final int RESIZE_AREA_NW = 2;
    static final int RESIZE_AREA_NE = 3;
    static final int RESIZE_AREA_SW = 4;
    static final int RESIZE_AREA_SE = 5;
    static final Cursor curDefault = new Cursor(0);
    static final Cursor curMove = new Cursor(13);
    static final Cursor curResize1 = new Cursor(6);
    static final Cursor curResize2 = new Cursor(7);
    int offset = 10;
    boolean moving = false;
    boolean resizing = false;
    boolean mouseInside = false;
    int cursorLocation = 0;
    Point anchor;
    Point anchorAbs = new Point();
    Point initialLocation;
    Dimension initialSize;
    boolean resizable = false;
    boolean movable = false;

    public DisplayCanvas() {
        this.setSize(this.pixels, this.pixels);
        this.setBackground(Color.white);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
    }

    public void changeSize(int w, int h, MouseEvent e) {
        if (e.isShiftDown()) {
            int x = Math.max(w, h);
            this.setSize(x, x);
            this.createOffScreen(x);
        } else {
            this.setSize(w, h);
            this.createOffScreen(w, h);
        }
    }

    public void createOffScreen() {
        if (this.offScreen == null) {
            this.createOffScreen(this.pixels);
        }
    }

    public void createOffScreen(int p) {
        this.createOffScreen(p, p);
    }

    public void createOffScreen(int w, int h) {
        this.offScreen = this.createImage(w, h);
        this.osg = this.offScreen.getGraphics();
    }

    protected void digitTyped(int i) {
    }

    public abstract void doPaint(Graphics var1);

    public boolean isMovable() {
        return this.movable;
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
        char c = e.getKeyChar();
        if (Character.isDigit(c)) {
            this.digitTyped(Character.getNumericValue(c));
        } else if (Character.isLetter(c)) {
            this.letterTyped(c);
        }
    }

    protected void letterTyped(char c) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        int deltaX = this.getLocation().x + e.getX() - this.anchorAbs.x;
        int deltaY = this.getLocation().y + e.getY() - this.anchorAbs.y;
        if (this.moving) {
            int ix = this.initialLocation.x + deltaX;
            int iy = this.initialLocation.y + deltaY;
            this.setLocation(ix, iy);
        } else if (this.resizing) {
            if (this.cursorLocation == 2) {
                deltaX *= -1;
                deltaY *= -1;
            } else if (this.cursorLocation == 4) {
                deltaX *= -1;
            } else if (this.cursorLocation == 3) {
                deltaY *= -1;
            }
            int w = this.initialSize.width + deltaX;
            int h = this.initialSize.height + deltaY;
            this.changeSize(w, h, e);
        }
    }

    public void mouseEntered(MouseEvent e) {
        this.requestFocus();
        this.mouseInside = true;
    }

    public void mouseExited(MouseEvent e) {
        this.transferFocus();
        this.mouseInside = false;
    }

    public void mouseMoved(MouseEvent e) {
        if (!this.movable && !this.resizable) {
            return;
        }
        Rectangle r = this.getBounds();
        int x = e.getX();
        int y = e.getY();
        this.cursorLocation = x >= this.offset && x <= r.width - this.offset && y >= this.offset && y <= r.height - this.offset ? 0 : (x >= 0 && x <= this.offset && y >= 0 && y <= this.offset ? 2 : (x >= 0 && x <= this.offset && y >= r.height - this.offset && y <= r.height ? 4 : (x >= r.width - this.offset && x <= r.width && y >= 0 && y <= this.offset ? 3 : (x >= r.width - this.offset && x <= r.width && y >= r.height - this.offset && y <= r.height ? 5 : (x >= 0 && x <= r.width && y >= 0 && y <= r.height ? 1 : 0)))));
        if (this.movable && this.cursorLocation == 1) {
            this.setCursor(curMove);
        } else if (this.resizable && (this.cursorLocation == 2 || this.cursorLocation == 5)) {
            this.setCursor(curResize1);
        } else if (this.resizable && (this.cursorLocation == 3 || this.cursorLocation == 4)) {
            this.setCursor(curResize2);
        } else {
            this.setCursor(curDefault);
        }
    }

    public void mousePressed(MouseEvent e) {
        this.anchor = new Point(e.getX(), e.getY());
        this.moving = false;
        this.resizing = false;
        if (this.cursorLocation != 0) {
            if (this.cursorLocation == 1) {
                this.moving = true;
            } else {
                this.resizing = true;
            }
            this.initialLocation = this.getLocation();
            this.initialSize = this.getSize();
            this.anchorAbs.x = this.anchor.x + this.initialLocation.x;
            this.anchorAbs.y = this.anchor.y + this.initialLocation.y;
        }
    }

    public void mouseReleased(MouseEvent e) {
        Point p = new Point(e.getX(), e.getY());
        this.moving = false;
        this.resizing = false;
        boolean bl = (p.x - this.anchor.x) * (p.x - this.anchor.x) <= 4 && (p.y - this.anchor.y) * (p.y - this.anchor.y) <= 4;
    }

    public void paint(Graphics g) {
        if (Beans.isDesignTime()) {
            g.setColor(Color.red);
            g.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
            g.drawRect(1, 1, this.getSize().width - 3, this.getSize().height - 3);
        }
        this.createOffScreen();
        this.doPaint(this.osg);
        g.drawImage(this.offScreen, 0, 0, null);
    }

    public void setMovable(boolean b) {
        this.movable = b;
    }

    public void setResizable(boolean b) {
        this.resizable = b;
    }

    public void update(Graphics g) {
        this.paint(g);
    }
}

