/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import java.awt.Color;
import simulate.AtomType;
import simulate.ColorSchemeByType;
import simulate.ConfigurationMoleculeLinear;
import simulate.Simulation;
import simulate.SpeciesDisks;

public class SpeciesDiskWell
extends SpeciesDisks {
    double lambda;
    Color wellColor;

    public SpeciesDiskWell() {
        this.setSpeciesIndex(0);
        this.setAtomsPerMolecule(1);
        this.protoType = new AtomType.Well(1.0, Color.black, 3.5, 1.5);
        this.colorScheme = new ColorSchemeByType();
        this.configurationMolecule = new ConfigurationMoleculeLinear();
        this.setNMolecules(20);
    }

    public SpeciesDiskWell(Simulation ps) {
        this(ps, 20, 1);
    }

    public SpeciesDiskWell(Simulation ps, int nM, int nA) {
        super(ps, nM, nA, new AtomType.Well(1.0, Color.black, 3.5, 1.5));
    }

    public double getLambda() {
        return ((AtomType.Well)this.protoType).lambda();
    }

    public void setLambda(double lam) {
        ((AtomType.Well)this.protoType).setLambda(lam);
    }
}

