/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import simulate.AtomPair;
import simulate.PotentialHard;
import simulate.Simulation;

public class PotentialSquareWell
implements PotentialHard {
    private double coreDiameter;
    private double coreDiameterSquared;
    private double wellDiameter;
    private double wellDiameterSquared;
    private double lambda;
    private double epsilon;
    Simulation parentSimulation;

    public PotentialSquareWell(double coreDiameter, double lambda, double epsilon) {
        this.setCoreDiameter(coreDiameter);
        this.setLambda(lambda);
        this.setEpsilon(epsilon);
    }

    public void bump(AtomPair pair) {
        double r2New;
        double s;
        double eps = 1.0E-6;
        double r2 = pair.r2();
        double bij = pair.vDotr();
        double reduced_m = 1.0 / (pair.atom1().rm() + pair.atom2().rm());
        double ke = bij * bij * reduced_m / (2.0 * r2);
        if (2.0 * r2 < this.coreDiameterSquared + this.wellDiameterSquared) {
            s = 2.0 * reduced_m * bij / r2;
            r2New = r2;
        } else if (bij > 0.0) {
            if (ke < this.epsilon) {
                s = 2.0 * reduced_m * bij / r2;
                r2New = (1.0 - eps) * this.wellDiameterSquared;
            } else {
                s = reduced_m * (bij - Math.sqrt(bij * bij - 2.0 * r2 * this.epsilon / reduced_m)) / r2;
                r2New = (1.0 + eps) * this.wellDiameterSquared;
            }
        } else {
            s = reduced_m * (bij + Math.sqrt(bij * bij + 2.0 * r2 * this.epsilon / reduced_m)) / r2;
            r2New = (1.0 - eps) * this.wellDiameterSquared;
        }
        pair.cPair.push(s);
        if (r2New != r2) {
            pair.cPair.setSeparation(r2New);
        }
    }

    public double collisionTime(AtomPair pair) {
        double discr = 0.0;
        double bij = pair.vDotr();
        double r2 = pair.r2();
        double v2 = pair.v2();
        double tij = Double.MAX_VALUE;
        if (r2 < this.wellDiameterSquared) {
            if (r2 < this.coreDiameterSquared) {
                return bij < 0.0 ? 0.0 : (-bij + Math.sqrt(bij * bij - v2 * (r2 - this.wellDiameterSquared))) / v2;
            }
            if (bij < 0.0) {
                discr = bij * bij - v2 * (r2 - this.coreDiameterSquared);
                if (discr > 0.0) {
                    tij = (-bij - Math.sqrt(discr)) / v2;
                } else {
                    discr = bij * bij - v2 * (r2 - this.wellDiameterSquared);
                    tij = (-bij + Math.sqrt(discr)) / v2;
                }
            } else {
                discr = bij * bij - v2 * (r2 - this.wellDiameterSquared);
                tij = (-bij + Math.sqrt(discr)) / v2;
            }
        } else if (bij < 0.0 && (discr = bij * bij - v2 * (r2 - this.wellDiameterSquared)) > 0.0) {
            tij = (-bij - Math.sqrt(discr)) / v2;
        }
        return tij;
    }

    public double energy(AtomPair pair) {
        double r2 = pair.r2();
        return r2 < this.wellDiameterSquared ? (r2 < this.coreDiameterSquared ? Double.MAX_VALUE : -this.epsilon) : 0.0;
    }

    public double getCoreDiameter() {
        return this.coreDiameter;
    }

    public double getEpsilon() {
        return this.epsilon;
    }

    public double getLambda() {
        return this.lambda;
    }

    public Simulation getParentSimulation() {
        return this.parentSimulation;
    }

    public double lastCollisionVirial() {
        return 0.0;
    }

    public boolean overlap(AtomPair pair) {
        return pair.r2() < this.coreDiameterSquared;
    }

    public void setCoreDiameter(double c) {
        this.coreDiameter = c;
        this.coreDiameterSquared = c * c;
        this.wellDiameter = this.coreDiameter * this.lambda;
        this.wellDiameterSquared = this.wellDiameter * this.wellDiameter;
    }

    public void setEpsilon(double eps) {
        this.epsilon = eps;
    }

    public void setLambda(double lam) {
        this.lambda = lam;
        this.wellDiameter = this.coreDiameter * this.lambda;
        this.wellDiameterSquared = this.wellDiameter * this.wellDiameter;
    }

    public void setParentSimulation(Simulation s) {
        this.parentSimulation = s;
    }
}

