/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.beans.Beans;
import simulate.Atom;
import simulate.Default;
import simulate.Potential;
import simulate.Potential2;
import simulate.PotentialSquareWell;
import simulate.units.Unit;

public class P2SquareWell
extends Potential2 {
    private double coreDiameter;
    private Unit.Length coreDiameterUnit;
    private double epsilon;
    private Unit.Energy epsilonUnit;
    private double lambda = 1.5;

    public P2SquareWell() {
        this.nAtoms1 = 1;
        this.nAtoms2 = 1;
        this.potential = new Potential[this.nAtoms1][this.nAtoms2];
        this.setCoreDiameter(3.0, Default.ATOM_SIZE_UNIT);
        this.setEpsilon(300.0, Default.POTENTIAL_WELL_UNIT);
        this.setLambda(this.lambda);
        this.potential[0][0] = new PotentialSquareWell(this.coreDiameter, this.lambda, this.epsilon);
    }

    public final double coreDiameter() {
        return this.coreDiameter;
    }

    public final double epsilon() {
        return this.epsilon;
    }

    public final double getCoreDiameter() {
        return this.coreDiameterUnit.fromSim(this.coreDiameter);
    }

    public Unit.Length getCoreDiameterUnit() {
        return this.coreDiameterUnit;
    }

    public final double getEpsilon() {
        return this.epsilonUnit.fromSim(this.epsilon);
    }

    public Unit.Energy getEpsilonUnit() {
        return this.epsilonUnit;
    }

    public final double getLambda() {
        return this.lambda;
    }

    public final Potential getPotential(Atom a1, Atom a2) {
        return this.potential[0][0];
    }

    public void paint(Graphics g) {
        int[] simulationPixelDimensions = new int[]{-1, -1};
        if (Beans.isDesignTime() && this.getParent() != null) {
            Container par = this.getParent();
            simulationPixelDimensions[0] = par.getSize().width;
            simulationPixelDimensions[1] = par.getSize().height;
            double scale = Math.max(simulationPixelDimensions[0], simulationPixelDimensions[1]);
            int moleculePixelDiameter = (int)(scale * this.coreDiameter);
            int wellPixelDiameter = (int)(scale * this.lambda * this.coreDiameter);
            g.setColor(Color.red);
            g.fillOval((wellPixelDiameter - moleculePixelDiameter) / 2, (wellPixelDiameter - moleculePixelDiameter) / 2, moleculePixelDiameter, moleculePixelDiameter);
            g.setColor(Color.blue);
            g.drawOval(0, 0, wellPixelDiameter, wellPixelDiameter);
        }
    }

    public final void setCoreDiameter(double d) {
        this.coreDiameter = this.coreDiameterUnit.toSim(d);
        this.setPotentialCutoff(this.coreDiameter * this.lambda);
        if (this.potential[0][0] != null) {
            ((PotentialSquareWell)this.potential[0][0]).setCoreDiameter(this.coreDiameter);
        }
    }

    public final void setCoreDiameter(double d, Unit.Length u) {
        this.coreDiameterUnit = u;
        this.setCoreDiameter(d);
    }

    public final void setCoreDiameterUnit(Unit.Length u) {
        this.coreDiameterUnit = u;
    }

    public final void setEpsilon(double eps) {
        this.epsilon = this.epsilonUnit.toSim(eps);
        if (this.potential[0][0] != null) {
            ((PotentialSquareWell)this.potential[0][0]).setEpsilon(this.epsilon);
        }
    }

    public final void setEpsilon(double eps, Unit.Energy u) {
        this.epsilonUnit = u;
        this.setEpsilon(eps);
    }

    public final void setEpsilonUnit(Unit.Energy u) {
        this.epsilonUnit = u;
    }

    public final void setLambda(double lam) {
        this.lambda = lam;
        this.setPotentialCutoff(this.coreDiameter * this.lambda);
        if (this.potential[0][0] != null) {
            ((PotentialSquareWell)this.potential[0][0]).setLambda(this.lambda);
        }
    }
}

