/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import simulate.AtomPair;
import simulate.MeterFunction;
import simulate.Phase;
import simulate.Simulation;
import simulate.Space;

public class MeterRDF
extends MeterFunction {
    private AtomPair.Iterator iterator;
    private double[] vShell;
    private double delr;

    public MeterRDF() {
        this.setXLabel("r");
        this.setLabel("rdf");
    }

    public double[] currentValue() {
        this.iterator.reset();
        int i = 0;
        while (i < this.nPoints) {
            this.y[i] = 0.0;
            ++i;
        }
        while (this.iterator.hasNext()) {
            int index;
            double r = Math.sqrt(this.iterator.next().r2());
            if (!(r < this.xMax)) continue;
            int n = index = (int)(r / this.delr);
            this.y[n] = this.y[n] + 2.0;
        }
        int n = this.phase.atomCount();
        double norm = (double)(n * n) / this.phase.volume();
        int i2 = 0;
        while (i2 < this.nPoints) {
            int n2 = i2;
            this.y[n2] = this.y[n2] / (norm * this.vShell[i2]);
            ++i2;
        }
        return this.y;
    }

    public void setPhase(Phase p) {
        super.setPhase(p);
        this.iterator = this.phase.iterator().makeAtomPairIteratorAll();
        this.setX(0.0, 0.5 * this.phase.boundary().dimensions().component(0), this.nPoints);
    }

    public void setX(double min, double max, int n) {
        super.setX(min, max, n);
        if (this.phase == null) {
            return;
        }
        this.vShell = new double[n];
        Simulation cfr_ignored_0 = this.phase.parentSimulation;
        Space space = Simulation.space;
        double dx2 = 0.5 * (this.xMax - this.xMin) / (double)this.nPoints;
        int i = 0;
        while (i < this.nPoints - 1) {
            this.vShell[i] = space.sphereVolume(this.x[i] + dx2) - space.sphereVolume(this.x[i] - dx2);
            ++i;
        }
        this.delr = this.xMax / (double)(this.nPoints - 1);
    }
}

