/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import simulate.MeterAbstract;

public abstract class MeterFunction
extends MeterAbstract {
    protected double[] x;
    protected double[] y;
    private double[] sum;
    private double[] sumSquare;
    private transient double[] average;
    private transient double[] error;
    private int count = 0;
    protected int nPoints = 0;
    protected double xMin;
    protected double xMax;
    protected String xLabel;

    public MeterFunction() {
        this.setX(0.0, 1.0, 100);
        this.setXLabel("x");
    }

    public double[] X() {
        return this.x;
    }

    public double[] average() {
        if (this.count < 1) {
            int i = 0;
            while (i < this.nPoints) {
                this.average[i] = Double.NaN;
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.nPoints) {
                this.average[i] = this.sum[i] / (double)this.count;
                ++i;
            }
        }
        return this.average;
    }

    public abstract double[] currentValue();

    public double[] error() {
        if (this.count <= 1) {
            int i = 0;
            while (i < this.nPoints) {
                this.error[i] = Double.NaN;
                ++i;
            }
        } else {
            double[] avg = this.average();
            int i = 0;
            while (i < this.nPoints) {
                this.error[i] = Math.sqrt((this.sumSquare[i] / (double)this.count - avg[i] * avg[i]) / (double)(this.count - 1));
                ++i;
            }
        }
        return this.error;
    }

    public int getNPoints() {
        return this.nPoints;
    }

    public String getXLabel() {
        return this.xLabel;
    }

    public double getXMax() {
        return this.xMax;
    }

    public double getXMin() {
        return this.xMin;
    }

    public void reset() {
        this.count = 0;
        int i = 0;
        while (i < this.nPoints) {
            this.sum[i] = 0.0;
            this.sumSquare[i] = 0.0;
            ++i;
        }
    }

    public void setNPoints(int n) {
        this.setX(this.xMin, this.xMax, n);
    }

    public void setX(double min, double max, int n) {
        if (n != this.nPoints) {
            this.nPoints = n;
            this.x = new double[n];
            this.y = new double[n];
            this.sum = new double[n];
            this.sumSquare = new double[n];
            this.average = new double[n];
            this.error = new double[n];
            this.reset();
        }
        this.xMin = min;
        this.xMax = max;
        double dx = (this.xMax - this.xMin) / (double)this.nPoints;
        int i = 0;
        while (i < this.nPoints) {
            this.x[i] = this.xMin + ((double)i + 0.5) * dx;
            ++i;
        }
    }

    public void setXLabel(String s) {
        this.xLabel = s;
    }

    public void setXMax(double xm) {
        this.setX(this.xMin, xm, this.nPoints);
    }

    public void setXMin(double xm) {
        this.setX(xm, this.xMax, this.nPoints);
    }

    public void updateSums() {
        double[] values = this.currentValue();
        int i = 0;
        while (i < this.nPoints) {
            double value = values[i];
            if (!Double.isNaN(value)) {
                int n = i;
                this.sum[n] = this.sum[n] + value;
                int n2 = i;
                this.sumSquare[n2] = this.sumSquare[n2] + value * value;
            }
            ++i;
        }
        ++this.count;
    }
}

