/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import simulate.MeterAbstract;

public abstract class Meter
extends MeterAbstract {
    double sum;
    double sumSquare;
    int count;

    public Meter() {
        this.reset();
    }

    public double average() {
        return this.count > 0 ? this.sum / (double)this.count : 0.0;
    }

    public abstract double currentValue();

    public double error() {
        double avg = this.average();
        return this.count > 1 ? Math.sqrt((this.sumSquare / (double)this.count - avg * avg) / (double)(this.count - 1)) : 0.0;
    }

    public void reset() {
        this.count = 0;
        this.sum = 0.0;
        this.sumSquare = 0.0;
    }

    public void updateSums() {
        double value = this.currentValue();
        if (!Double.isNaN(value)) {
            this.sum += value;
            this.sumSquare += value * value;
            ++this.count;
        }
    }
}

