/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import simulate.Display;
import simulate.MeterFunction;
import simulate.units.Unit;

public class DisplayPlot
extends Display {
    Plot plot = new Plot();
    MeterFunction meter;
    Unit xUnit;
    Unit yUnit;

    public DisplayPlot() {
        this.add(this.plot);
        this.setXUnit(Unit.Null.UNIT);
        this.setYUnit(Unit.Null.UNIT);
    }

    public void doUpdate() {
        this.plot.clear(false);
        double[] x = this.meter.X();
        double[] y = this.meter.average();
        int i = 0;
        while (i < x.length) {
            this.plot.addPoint(0, this.xUnit.fromSim(x[i]), this.yUnit.fromSim(y[i]), true);
            ++i;
        }
        this.plot.repaint();
    }

    public boolean getConnected() {
        return this.plot.getConnected();
    }

    public Unit getXUnit() {
        return this.xUnit;
    }

    public Unit getYUnit() {
        return this.yUnit;
    }

    public void setConnected(boolean b) {
        this.plot.setConnected(b);
    }

    public void setMeter(MeterFunction m) {
        this.meter = m;
        this.plot.setXLabel(String.valueOf(this.meter.getXLabel()) + " (" + this.xUnit.symbol() + ")");
        this.plot.setYLabel(this.meter.getLabel());
    }

    public void setXUnit(Unit u) {
        this.xUnit = u;
    }

    public void setYUnit(Unit u) {
        this.yUnit = u;
    }

    public class Plot
    extends ptolemy.plot.Plot {
    }
}

