/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import java.awt.Component;
import java.util.Enumeration;
import simulate.Molecule;
import simulate.Phase;
import simulate.Simulation;
import simulate.Species;

public abstract class ConfigurationMolecule
extends Component {
    protected Species parentSpecies;
    protected final double[] dim = new double[Simulation.D];

    protected abstract void computeDimensions();

    public void initializeCoordinates() {
        if (this.parentSpecies == null) {
            return;
        }
        Enumeration e = this.parentSpecies.agents.elements();
        while (e.hasMoreElements()) {
            Species.Agent agent = (Species.Agent)e.nextElement();
            Molecule m = agent.firstMolecule();
            while (m != agent.terminationMolecule()) {
                this.initializeCoordinates(m);
                m = m.nextMolecule();
            }
        }
        this.computeDimensions();
    }

    public abstract void initializeCoordinates(Molecule var1);

    public void initializeCoordinates(Phase p) {
        if (this.parentSpecies == null) {
            return;
        }
        Species.Agent agent = this.parentSpecies.getAgent(p);
        Molecule m = agent.firstMolecule();
        while (m != agent.terminationMolecule()) {
            this.initializeCoordinates(m);
            m = m.nextMolecule();
        }
        p.iterator().reset();
        this.computeDimensions();
    }

    public double[] moleculeDimensions() {
        return this.dim;
    }

    public Species parentSpecies() {
        return this.parentSpecies;
    }

    public void setParentSpecies(Species s) {
        this.parentSpecies = s;
    }
}

