/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import java.awt.Color;
import java.awt.Graphics;
import java.beans.Beans;
import java.util.Random;
import simulate.Atom;
import simulate.Molecule;
import simulate.Phase;
import simulate.Species;

public class SpeciesDisk
extends Species {
    double[] speciesOrigin = new double[2];
    private final transient int[] shiftOrigin = new int[2];
    double mass;
    double diameter;
    double radius;
    Color color;

    public void setDefaults() {
        this.setDiameter(0.1);
        this.setMass(1.0);
        this.setColor(Color.black);
        this.name = "Disk";
        this.nAtomsPerMolecule = 1;
    }

    void initializeMolecules() {
        this.initializeMolecules(this.diameter, this.mass, this.color);
    }

    void initializeMolecules(double d, double d2, Color color) {
        this.setDiameter(d);
        this.setMass(d2);
        this.setColor(color);
    }

    public final double getMass() {
        return this.mass;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    public final void setMass(double d) {
        block8: {
            Molecule molecule;
            Object object;
            block7: {
                block6: {
                    Atom atom;
                    block5: {
                        this.mass = d;
                        if (this.firstAtom == null) {
                            return;
                        }
                        atom = this.firstAtom;
                        if (!true) break block5;
                        object = this.lastAtom;
                        if (atom == ((Atom)object).nextAtom) break block6;
                    }
                    do {
                        atom.mass = d;
                        atom.rm = d == Double.MAX_VALUE ? 0.0 : 1.0 / d;
                        atom = atom.nextAtom;
                        object = this.lastAtom;
                    } while (atom != ((Atom)object).nextAtom);
                }
                object = this.firstMolecule;
                if (!true) break block7;
                molecule = this.lastMolecule;
                if (object == molecule.nextMolecule) break block8;
            }
            do {
                ((Molecule)object).updateMass();
                object = ((Molecule)object).nextMolecule;
                molecule = this.lastMolecule;
            } while (object != molecule.nextMolecule);
        }
    }

    public final double getDiameter() {
        return this.diameter;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    public final void setDiameter(double d) {
        block4: {
            Atom atom;
            Atom atom2;
            block3: {
                this.diameter = d;
                this.radius = 0.5 * d;
                if (this.firstAtom == null) {
                    return;
                }
                atom2 = this.firstAtom;
                if (!true) break block3;
                atom = this.lastAtom;
                if (atom2 == atom.nextAtom) break block4;
            }
            do {
                atom2.diameter = d;
                atom2.radius = 0.5 * d;
                atom2 = atom2.nextAtom;
                atom = this.lastAtom;
            } while (atom2 != atom.nextAtom);
        }
    }

    public final Color getColor() {
        return this.color;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    public final void setColor(Color color) {
        block4: {
            Atom atom;
            Atom atom2;
            block3: {
                this.color = color;
                if (this.firstAtom == null) {
                    return;
                }
                atom2 = this.firstAtom;
                if (!true) break block3;
                atom = this.lastAtom;
                if (atom2 == atom.nextAtom) break block4;
            }
            do {
                atom2.color = color;
                atom2 = atom2.nextAtom;
                atom = this.lastAtom;
            } while (atom2 != atom.nextAtom);
        }
    }

    public void draw(Graphics graphics, int[] nArray, double d) {
        double d2 = d * Phase.TO_PIXELS;
        Atom atom = this.lastAtom;
        atom = atom.nextAtom;
        Atom atom2 = this.firstAtom;
        while (atom2 != atom) {
            atom2.draw(graphics, nArray, d);
            atom2 = atom2.nextAtom;
        }
        if (this.parentPhase.drawOverflowImages) {
            Atom atom3 = this.firstAtom;
            while (atom3 != atom) {
                double[][] dArray = this.parentPhase.space.getOverflowShifts(atom3.r, this.radius);
                int n = 0;
                while (n < dArray.length) {
                    this.shiftOrigin[0] = nArray[0] + (int)(d2 * dArray[n][0]);
                    this.shiftOrigin[1] = nArray[1] + (int)(d2 * dArray[n][1]);
                    atom3.draw(graphics, this.shiftOrigin, d);
                    ++n;
                }
                atom3 = atom3.nextAtom;
            }
        }
    }

    public void initializeCoordinates(double[] dArray) {
        double[] dArray2 = new double[2];
        this.initializeCoordinates(dArray, dArray2);
    }

    public void initializeSpecies(Phase phase) {
        double[] dArray;
        this.parentPhase = phase;
        if (this.fillVolume) {
            this.setLocation(0, 0);
            this.setSize(phase.getSize());
        }
        if (Beans.isDesignTime()) {
            if (this.fillVolume) {
                this.speciesOrigin[0] = 0.0;
                this.speciesOrigin[1] = 0.0;
            }
            dArray = new double[]{this.designTimeXDim, this.designTimeYDim};
        } else {
            this.speciesOrigin[0] = this.getLocation().x;
            this.speciesOrigin[1] = this.getLocation().y;
            dArray = new double[]{phase.space.getDimensions(0), phase.space.getDimensions(1)};
        }
        if (!this.fillVolume) {
            this.speciesOrigin[0] = (double)this.getLocation().x / Phase.TO_PIXELS;
            this.speciesOrigin[1] = (double)this.getLocation().y / Phase.TO_PIXELS;
            dArray[0] = dArray[0] * ((double)this.getSize().width / (double)phase.getSize().width);
            dArray[1] = dArray[1] * ((double)this.getSize().height / (double)phase.getSize().height);
        }
        this.initializeCoordinates(dArray);
    }

    public void initializeCoordinates(double[] dArray, double[] dArray2) {
        double d = 0.0;
        double d2 = 0.0;
        Phase phase = this.parentPhase;
        double d3 = Math.sqrt(this.mass * phase.initialTemperature / 1.2027904738994466 * 2.0);
        int n = (int)Math.sqrt(dArray[0] / dArray[1] * (double)this.nMolecules);
        int n2 = this.nMolecules / n;
        if (n2 * n < this.nMolecules) {
            ++n2;
        }
        if (n2 * n < this.nMolecules) {
            System.out.println("Program error in SpeciesDisk.initializeCoordinates().moleculeRows");
        }
        int n3 = (int)((double)this.nMolecules / (double)n2 - 1.0E-10) + 1;
        double d4 = dArray[0] / (double)n3 / 2.0;
        double d5 = dArray[1] / (double)n2 / 2.0;
        double d6 = dArray[0] / (double)n3;
        double d7 = dArray[1] / (double)n2;
        Random random = new Random();
        int n4 = 0;
        int n5 = 0;
        block0: while (n5 < n) {
            int n6 = 0;
            while (n6 < n2) {
                Atom atom = this.molecule[n4].atom[0];
                atom.r[0] = (double)n5 * d6 + d4 + this.speciesOrigin[0];
                atom.r[1] = (double)n6 * d7 + d5 + this.speciesOrigin[1];
                atom.p[1] = Math.cos(Math.PI * 2 * random.nextDouble());
                atom.p[0] = Math.sqrt(1.0 - this.molecule[n4].p[1] * this.molecule[n4].p[1]);
                double d8 = Math.sqrt(atom.p[0] * atom.p[0] + atom.p[1] * atom.p[1]);
                atom.p[0] = atom.p[0] * (d3 / d8);
                atom.p[1] = atom.p[1] * (d3 / d8);
                d += atom.p[0];
                d2 += atom.p[1];
                if (++n4 == this.nMolecules) break block0;
                ++n6;
            }
            ++n5;
        }
        d /= (double)this.nMolecules;
        d2 /= (double)this.nMolecules;
        n4 = 0;
        while (n4 < this.nMolecules) {
            this.molecule[n4].atom[0].p[0] = this.molecule[n4].atom[0].p[0] - d;
            this.molecule[n4].atom[0].p[1] = this.molecule[n4].atom[0].p[1] - d2;
            ++n4;
        }
    }
}

