/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import java.awt.Component;
import java.awt.Graphics;
import java.beans.Beans;
import simulate.Atom;
import simulate.Molecule;
import simulate.Phase;

public abstract class Species
extends Component {
    String name;
    int speciesIndex = 0;
    protected int nMolecules;
    public int nAtomsPerMolecule;
    int[] simulationPixelDimensions = new int[]{-1, -1};
    double[] simulationRunDimensions = new double[]{-1.0, -1.0};
    Phase parentPhase;
    Species nextSpecies;
    Species previousSpecies;
    Molecule[] molecule;
    Molecule firstMolecule;
    Molecule lastMolecule;
    Atom firstAtom;
    Atom lastAtom;
    boolean fillVolume = true;
    double neighborUpdateSquareDisplacement = Double.MAX_VALUE;
    protected double designTimeXDim = 1.0;
    protected double designTimeYDim = 1.0;

    public Species() {
        this(20);
    }

    public Species(int n) {
        this.setDefaults();
        this.nMolecules = n;
        this.makeMolecules();
        this.orderMolecules();
        this.initializeMolecules();
    }

    abstract void setDefaults();

    abstract void initializeMolecules();

    public final int getNMolecules() {
        return this.nMolecules;
    }

    public final void setNMolecules(int n) {
        this.nMolecules = n;
        this.makeMolecules();
        this.orderMolecules();
        this.initializeMolecules();
    }

    void makeMolecules() {
        this.molecule = new Molecule[this.nMolecules];
        int n = 0;
        while (n < this.nMolecules) {
            this.molecule[n] = new Molecule(this, this.nAtomsPerMolecule);
            ++n;
        }
    }

    public final void deleteMolecule(Molecule molecule) {
        Molecule molecule2 = molecule.nextMolecule;
        Molecule molecule3 = molecule.previousMolecule;
        if (molecule == this.firstMolecule) {
            if (this.nMolecules == 1) {
                this.firstMolecule = null;
                this.firstAtom = null != null ? null.firstAtom : null;
            } else {
                this.firstMolecule = molecule2;
                Atom atom = this.firstAtom = molecule2 != null ? molecule2.firstAtom : null;
            }
            if (molecule == this.parentPhase.firstMolecule) {
                this.parentPhase.setFirstMolecule();
                if (molecule2 != null) {
                    molecule2.previousMolecule = null;
                    molecule2.firstAtom.previousAtom = null;
                }
            }
        }
        if (molecule == this.lastMolecule) {
            if (this.nMolecules == 1) {
                this.lastMolecule = null;
                this.lastAtom = null != null ? null.lastAtom : null;
            } else {
                this.lastMolecule = molecule3;
                Atom atom = this.lastAtom = molecule3 != null ? molecule3.lastAtom : null;
            }
            if (molecule == this.parentPhase.lastMolecule) {
                this.parentPhase.setLastMolecule();
            }
        }
        if (molecule3 != null) {
            molecule3.nextMolecule = molecule2;
            if (molecule2 == null) {
                Atom atom = molecule3.lastAtom;
                atom.nextAtom = null;
                if (null != null) {
                    null.previousAtom = atom;
                }
            } else {
                Atom atom;
                molecule2.previousMolecule = molecule3;
                Atom atom2 = molecule3.lastAtom;
                atom2.nextAtom = atom = molecule2.firstAtom;
                if (atom != null) {
                    atom.previousAtom = atom2;
                }
            }
        }
        --this.nMolecules;
        --this.parentPhase.nMoleculeTotal;
        this.parentPhase.nAtomTotal -= molecule.nAtoms;
        molecule = null;
    }

    public final void addMolecule(Molecule molecule) {
        if (this.nMolecules > 0) {
            Atom atom;
            Atom atom2;
            Molecule molecule2 = this.lastMolecule;
            molecule.nextMolecule = molecule2 = molecule2.nextMolecule;
            if (molecule2 == null) {
                atom2 = molecule.lastAtom;
                atom2.nextAtom = null;
                if (null != null) {
                    null.previousAtom = atom2;
                }
            } else {
                molecule2.previousMolecule = molecule;
                atom2 = molecule.lastAtom;
                atom2.nextAtom = atom = molecule2.firstAtom;
                if (atom != null) {
                    atom.previousAtom = atom2;
                }
            }
            molecule2 = this.lastMolecule;
            molecule2.nextMolecule = molecule;
            if (molecule == null) {
                atom2 = molecule2.lastAtom;
                atom2.nextAtom = null;
                if (null != null) {
                    null.previousAtom = atom2;
                }
            } else {
                molecule.previousMolecule = molecule2;
                atom2 = molecule2.lastAtom;
                atom2.nextAtom = atom = molecule.firstAtom;
                if (atom != null) {
                    atom.previousAtom = atom2;
                }
            }
            this.lastMolecule = molecule;
            Atom atom3 = this.lastAtom = molecule != null ? molecule.lastAtom : null;
            if (this.parentPhase.lastMolecule == molecule.previousMolecule) {
                this.parentPhase.setLastMolecule();
            }
        } else {
            this.firstMolecule = molecule;
            this.firstAtom = molecule != null ? molecule.firstAtom : null;
            this.lastMolecule = molecule;
            this.lastAtom = molecule != null ? molecule.lastAtom : null;
            this.parentPhase.setFirstMolecule();
            this.parentPhase.setLastMolecule();
        }
        ++this.nMolecules;
        ++this.parentPhase.nMoleculeTotal;
        this.parentPhase.nAtomTotal += molecule.nAtoms;
    }

    protected final void orderMolecules() {
        Molecule molecule;
        this.firstMolecule = molecule = this.molecule[0];
        this.firstAtom = molecule != null ? molecule.firstAtom : null;
        this.lastMolecule = molecule = this.molecule[this.nMolecules - 1];
        this.lastAtom = molecule != null ? molecule.lastAtom : null;
        int n = 1;
        while (n < this.nMolecules) {
            Atom atom;
            Molecule molecule2;
            Molecule molecule3 = this.molecule[n - 1];
            molecule3.nextMolecule = molecule2 = this.molecule[n];
            if (molecule2 == null) {
                atom = molecule3.lastAtom;
                atom.nextAtom = null;
                if (null != null) {
                    null.previousAtom = atom;
                }
            } else {
                Atom atom2;
                molecule2.previousMolecule = molecule3;
                atom = molecule3.lastAtom;
                atom.nextAtom = atom2 = molecule2.firstAtom;
                if (atom2 != null) {
                    atom2.previousAtom = atom;
                }
            }
            ++n;
        }
    }

    private final void setFirstMolecule(Molecule molecule) {
        this.firstMolecule = molecule;
        this.firstAtom = molecule != null ? molecule.firstAtom : null;
    }

    private final void setLastMolecule(Molecule molecule) {
        this.lastMolecule = molecule;
        this.lastAtom = molecule != null ? molecule.lastAtom : null;
    }

    public final Species getNextSpecies() {
        return this.nextSpecies;
    }

    public final void setNextSpecies(Species species) {
        Molecule molecule;
        this.nextSpecies = species;
        species.previousSpecies = this;
        Molecule molecule2 = this.lastMolecule;
        molecule2.nextMolecule = molecule = species.firstMolecule;
        if (molecule == null) {
            Atom atom = molecule2.lastAtom;
            atom.nextAtom = null;
            if (null != null) {
                null.previousAtom = atom;
                return;
            }
        } else {
            Atom atom;
            molecule.previousMolecule = molecule2;
            Atom atom2 = molecule2.lastAtom;
            atom2.nextAtom = atom = molecule.firstAtom;
            if (atom != null) {
                atom.previousAtom = atom2;
            }
        }
    }

    public final Species getPreviousSpecies() {
        return this.previousSpecies;
    }

    public final Phase getPhase() {
        return this.parentPhase;
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String string) {
        this.name = string;
    }

    public final boolean isFillVolume() {
        return this.fillVolume;
    }

    public final void setFillVolume(boolean bl) {
        this.fillVolume = bl;
    }

    public final int getSpeciesIndex() {
        return this.speciesIndex;
    }

    public final void setSpeciesIndex(int n) {
        this.speciesIndex = n;
    }

    public final double getNeighborUpdateSquareDisplacement() {
        return this.neighborUpdateSquareDisplacement;
    }

    public final void setNeighborUpdateSquareDisplacement(double d) {
        this.neighborUpdateSquareDisplacement = d;
    }

    public double kineticEnergy() {
        double d = 0.0;
        Molecule molecule = this.lastMolecule;
        molecule = molecule.nextMolecule;
        Molecule molecule2 = this.firstMolecule;
        while (molecule2 != molecule) {
            d += molecule2.kineticEnergy();
            molecule2 = molecule2.nextMolecule;
        }
        return d;
    }

    public void paint(Graphics graphics) {
        if (Beans.isDesignTime() && this.getParent() != null) {
            Phase phase = (Phase)this.getParent();
            this.initializeSpecies(phase);
            int[] nArray = new int[2];
            double d = phase.getNominalScale() / (2.0 * (double)phase.getImageShells() + 1.0);
            double d2 = d * this.designTimeXDim;
            nArray[0] = (phase.getSize().width - (int)(Phase.TO_PIXELS * d2)) / 2;
            d2 = d * this.designTimeYDim;
            nArray[1] = (phase.getSize().height - (int)(Phase.TO_PIXELS * d2)) / 2;
            this.draw(graphics, nArray, d);
        }
    }

    public void setDesignTimeXDim(double d) {
        this.designTimeXDim = d;
    }

    public double getDesignTimeXDim() {
        return this.designTimeXDim;
    }

    public void setDesignTimeYDim(double d) {
        this.designTimeYDim = d;
    }

    public double getDesignTimeYDim() {
        return this.designTimeYDim;
    }

    public abstract void draw(Graphics var1, int[] var2, double var3);

    public abstract void initializeSpecies(Phase var1);
}

