/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import simulate.Atom;
import simulate.Space;
import simulate.Species;

public class SpacePeriodicCubic
extends Space {
    private transient double[] dr = new double[2];
    protected final double[][] shift1 = new double[1][2];
    protected final double[][] shift3 = new double[3][2];

    public SpacePeriodicCubic() {
        this.periodic = true;
    }

    public final void uEr1Mr2(double[] dArray, double[] dArray2, double[] dArray3) {
        dArray[0] = dArray2[0] - dArray3[0];
        dArray[1] = dArray2[1] - dArray3[1];
        int n = 2;
        while (--n >= 0) {
            if (dArray[n] > 0.5 * this.dimensions[n]) {
                int n2 = n;
                dArray[n2] = dArray[n2] - this.dimensions[n];
                continue;
            }
            if (!(dArray[n] < -0.5 * this.dimensions[n])) continue;
            int n3 = n;
            dArray[n3] = dArray[n3] + this.dimensions[n];
        }
    }

    public final double r1Mr2_S(double[] dArray, double[] dArray2) {
        this.uEr1Mr2(this.dr, dArray, dArray2);
        return this.dr[0] * this.dr[0] + this.dr[1] * this.dr[1];
    }

    public void repositionMolecules(Species species) {
        if (species.firstAtom == null) {
            return;
        }
        Atom atom = species.lastAtom;
        atom = atom.nextAtom;
        Atom atom2 = species.firstAtom;
        while (atom2 != atom) {
            int n = 2;
            while (--n >= 0) {
                double d;
                if (atom2.r[n] < 0.0) {
                    d = this.dimensions[n];
                    int n2 = n;
                    atom2.r[n2] = atom2.r[n2] + d;
                    continue;
                }
                if (!(atom2.r[n] > this.dimensions[n])) continue;
                d = -this.dimensions[n];
                int n3 = n;
                atom2.r[n3] = atom2.r[n3] + d;
            }
            atom2 = atom2.nextAtom;
        }
    }

    public void setScale(double d, int n) {
        if (d > 0.0 && n >= 0) {
            this.scale = d / (double)(2 * n + 1);
            this.nShells = n;
            this.computeDrawSize();
        }
    }

    protected void resetOrigins(int n) {
        this.nShells = n;
        this.nImages = (2 * this.nShells + 1) * (2 * this.nShells + 1) - 1;
        this.origins = new int[this.nImages][];
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.nImages) {
            this.origins[n3] = new int[2];
            ++n3;
        }
        int n4 = -this.nShells;
        while (n4 <= this.nShells) {
            int n5 = -this.nShells;
            while (n5 <= this.nShells) {
                if (n4 != 0 || n5 != 0) {
                    this.origins[n2][0] = n4 * (this.drawSize[0] - 1);
                    this.origins[n2][1] = n5 * (this.drawSize[1] - 1);
                    ++n2;
                }
                ++n5;
            }
            ++n4;
        }
    }

    public double[][] getOverflowShifts(double[] dArray, double d) {
        int n = 0;
        int n2 = 0;
        if (dArray[0] - d < 0.0) {
            n = 1;
        } else if (dArray[0] + d > this.dimensions[0]) {
            n = -1;
        }
        if (dArray[1] - d < 0.0) {
            n2 = 1;
        } else if (dArray[1] + d > this.dimensions[1]) {
            n2 = -1;
        }
        if (n == 0) {
            if (n2 == 0) {
                return this.shift0;
            }
            this.shift1[0][0] = 0.0;
            this.shift1[0][1] = (double)n2 * this.dimensions[1];
            return this.shift1;
        }
        if (n2 == 0) {
            this.shift1[0][0] = (double)n * this.dimensions[0];
            this.shift1[0][1] = 0.0;
            return this.shift1;
        }
        this.shift3[0][0] = (double)n * this.dimensions[0];
        this.shift3[0][1] = 0.0;
        this.shift3[1][0] = 0.0;
        this.shift3[1][1] = (double)n2 * this.dimensions[1];
        this.shift3[2][0] = this.shift3[0][0];
        this.shift3[2][1] = this.shift3[1][1];
        return this.shift3;
    }
}

