/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.beans.Beans;
import java.util.Random;
import simulate.Phase;
import simulate.Species;

public class Space
extends Component {
    public static final int D = 2;
    public boolean periodic;
    protected final double[] dimensions = new double[2];
    protected final int[] drawSize = new int[2];
    protected double scale = 1.0;
    private static final double[] work = new double[2];
    protected final double[][] shift0 = new double[0][2];
    protected Phase parentPhase;
    public double volume;
    protected int nShells;
    protected int nImages;
    protected int[][] origins;

    public Space() {
        this.dimensions[0] = 1.0;
        this.dimensions[1] = 1.0;
        this.computeVolume();
        this.periodic = false;
    }

    public void setParentPhase(Phase phase) {
        this.parentPhase = phase;
        this.setDimensions(0, this.dimensions[0]);
    }

    public final boolean isPeriodic() {
        return this.periodic;
    }

    public void draw(Graphics graphics, int[] nArray) {
        if (this.isVisible()) {
            graphics.setColor(Color.gray.brighter());
            graphics.drawRect(nArray[0], nArray[1], this.drawSize[0] - 1, this.drawSize[1] - 1);
        }
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double d, int n) {
        if (d > 0.0 && n >= 0) {
            this.scale = d;
            this.nShells = n;
            this.computeDrawSize();
        }
    }

    protected void computeDrawSize() {
        double d = this.scale * this.dimensions[0];
        this.drawSize[0] = (int)(Phase.TO_PIXELS * d);
        d = this.scale * this.dimensions[1];
        this.drawSize[1] = (int)(Phase.TO_PIXELS * d);
        this.resetOrigins(this.nShells);
    }

    public int[] getDrawSize() {
        return this.drawSize;
    }

    public double[] getDimensions() {
        return this.dimensions;
    }

    public double getDimensions(int n) {
        return this.dimensions[n];
    }

    public void setDimensions(int n, double d) {
        this.dimensions[n] = d;
        if (this.parentPhase != null) {
            this.parentPhase.resetTO_PIXELS();
        }
        this.computeDrawSize();
        this.computeVolume();
    }

    public void inflate(double d) {
        this.setDimensions(0, d * this.dimensions[0]);
        this.setDimensions(1, d * this.dimensions[1]);
    }

    protected void computeVolume() {
        this.volume = this.dimensions[0] * this.dimensions[1];
    }

    protected void resetOrigins(int n) {
        this.nShells = n;
        this.nImages = 0;
        this.origins = new int[this.nImages][];
    }

    public int[][] getImageOrigins(int n) {
        if (n != this.nShells) {
            this.resetOrigins(n);
        }
        return this.origins;
    }

    public double[][] getOverflowShifts(double[] dArray, double d) {
        return this.shift0;
    }

    public void setXDimension(double d) {
        this.setDimensions(0, d);
    }

    public double getXDimension() {
        return this.dimensions[0];
    }

    public void setYDimension(double d) {
        this.setDimensions(1, d);
    }

    public double getYDimension() {
        return this.dimensions[0];
    }

    public void repositionMolecules(Species species) {
    }

    public void paint(Graphics graphics) {
        if (Beans.isDesignTime()) {
            graphics.setColor(Color.yellow);
            graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
        }
    }

    public static void uEa1(double[] dArray, double d) {
        dArray[0] = dArray[1] = d;
    }

    public static void uEv1(double[] dArray, double[] dArray2) {
        dArray[0] = dArray2[0];
        dArray[1] = dArray2[1];
    }

    public static double v1Dv2(double[] dArray, double[] dArray2) {
        return dArray[0] * dArray2[0] + dArray[1] * dArray2[1];
    }

    public static double v1S(double[] dArray) {
        return dArray[0] * dArray[0] + dArray[1] * dArray[1];
    }

    public static double v1Mv2_S(double[] dArray, double[] dArray2) {
        double d = dArray[0] - dArray2[0];
        double d2 = dArray[1] - dArray2[1];
        return d * d + d2 * d2;
    }

    public static void uEa1Tv1(double[] dArray, double d, double[] dArray2) {
        dArray[0] = d * dArray2[0];
        dArray[1] = d * dArray2[1];
    }

    public static void uEv1Mv2(double[] dArray, double[] dArray2, double[] dArray3) {
        dArray[0] = dArray2[0] - dArray3[0];
        dArray[1] = dArray2[1] - dArray3[1];
    }

    public void uEr1Mr2(double[] dArray, double[] dArray2, double[] dArray3) {
        dArray[0] = dArray2[0] - dArray3[0];
        dArray[1] = dArray2[1] - dArray3[1];
    }

    public double r1Mr2_S(double[] dArray, double[] dArray2) {
        return Space.v1Mv2_S(dArray, dArray2);
    }

    public static void uPEv1(double[] dArray, double[] dArray2) {
        dArray[0] = dArray[0] + dArray2[0];
        dArray[1] = dArray[1] + dArray2[1];
    }

    public static void uMEv1(double[] dArray, double[] dArray2) {
        dArray[0] = dArray[0] - dArray2[0];
        dArray[1] = dArray[1] - dArray2[1];
    }

    public static void uTEa1(double[] dArray, double d) {
        dArray[0] = dArray[0] * d;
        dArray[1] = dArray[1] * d;
    }

    public static void uTEa1(double[] dArray, int n) {
        dArray[0] = dArray[0] * (double)n;
        dArray[1] = dArray[1] * (double)n;
    }

    public static void uPEa1Tv1(double[] dArray, double d, double[] dArray2) {
        dArray[0] = dArray[0] + d * dArray2[0];
        dArray[1] = dArray[1] + d * dArray2[1];
    }

    public static void uMEa1Tv1(double[] dArray, double d, double[] dArray2) {
        dArray[0] = dArray[0] - d * dArray2[0];
        dArray[1] = dArray[1] - d * dArray2[1];
    }

    public static void uEa1Tv1Ma2Tv2(double[] dArray, double d, double[] dArray2, double d2, double[] dArray3) {
        dArray[0] = d * dArray2[0] - d2 * dArray3[0];
        dArray[1] = d * dArray2[1] - d2 * dArray3[1];
    }

    public static void uEa1Tv1Pa2Tv2(double[] dArray, double d, double[] dArray2, double d2, double[] dArray3) {
        dArray[0] = d * dArray2[0] + d2 * dArray3[0];
        dArray[1] = d * dArray2[1] + d2 * dArray3[1];
    }

    public static void uEa1T_v1Mv2_(double[] dArray, double d, double[] dArray2, double[] dArray3) {
        dArray[0] = d * (dArray2[0] - dArray3[0]);
        dArray[1] = d * (dArray2[1] - dArray3[1]);
    }

    public static void uEa1T_v1Mv2_(int[] nArray, double d, int[] nArray2, int[] nArray3) {
        nArray[0] = (int)(d * (double)(nArray2[0] - nArray3[0]));
        nArray[1] = (int)(d * (double)(nArray2[1] - nArray3[1]));
    }

    public static void uEv1Pa1Tv2(double[] dArray, double[] dArray2, double d, double[] dArray3) {
        dArray[0] = dArray2[0] + d * dArray3[0];
        dArray[1] = dArray2[1] + d * dArray3[1];
    }

    public static void uEv1Ma1Tv2(double[] dArray, double[] dArray2, double d, double[] dArray3) {
        dArray[0] = dArray2[0] - d * dArray3[0];
        dArray[1] = dArray2[1] - d * dArray3[1];
    }

    public static void unitVector(double[] dArray, double[] dArray2, double[] dArray3) {
        dArray[0] = dArray2[0] - dArray3[0];
        dArray[1] = dArray2[1] - dArray3[1];
        double d = 1.0 / (dArray[0] * dArray[0] + dArray[1] * dArray[1]);
        dArray[0] = d * dArray[0];
        dArray[1] = d * dArray[1];
    }

    public static void randomVector(double[] dArray, double d, Random random) {
        dArray[0] = (2.0 * random.nextDouble() - 1.0) * d;
        dArray[1] = (2.0 * random.nextDouble() - 1.0) * d;
    }

    public final void randomVector(double[] dArray, Random random) {
        dArray[0] = random.nextDouble() * this.dimensions[0];
        dArray[1] = random.nextDouble() * this.dimensions[1];
    }
}

