/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.beans.Beans;
import java.util.Enumeration;
import java.util.Vector;
import simulate.Controller;
import simulate.Phase;
import simulate.PhaseIntegratorListener;

public class Simulation
extends Container {
    public Controller controller;
    public Vector phases = new Vector();

    public Simulation() {
        this.setSize(400, 300);
    }

    public void add(Controller controller) {
        if (this.controller != null) {
            return;
        }
        super.add(controller);
        this.controller = controller;
        controller.parentSimulation = this;
    }

    public void registerPhases(PhaseIntegratorListener phaseIntegratorListener) {
        Enumeration enumeration = this.phases.elements();
        while (enumeration.hasMoreElements()) {
            ((Phase)enumeration.nextElement()).addPhaseIntegratorListener(phaseIntegratorListener);
        }
    }

    public void add(Phase phase) {
        super.add(phase);
        this.phases.addElement(phase);
        if (this.controller != null && this.controller.integrator != null) {
            phase.addPhaseIntegratorListener(this.controller.integrator);
        }
    }

    private boolean haveIntegrator() {
        return this.controller != null && this.controller.integrator != null;
    }

    public void paint(Graphics graphics) {
        if (Beans.isDesignTime()) {
            graphics.setColor(Color.red);
            graphics.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
            graphics.drawRect(1, 1, this.getSize().width - 3, this.getSize().height - 3);
        }
        graphics.setColor(this.getBackground());
        this.paintComponents(graphics);
    }
}

