/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import simulate.Atom;
import simulate.Potential;
import simulate.Space;

public class PotentialHardDisk
extends Potential {
    protected double collisionDiameter;
    protected double sig2;

    public PotentialHardDisk(double d) {
        this.setCollisionDiameter(d);
    }

    public double collisionTime(Atom atom, Atom atom2) {
        double[] dArray;
        double d;
        double[] dArray2;
        double d2;
        double d3;
        this.space.uEr1Mr2(this.r12, atom2.r, atom.r);
        Space.uEa1Tv1Ma2Tv2(this.v12, atom2.rm, atom2.p, atom.rm, atom.p);
        double[] dArray3 = this.r12;
        double[] dArray4 = this.v12;
        double d4 = dArray3[0] * dArray4[0] + dArray3[1] * dArray4[1];
        double d5 = Double.MAX_VALUE;
        if (d4 < 0.0 && (d3 = d4 * d4 - (d2 = (dArray2 = this.v12)[0] * dArray2[0] + dArray2[1] * dArray2[1]) * ((d = (dArray = this.r12)[0] * dArray[0] + dArray[1] * dArray[1]) - this.sig2)) > 0.0) {
            d5 = (-d4 - Math.sqrt(d3)) / d2;
        }
        return d5;
    }

    public void bump(Atom atom, Atom atom2) {
        this.space.uEr1Mr2(this.r12, atom2.r, atom.r);
        Space.uEa1Tv1Ma2Tv2(this.v12, atom2.rm, atom2.p, atom.rm, atom.p);
        double[] dArray = this.r12;
        double[] dArray2 = this.v12;
        double d = 2.0 / (atom.rm + atom2.rm) * (dArray[0] * dArray2[0] + dArray[1] * dArray2[1]) / this.sig2;
        double[] dArray3 = atom.p;
        double[] dArray4 = this.r12;
        dArray3[0] = dArray3[0] + d * dArray4[0];
        dArray3[1] = dArray3[1] + d * dArray4[1];
        dArray3 = atom2.p;
        dArray4 = this.r12;
        dArray3[0] = dArray3[0] - d * dArray4[0];
        dArray3[1] = dArray3[1] - d * dArray4[1];
    }

    public double getCollisionDiameter() {
        return this.collisionDiameter;
    }

    public void setCollisionDiameter(double d) {
        this.collisionDiameter = d;
        this.sig2 = d * d;
    }

    public boolean overlap(Atom atom, Atom atom2, double d) {
        d = 0.0;
        return this.space.r1Mr2_S(atom.r, atom2.r) < this.sig2;
    }

    public double energy(Atom atom, Atom atom2) {
        if (this.space.r1Mr2_S(atom.r, atom2.r) < this.sig2) {
            return Double.MAX_VALUE;
        }
        return 0.0;
    }
}

