/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import java.awt.Component;
import java.awt.Graphics;
import simulate.Atom;
import simulate.Molecule;
import simulate.Potential;
import simulate.Space;

public abstract class Potential2
extends Component {
    Space space;
    int species1Index = 0;
    int species2Index = 0;
    Potential[][] potential;
    int nAtoms1;
    int nAtoms2;
    double skinThickness;
    double potentialCutoff;
    double neighborRadius;
    double squareNeighborRadius;
    private transient double[] f = new double[2];

    public Potential2() {
        this.neighborRadius = Double.MAX_VALUE;
        this.potentialCutoff = Double.MAX_VALUE;
    }

    public abstract Potential getPotential(Atom var1, Atom var2);

    public boolean isNeighbor(Molecule molecule, Molecule molecule2) {
        return true;
    }

    public double[] force(Molecule molecule, Molecule molecule2) {
        double[] dArray = this.f;
        dArray[1] = 0.0;
        dArray[0] = 0.0;
        return this.f;
    }

    public void setSpace(Space space) {
        this.space = space;
        int n = 0;
        while (n < this.nAtoms1) {
            int n2 = 0;
            while (n2 < this.nAtoms2) {
                this.potential[n][n2].space = space;
                ++n2;
            }
            ++n;
        }
    }

    public final double getNeighborRadius() {
        return this.neighborRadius;
    }

    public final double getSkinThickness() {
        return this.skinThickness;
    }

    public final void setSkinThickness(double d) {
        this.skinThickness = d;
        this.neighborRadius = this.potentialCutoff + this.skinThickness;
        this.squareNeighborRadius = this.neighborRadius * this.neighborRadius;
    }

    public final void setPotentialCutoff(double d) {
        this.potentialCutoff = d;
        this.setSkinThickness(this.skinThickness);
    }

    public int getSpecies1Index() {
        return this.species1Index;
    }

    public void setSpecies1Index(int n) {
        this.species1Index = n;
    }

    public int getSpecies2Index() {
        return this.species2Index;
    }

    public void setSpecies2Index(int n) {
        this.species2Index = n;
    }

    public void paint(Graphics graphics) {
    }
}

