/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Image;
import java.beans.Beans;
import java.io.Serializable;
import java.util.Vector;
import simulate.Atom;
import simulate.Molecule;
import simulate.P1Null;
import simulate.P2IdealGas;
import simulate.PhaseIntegratorEvent;
import simulate.PhaseIntegratorListener;
import simulate.Potential;
import simulate.Potential1;
import simulate.Potential2;
import simulate.Space;
import simulate.Species;

public final class Phase
extends Container {
    public static double TO_PIXELS = 300.0;
    public boolean useNeighborList;
    private Vector phaseIntegratorListeners = new Vector(3);
    private boolean drawBoundingBox = false;
    private boolean maySetTO_PIXELS = true;
    private int imageShells;
    private double nominalScale = 1.0;
    int speciesCount;
    private final transient int[] origin = new int[2];
    private final transient int[] phaseSize = new int[2];
    public Potential2[][] potential2;
    public Potential1[] potential1;
    public transient Vector speciesVector = new Vector(3);
    public boolean updatedForces;
    public boolean updatedPotentialEnergy;
    public boolean updatedKineticEnergy;
    public boolean updatedNeighbors;
    public boolean updatedFutureNeighbors;
    private double potentialEnergy;
    private double kineticEnergy;
    Space space;
    boolean drawOverflowImages = false;
    public Species firstSpecies;
    public Species lastSpecies;
    public Molecule firstMolecule;
    public Molecule lastMolecule;
    public Atom firstAtom;
    public Atom lastAtom;
    public int nAtomTotal;
    public int nMoleculeTotal;
    Image offScreenImage;
    Graphics offScreenGraphics;
    public double initialTemperature = 300.0;

    public Phase() {
        this.setLayout(null);
        this.setSize(300, 300);
        this.setBackground(Color.gray);
        this.updatedKineticEnergy = false;
        this.updatedPotentialEnergy = false;
        this.updatedForces = false;
        this.updatedFutureNeighbors = false;
        this.updatedNeighbors = false;
        this.useNeighborList = false;
        this.nMoleculeTotal = 0;
        this.nAtomTotal = 0;
    }

    public double getKineticTemperature() {
        this.updateKineticEnergy();
        return 2.0 / (double)(this.nAtomTotal * 2) * this.kineticEnergy * 1.2027904738994466;
    }

    public void setInitialTemperature(double d) {
        this.initialTemperature = d;
    }

    public double getInitialTemperature() {
        return this.initialTemperature;
    }

    public void resetTO_PIXELS() {
        if (this.maySetTO_PIXELS && this.space != null) {
            double d;
            TO_PIXELS = d = (double)this.getSize().width / this.space.getDimensions(0);
        }
    }

    public void setMaySetTO_PIXELS(boolean bl) {
        this.maySetTO_PIXELS = bl;
        if (this.maySetTO_PIXELS && this.space != null) {
            double d;
            TO_PIXELS = d = (double)this.getSize().width / this.space.getDimensions(0);
        }
    }

    public boolean getMaySetTO_PIXELS() {
        return this.maySetTO_PIXELS;
    }

    public void setTO_PIXELS(double d) {
        TO_PIXELS = d;
    }

    public double getTO_PIXELS() {
        return TO_PIXELS;
    }

    public static int toPixels(double d) {
        return (int)(TO_PIXELS * d);
    }

    public boolean getUseNeighborList() {
        return this.useNeighborList;
    }

    public void setUseNeighborList(boolean bl) {
        this.useNeighborList = bl;
    }

    public void setDrawBoundingBox(boolean bl) {
        this.drawBoundingBox = bl;
    }

    public boolean getDrawBoundingBox() {
        return this.drawBoundingBox;
    }

    public int getImageShells() {
        return this.imageShells;
    }

    public void setImageShells(int n) {
        if (n >= 0) {
            this.imageShells = n;
            if (this.space != null) {
                this.space.setScale(this.nominalScale, this.imageShells);
            }
        }
    }

    public double getNominalScale() {
        return this.nominalScale;
    }

    public void setNominalScale(double d) {
        if (d > 0.0) {
            this.nominalScale = d;
            if (this.space != null) {
                this.space.setScale(this.nominalScale, this.imageShells);
            }
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.phaseSize[0] = n3;
        this.phaseSize[1] = n4;
        if (this.maySetTO_PIXELS && this.space != null) {
            double d;
            TO_PIXELS = d = (double)this.getSize().width / this.space.getDimensions(0);
        }
    }

    public int[] getPhaseSize() {
        return this.phaseSize;
    }

    public synchronized void addPhaseIntegratorListener(PhaseIntegratorListener phaseIntegratorListener) {
        this.phaseIntegratorListeners.addElement(phaseIntegratorListener);
        this.firePhaseIntegratorEvent(new PhaseIntegratorEvent(this));
    }

    public synchronized void removePhaseIntegratorListener(PhaseIntegratorListener phaseIntegratorListener) {
        this.phaseIntegratorListeners.removeElement(phaseIntegratorListener);
    }

    public void firePhaseIntegratorEvent(PhaseIntegratorEvent phaseIntegratorEvent) {
        Vector vector = null;
        Phase phase = this;
        synchronized (phase) {
            vector = (Vector)this.phaseIntegratorListeners.clone();
        }
        int n = 0;
        while (n < vector.size()) {
            PhaseIntegratorListener phaseIntegratorListener = (PhaseIntegratorListener)vector.elementAt(n);
            phaseIntegratorListener.phaseIntegratorNotify(phaseIntegratorEvent);
            ++n;
        }
    }

    public void add(Species species) {
        Object object;
        Serializable serializable;
        super.add(species);
        species.initializeSpecies(this);
        this.speciesVector.addElement(species);
        if (this.speciesCount > 0) {
            Atom atom;
            Molecule molecule;
            serializable = this.lastSpecies;
            serializable.nextSpecies = species;
            species.previousSpecies = serializable;
            object = serializable.lastMolecule;
            ((Molecule)object).nextMolecule = molecule = species.firstMolecule;
            if (molecule == null) {
                atom = ((Molecule)object).lastAtom;
                atom.nextAtom = null;
                if (null != null) {
                    null.previousAtom = atom;
                }
            } else {
                Atom atom2;
                molecule.previousMolecule = object;
                atom = ((Molecule)object).lastAtom;
                atom.nextAtom = atom2 = molecule.firstAtom;
                if (atom2 != null) {
                    atom2.previousAtom = atom;
                }
            }
        } else {
            this.firstSpecies = species;
        }
        this.lastSpecies = species;
        this.setFirstMolecule();
        this.setLastMolecule();
        ++this.speciesCount;
        serializable = species.firstMolecule;
        while (serializable != null) {
            ++this.nMoleculeTotal;
            serializable = ((Molecule)serializable).nextMolecule;
        }
        object = species.firstAtom;
        while (object != null) {
            ++this.nAtomTotal;
            object = ((Atom)object).nextAtom;
        }
        this.potential1 = new Potential1[this.speciesCount];
        this.potential2 = new Potential2[this.speciesCount][this.speciesCount];
        this.potential1[0] = new P1Null();
        this.potential2[0][0] = new P2IdealGas();
        int n = 0;
        while (n < this.speciesCount) {
            this.potential1[n] = this.potential1[0];
            this.potential2[n][n] = this.potential2[0][0];
            int n2 = n + 1;
            while (n2 < this.speciesCount) {
                this.potential2[n][n2] = this.potential2[0][0];
                this.potential2[n2][n] = this.potential2[n][n2];
                ++n2;
            }
            ++n;
        }
    }

    public final void setFirstMolecule() {
        Species species = this.firstSpecies;
        while (species != null) {
            if (species.firstMolecule != null) {
                this.firstMolecule = species.firstMolecule;
                this.firstAtom = species.firstAtom;
                return;
            }
            species = species.nextSpecies;
        }
    }

    public final void setLastMolecule() {
        Species species = this.lastSpecies;
        while (species != null) {
            if (species.lastMolecule != null) {
                this.lastMolecule = species.lastMolecule;
                this.lastAtom = species.lastAtom;
            }
            species = species.previousSpecies;
        }
    }

    public void add(Space space) {
        super.add(space);
        this.space = space;
        space.setParentPhase(this);
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        space.setBounds(0, 0, n, n2);
        space.setScale(this.nominalScale, this.imageShells);
        if (this.maySetTO_PIXELS && this.space != null) {
            double d;
            TO_PIXELS = d = (double)this.getSize().width / this.space.getDimensions(0);
        }
        if (this.offScreenImage == null) {
            this.offScreenImage = this.createImage(this.getSize().width, this.getSize().height);
            this.offScreenGraphics = this.offScreenImage.getGraphics();
        }
    }

    public void add(Potential1 potential1) {
        super.add(potential1);
        potential1.setSpace(this.space);
        this.potential1[potential1.speciesIndex] = potential1;
    }

    public void add(Potential2 potential2) {
        super.add(potential2);
        potential2.setSpace(this.space);
        this.potential2[potential2.species1Index][potential2.species2Index] = potential2;
        this.potential2[potential2.species2Index][potential2.species1Index] = potential2;
        Species species = this.firstSpecies;
        while (species != null) {
            double d;
            if ((potential2.species1Index == species.speciesIndex || potential2.species2Index == species.speciesIndex) && (d = 0.25 * potential2.skinThickness * potential2.skinThickness) < species.neighborUpdateSquareDisplacement) {
                species.neighborUpdateSquareDisplacement = d;
            }
            species = species.nextSpecies;
        }
    }

    public void updateNeighbors() {
        Molecule molecule = this.firstMolecule;
        while (molecule != null) {
            molecule.neighbors.removeAllElements();
            Molecule molecule2 = this.firstMolecule;
            while (molecule2 != molecule) {
                Species species = molecule.parentSpecies;
                species = molecule2.parentSpecies;
                if (this.potential2[species.speciesIndex][species.speciesIndex].isNeighbor(molecule, molecule2)) {
                    molecule.neighbors.addElement(molecule2);
                }
                molecule2 = molecule2.nextMolecule;
            }
            molecule = molecule.nextMolecule;
        }
        this.updatedNeighbors = true;
    }

    public void updateForces() {
    }

    public void updateKineticEnergy() {
        this.kineticEnergy = 0.0;
        Species species = this.firstSpecies;
        while (species != null) {
            this.kineticEnergy += species.kineticEnergy();
            species = species.nextSpecies;
        }
        this.updatedKineticEnergy = true;
    }

    public boolean overlap(Atom atom, double d) {
        Object object;
        d = 0.0;
        Atom atom2 = this.firstAtom;
        while (atom2 != atom) {
            object = this.potential2[0][0].getPotential(atom, atom2);
            if (((Potential)object).overlap(atom, atom2, 0.0)) {
                return true;
            }
            d += 0.0;
            atom2 = atom2.nextAtom;
        }
        object = atom.nextAtom;
        while (object != null) {
            Potential potential = this.potential2[0][0].getPotential(atom, (Atom)object);
            if (potential.overlap(atom, (Atom)object, 0.0)) {
                return true;
            }
            d += 0.0;
            object = ((Atom)object).nextAtom;
        }
        return false;
    }

    public void updatePotentialEnergy() {
    }

    public double potentialEnergy() {
        double d = 0.0;
        Molecule molecule = this.firstMolecule;
        while (molecule != null) {
            d += molecule.potentialEnergy();
            molecule = molecule.nextMolecule;
        }
        return 0.5 * d;
    }

    public double getKineticEnergy() {
        if (!this.updatedKineticEnergy) {
            this.updateKineticEnergy();
        }
        return this.kineticEnergy;
    }

    public double getPotentialEnergy() {
        return this.potentialEnergy;
    }

    public double getTotalEnergy() {
        if (!this.updatedKineticEnergy) {
            this.updateKineticEnergy();
        }
        return this.kineticEnergy + this.potentialEnergy;
    }

    public final boolean getDrawOverflowImages() {
        return this.drawOverflowImages;
    }

    public final void setDrawOverflowImages(boolean bl) {
        this.drawOverflowImages = bl;
    }

    public void paint(Graphics graphics) {
        Object object;
        if (Beans.isDesignTime()) {
            graphics.setColor(this.getBackground());
            graphics.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
            graphics.drawRect(1, 1, this.getSize().width - 3, this.getSize().height - 3);
            this.paintComponents(graphics);
            return;
        }
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        this.offScreenGraphics.setColor(Color.white);
        this.offScreenGraphics.fillRect(0, 0, n, n2);
        int[] nArray = this.space.getDrawSize();
        Space.uEa1T_v1Mv2_(this.origin, 0.5, this.phaseSize, nArray);
        if (this.drawBoundingBox) {
            this.offScreenGraphics.setColor(Color.gray);
            this.offScreenGraphics.drawRect(0, 0, n - 1, n2 - 1);
        }
        int n3 = 0;
        while (n3 < this.speciesVector.size()) {
            object = (Species)this.speciesVector.elementAt(n3);
            if (((Species)object).firstAtom != null) {
                this.space.repositionMolecules((Species)object);
                ((Species)object).draw(this.offScreenGraphics, this.origin, this.space.getScale());
            }
            ++n3;
        }
        this.space.draw(this.offScreenGraphics, this.origin);
        if (this.imageShells > 0) {
            object = this.space.getImageOrigins(this.imageShells);
            int n4 = 0;
            while (n4 < ((Object)object).length) {
                this.offScreenGraphics.copyArea(this.origin[0], this.origin[1], nArray[0], nArray[1], (int)object[n4][0], (int)object[n4][1]);
                ++n4;
            }
        }
        graphics.drawImage(this.offScreenImage, 0, 0, this);
    }
}

