/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.beans.Beans;
import simulate.Atom;
import simulate.Molecule;
import simulate.Potential;
import simulate.Potential2;
import simulate.PotentialHardDisk;

public class P2HardDisk
extends Potential2 {
    private double collisionDiameter = 0.1;

    public P2HardDisk() {
        double d;
        this.setSize(30, 30);
        this.nAtoms1 = 1;
        this.nAtoms2 = 1;
        this.potential = new Potential[this.nAtoms1][this.nAtoms2];
        this.potential[0][0] = new PotentialHardDisk(this.collisionDiameter);
        this.collisionDiameter = d = this.collisionDiameter;
        ((PotentialHardDisk)this.potential[0][0]).setCollisionDiameter(d);
        this.potentialCutoff = d;
        this.setSkinThickness(this.skinThickness);
    }

    public final boolean isNeighbor(Molecule molecule, Molecule molecule2) {
        return this.space.r1Mr2_S(molecule.COM(), molecule2.COM()) < this.squareNeighborRadius;
    }

    public final Potential getPotential(Atom atom, Atom atom2) {
        return this.potential[0][0];
    }

    public final double getCollisionDiameter() {
        return this.collisionDiameter;
    }

    public final void setCollisionDiameter(double d) {
        this.collisionDiameter = d;
        ((PotentialHardDisk)this.potential[0][0]).setCollisionDiameter(d);
        this.potentialCutoff = d;
        this.setSkinThickness(this.skinThickness);
    }

    public void paint(Graphics graphics) {
        int[] nArray = new int[]{-1, -1};
        if (Beans.isDesignTime() && this.getParent() != null) {
            Container container = this.getParent();
            nArray[0] = container.getSize().width;
            nArray[1] = container.getSize().height;
            double d = Math.max(nArray[0], nArray[1]);
            int n = (int)(d * this.collisionDiameter);
            graphics.setColor(Color.red);
            int n2 = this.getLocation().x;
            int n3 = this.getLocation().y;
            graphics.fillOval(0, 0, n, n);
        }
    }
}

