/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import java.awt.Graphics;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import simulate.Atom;
import simulate.Phase;
import simulate.Potential1;
import simulate.Potential2;
import simulate.Species;

public class Molecule
implements Serializable {
    double mass;
    Vector neighbors;
    private final double[] r0 = new double[2];
    private final double[] r = new double[2];
    private final double[] dr = new double[2];
    final double[] p = new double[2];
    final double[] f = new double[2];
    Species parentSpecies;
    Molecule nextMolecule;
    Molecule previousMolecule;
    Atom firstAtom;
    Atom lastAtom;
    Atom[] atom;
    int nAtoms;

    public Molecule(Species species, int n) {
        this.parentSpecies = species;
        double[] dArray = this.r;
        dArray[1] = 0.0;
        dArray[0] = 0.0;
        dArray = this.p;
        dArray[1] = 0.0;
        dArray[0] = 0.0;
        dArray = this.f;
        dArray[1] = 0.0;
        dArray[0] = 0.0;
        this.neighbors = new Vector();
        this.nAtoms = n;
        this.makeAtoms();
        this.orderAtoms();
        this.updateMass();
    }

    protected void makeAtoms() {
        this.atom = new Atom[this.nAtoms];
        int n = 0;
        while (n < this.nAtoms) {
            this.atom[n] = new Atom(this, n);
            ++n;
        }
    }

    public final int getNAtoms() {
        return this.nAtoms;
    }

    private final void setNAtoms(int n) {
        this.nAtoms = n;
        this.makeAtoms();
        this.orderAtoms();
        this.updateMass();
    }

    private final void orderAtoms() {
        this.firstAtom = this.atom[0];
        this.lastAtom = this.atom[this.nAtoms - 1];
        int n = 1;
        while (n < this.nAtoms) {
            Atom atom;
            Atom atom2 = this.atom[n - 1];
            atom2.nextAtom = atom = this.atom[n];
            if (atom != null) {
                atom.previousAtom = atom2;
            }
            ++n;
        }
    }

    public final Molecule getNextMolecule() {
        return this.nextMolecule;
    }

    public final void setNextMolecule(Molecule molecule) {
        Atom atom;
        this.nextMolecule = molecule;
        if (molecule == null) {
            Atom atom2 = this.lastAtom;
            atom2.nextAtom = null;
            if (null != null) {
                null.previousAtom = atom2;
            }
            return;
        }
        molecule.previousMolecule = this;
        Atom atom3 = this.lastAtom;
        atom3.nextAtom = atom = molecule.firstAtom;
        if (atom != null) {
            atom.previousAtom = atom3;
        }
    }

    public final Molecule getPreviousMolecule() {
        return this.previousMolecule;
    }

    public final double getSquareDisplacement() {
        return this.parentSpecies.parentPhase.space.r1Mr2_S(this.COM(), this.r0);
    }

    public final Potential1 getP1() {
        Species species = this.parentSpecies;
        return this.parentSpecies.parentPhase.potential1[species.speciesIndex];
    }

    public final Potential2[] getP2() {
        Species species = this.parentSpecies;
        return this.parentSpecies.parentPhase.potential2[species.speciesIndex];
    }

    public final void zeroForce() {
        double[] dArray = this.f;
        dArray[1] = 0.0;
        dArray[0] = 0.0;
    }

    public final void addForce(double[] dArray) {
        double[] dArray2 = this.f;
        dArray2[0] = dArray2[0] + dArray[0];
        dArray2[1] = dArray2[1] + dArray[1];
    }

    public final void subtractForce(double[] dArray) {
        double[] dArray2 = this.f;
        dArray2[0] = dArray2[0] - dArray[0];
        dArray2[1] = dArray2[1] - dArray[1];
    }

    public final int getSpeciesIndex() {
        Species species = this.parentSpecies;
        return species.speciesIndex;
    }

    public final Species getSpecies() {
        return this.parentSpecies;
    }

    public final Phase getPhase() {
        return this.parentSpecies.parentPhase;
    }

    public final double getMass() {
        return this.mass;
    }

    public final void updateMass() {
        this.mass = 0.0;
        int n = 0;
        while (n < this.nAtoms) {
            Atom atom = this.atom[n];
            this.mass += atom.mass;
            ++n;
        }
        int n2 = 0;
        while (n2 < this.nAtoms) {
            Atom atom = this.atom[n2];
            Molecule molecule = atom.parentMolecule;
            atom.COMFraction = atom.mass / molecule.mass;
            ++n2;
        }
    }

    public final double potentialEnergy() {
        Atom atom;
        double d = 0.0;
        Atom atom2 = this.lastAtom;
        atom2 = atom2.nextAtom;
        if (this.nAtoms > 1) {
            atom = this.firstAtom;
            while (atom != atom2) {
                d += atom.intraPotentialEnergy();
                atom = atom.nextAtom;
            }
            d *= 0.5;
        }
        atom = this.firstAtom;
        while (atom != atom2) {
            d += atom.interPotentialEnergy();
            atom = atom.nextAtom;
        }
        return d;
    }

    public double kineticEnergy() {
        double d = 0.0;
        Atom atom = this.lastAtom;
        atom = atom.nextAtom;
        Atom atom2 = this.firstAtom;
        while (atom2 != atom) {
            d += atom2.kineticEnergy();
            atom2 = atom2.nextAtom;
        }
        return d;
    }

    public final void translate(double[] dArray) {
        Atom atom = this.lastAtom;
        atom = atom.nextAtom;
        Atom atom2 = this.firstAtom;
        while (atom2 != atom) {
            double[] dArray2 = atom2.r;
            dArray2[0] = dArray2[0] + dArray[0];
            dArray2[1] = dArray2[1] + dArray[1];
            atom2 = atom2.nextAtom;
        }
    }

    public final void translate(int n, double d) {
        Atom atom = this.lastAtom;
        atom = atom.nextAtom;
        Atom atom2 = this.firstAtom;
        while (atom2 != atom) {
            int n2 = n;
            atom2.r[n2] = atom2.r[n2] + d;
            atom2 = atom2.nextAtom;
        }
    }

    public final void displace(double[] dArray) {
        Atom atom = this.lastAtom;
        atom = atom.nextAtom;
        Atom atom2 = this.firstAtom;
        while (atom2 != atom) {
            double[] dArray2 = atom2.rLast;
            double[] dArray3 = atom2.r;
            dArray2[0] = dArray3[0];
            dArray2[1] = dArray3[1];
            dArray2 = atom2.r;
            dArray2[0] = dArray2[0] + dArray[0];
            dArray2[1] = dArray2[1] + dArray[1];
            atom2 = atom2.nextAtom;
        }
    }

    public final void replace() {
        Atom atom = this.lastAtom;
        atom = atom.nextAtom;
        Atom atom2 = this.firstAtom;
        while (atom2 != atom) {
            double[] dArray = atom2.r;
            double[] dArray2 = atom2.rLast;
            dArray[0] = dArray2[0];
            dArray[1] = dArray2[1];
            atom2 = atom2.nextAtom;
        }
    }

    public final void inflate(double d) {
        double[] dArray = this.dr;
        double d2 = d - 1.0;
        double[] dArray2 = this.COM();
        dArray[0] = d2 * dArray2[0];
        dArray[1] = d2 * dArray2[1];
        this.displace(this.dr);
    }

    public final double[] COM() {
        if (this.nAtoms == 1) {
            return this.firstAtom.r;
        }
        Object object = this.r;
        object[1] = 0.0;
        object[0] = 0.0;
        object = this.lastAtom;
        object = object.nextAtom;
        Atom atom = this.firstAtom;
        while (atom != object) {
            double[] dArray = this.r;
            double d = atom.COMFraction;
            double[] dArray2 = atom.r;
            dArray[0] = dArray[0] + d * dArray2[0];
            dArray[1] = dArray[1] + d * dArray2[1];
            atom = atom.nextAtom;
        }
        return this.r;
    }

    public final boolean needNeighborUpdate() {
        return this.parentSpecies.parentPhase.space.r1Mr2_S(this.COM(), this.r0) > this.parentSpecies.neighborUpdateSquareDisplacement;
    }

    public final void addNeighbor(Molecule molecule) {
        this.neighbors.addElement(molecule);
    }

    public final void clearNeighborList() {
        this.neighbors.removeAllElements();
    }

    public final Enumeration getNeighborList() {
        return this.neighbors.elements();
    }

    public final boolean hasNeighbor(Molecule molecule) {
        return this.neighbors.contains(molecule);
    }

    public final void updateNeighborList() {
        Object object;
        Serializable serializable;
        this.neighbors.removeAllElements();
        Potential2[] potential2Array = this.parentSpecies;
        potential2Array = this.parentSpecies.parentPhase.potential2[potential2Array.speciesIndex];
        Molecule molecule = this.previousMolecule;
        while (molecule != null) {
            if (!molecule.neighbors.contains(this)) {
                serializable = molecule.parentSpecies;
                if (potential2Array[((Species)serializable).speciesIndex].isNeighbor(this, molecule)) {
                    molecule.neighbors.addElement(this);
                }
            }
            molecule = molecule.previousMolecule;
        }
        serializable = this.nextMolecule;
        while (serializable != null) {
            object = serializable.parentSpecies;
            if (potential2Array[object.speciesIndex].isNeighbor(this, (Molecule)serializable)) {
                this.neighbors.addElement(serializable);
            }
            serializable = serializable.nextMolecule;
        }
        object = this.r0;
        double[] dArray = this.COM();
        object[0] = dArray[0];
        object[1] = dArray[1];
    }

    public void draw(Graphics graphics, int[] nArray, double d) {
        Atom atom = this.lastAtom;
        atom = atom.nextAtom;
        Atom atom2 = this.firstAtom;
        while (atom2 != atom) {
            atom2.draw(graphics, nArray, d);
            atom2 = atom2.nextAtom;
        }
    }
}

