/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import java.awt.Component;
import java.io.Serializable;
import simulate.Atom;
import simulate.Integrator;
import simulate.Molecule;
import simulate.Potential;
import simulate.Potential1;
import simulate.Species;

public class IntegratorHard
extends Integrator {
    private Atom nextCollider;
    private final transient double[] dr = new double[2];

    public void doStep(double d) {
        Atom atom = this.nextCollider;
        if (d < atom.collisionTime) {
            this.advanceAcrossTimeStep(d);
            if (this.isothermal) {
                this.scaleMomenta(Math.sqrt(this.temperature / this.firstPhase.getKineticTemperature()));
            }
            return;
        }
        atom = this.nextCollider;
        double d2 = d - atom.collisionTime;
        this.advanceToCollision();
        this.doStep(d2);
    }

    protected void findNextCollider() {
        double d = Double.MAX_VALUE;
        Atom atom = this.firstPhase.firstAtom;
        while (atom != null) {
            if (atom.collisionTime < d) {
                d = atom.collisionTime;
                this.nextCollider = atom;
            }
            atom = atom.nextAtom;
        }
    }

    protected void advanceToCollision() {
        Atom atom = this.nextCollider;
        this.advanceAcrossTimeStep(atom.collisionTime);
        atom = this.nextCollider;
        atom = atom.collisionPartner;
        Atom atom2 = this.nextCollider;
        atom2.collisionPotential.bump(this.nextCollider, atom);
        atom2 = this.firstPhase.firstAtom;
        while (atom2 != atom) {
            if (atom2.collisionPartner == this.nextCollider || atom2.collisionPartner == atom || atom2 == this.nextCollider) {
                this.upList(atom2);
            }
            atom2 = atom2.nextAtom;
        }
        this.upList(atom);
        this.downList(this.nextCollider);
        this.downList(atom);
        this.findNextCollider();
        this.firstPhase.updatedKineticEnergy = false;
        this.firstPhase.updatedPotentialEnergy = false;
    }

    protected void advanceAcrossTimeStep(double d) {
        Atom atom = this.firstPhase.firstAtom;
        while (atom != null) {
            atom.collisionTime -= d;
            atom.time0 += d;
            double[] dArray = this.dr;
            double d2 = d * atom.rm;
            double[] dArray2 = atom.p;
            dArray[0] = d2 * dArray2[0];
            dArray[1] = d2 * dArray2[1];
            dArray = this.dr;
            double[] dArray3 = atom.r;
            dArray3[0] = dArray3[0] + dArray[0];
            dArray3[1] = dArray3[1] + dArray[1];
            atom = atom.nextAtom;
        }
    }

    protected void upList(Atom atom) {
        Object object;
        Atom atom2 = atom.parentMolecule.lastAtom;
        atom2 = atom2.nextAtom;
        double d = Double.MAX_VALUE;
        Molecule molecule = atom.parentMolecule;
        Component component = molecule.parentSpecies;
        int n = ((Species)component).speciesIndex;
        atom.collisionTime = Double.MAX_VALUE;
        atom.collisionPartner = null;
        atom.collisionPotential = null;
        component = this.firstPhase.potential1[n];
        Atom atom3 = atom.nextAtom;
        while (atom3 != atom2) {
            object = ((Potential1)component).getPotential(atom, atom3);
            double d2 = ((Potential)object).collisionTime(atom, atom3);
            if (d2 < d) {
                d = d2;
                atom.collisionTime = d2;
                atom.collisionPartner = atom3;
                atom.collisionPotential = object;
            }
            atom3 = atom3.nextAtom;
        }
        object = atom2;
        while (object != null) {
            Serializable serializable = ((Atom)object).parentMolecule;
            Species species = ((Molecule)serializable).parentSpecies;
            serializable = this.firstPhase.potential2[species.speciesIndex][n].getPotential(atom, (Atom)object);
            double d3 = ((Potential)serializable).collisionTime(atom, (Atom)object);
            if (d3 < d) {
                d = d3;
                atom.collisionTime = d3;
                atom.collisionPartner = object;
                atom.collisionPotential = serializable;
            }
            object = ((Atom)object).nextAtom;
        }
    }

    protected void downList(Atom atom) {
        Object object;
        Atom atom2 = atom.parentMolecule.firstAtom;
        atom2 = atom2.previousAtom;
        Molecule molecule = atom.parentMolecule;
        Component component = molecule.parentSpecies;
        int n = ((Species)component).speciesIndex;
        component = this.firstPhase.potential1[n];
        Atom atom3 = atom.previousAtom;
        while (atom3 != atom2) {
            object = ((Potential1)component).getPotential(atom, atom3);
            double d = ((Potential)object).collisionTime(atom, atom3);
            if (d < atom3.collisionTime) {
                atom3.collisionTime = d;
                atom3.collisionPartner = atom;
                atom3.collisionPotential = object;
            }
            atom3 = atom3.previousAtom;
        }
        object = atom2;
        while (object != null) {
            Serializable serializable = ((Atom)object).parentMolecule;
            Species species = ((Molecule)serializable).parentSpecies;
            serializable = this.firstPhase.potential2[species.speciesIndex][n].getPotential(atom, (Atom)object);
            double d = ((Potential)serializable).collisionTime(atom, (Atom)object);
            if (d < ((Atom)object).collisionTime) {
                ((Atom)object).collisionTime = d;
                ((Atom)object).collisionPartner = atom;
                ((Atom)object).collisionPotential = serializable;
            }
            object = ((Atom)object).previousAtom;
        }
    }

    public void initialize() {
        Atom atom = this.firstPhase.firstAtom;
        while (atom != null) {
            this.upList(atom);
            atom = atom.nextAtom;
        }
        this.findNextCollider();
    }

    public final void scaleMomenta(double d) {
        double d2 = 1.0 / d;
        Atom atom = this.firstPhase.firstAtom;
        while (atom != null) {
            double[] dArray = atom.p;
            dArray[0] = dArray[0] * d;
            dArray[1] = dArray[1] * d;
            atom.collisionTime *= d2;
            atom = atom.nextAtom;
        }
    }
}

