/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import java.awt.Button;
import java.awt.Color;
import java.awt.Container;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.Vector;
import simulate.IntegrationIntervalEvent;
import simulate.IntegrationIntervalListener;
import simulate.Phase;
import simulate.PhaseIntegratorEvent;
import simulate.PhaseIntegratorListener;

public abstract class Integrator
extends Container
implements PhaseIntegratorListener,
Serializable,
MouseListener,
Runnable {
    Thread runner;
    int running;
    Phase firstPhase;
    Phase[] phase;
    int nPhases;
    int nPhasesMax = 1;
    protected int sleepPeriod = 10;
    protected transient Vector listeners;
    private Vector integrationIntervalListeners = new Vector();
    int integrationInterval = 10;
    int integrationCount = 0;
    double drawTimeStep = 5.0E-4;
    private int neighborListUpdateInterval = Integer.MAX_VALUE;
    public double temperature = 300.0;
    public boolean isothermal = false;

    public Integrator() {
        this.phase = new Phase[this.nPhasesMax];
    }

    public final int getSleepPeriod() {
        return this.sleepPeriod;
    }

    public final void setSleepPeriod(int n) {
        this.sleepPeriod = n;
    }

    public abstract void doStep(double var1);

    public abstract void initialize();

    public final void setTemperature(double d) {
        this.temperature = d;
    }

    public final void setITemperature(int n) {
        this.temperature = n;
    }

    public final double getTemperature() {
        return this.temperature;
    }

    public void setIsothermal(boolean bl) {
        this.isothermal = bl;
    }

    public boolean isIsothermal() {
        return this.isothermal;
    }

    public final double getDrawTimeStep() {
        return this.drawTimeStep;
    }

    public final void setDrawTimeStep(double d) {
        this.drawTimeStep = d;
    }

    public final int getIntegrationInterval() {
        return this.integrationInterval;
    }

    public final void setIntegrationInterval(int n) {
        this.integrationInterval = n;
    }

    public final int getNeighborListUpdateInterval() {
        return this.neighborListUpdateInterval;
    }

    public final void setNeighborListUpdateInterval(int n) {
        this.neighborListUpdateInterval = n;
    }

    public void phaseIntegratorNotify(PhaseIntegratorEvent phaseIntegratorEvent) {
        if (this.nPhases == this.nPhasesMax) {
            return;
        }
        this.phase[this.nPhases] = (Phase)phaseIntegratorEvent.getSource();
        ++this.nPhases;
        this.firstPhase = this.phase[0];
    }

    public synchronized void addIntegrationIntervalListener(IntegrationIntervalListener integrationIntervalListener) {
        this.integrationIntervalListeners.addElement(integrationIntervalListener);
    }

    public synchronized void removeIntegrationIntervalListener(IntegrationIntervalListener integrationIntervalListener) {
        this.integrationIntervalListeners.removeElement(integrationIntervalListener);
    }

    public void fireIntegrationIntervalEvent(IntegrationIntervalEvent integrationIntervalEvent) {
        Vector vector = null;
        Integrator integrator = this;
        synchronized (integrator) {
            vector = (Vector)this.integrationIntervalListeners.clone();
        }
        int n = 0;
        while (n < vector.size()) {
            IntegrationIntervalListener integrationIntervalListener = (IntegrationIntervalListener)vector.elementAt(n);
            integrationIntervalListener.updateAverage(integrationIntervalEvent);
            ++n;
        }
    }

    public void start() {
    }

    public void stop() {
        if (this.runner != null) {
            this.runner.stop();
            this.runner = null;
        }
    }

    public void run() {
        while (true) {
            this.doStep(this.drawTimeStep);
            ++this.integrationCount;
            if (this.integrationCount == Integer.MAX_VALUE) {
                this.integrationCount = 1;
            }
            if (this.integrationCount % this.neighborListUpdateInterval == 0) {
                this.firstPhase.updateNeighbors();
            }
            if (this.integrationCount % this.integrationInterval == 0) {
                this.fireIntegrationIntervalEvent(new IntegrationIntervalEvent(this, this.firstPhase));
            }
            int n = 0;
            while (n < this.nPhases) {
                this.phase[n].repaint();
                ++n;
            }
            try {
                Thread.sleep(this.sleepPeriod);
                continue;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() instanceof Button) {
            Button button = (Button)mouseEvent.getSource();
            if (this.runner == null) {
                this.initialize();
                this.runner = new Thread(this);
                this.runner.start();
                this.running = 1;
                button.setBackground(Color.red);
                button.setLabel("pause");
                return;
            }
            if (this.running == 1) {
                this.runner.suspend();
                this.running = 0;
                button.setBackground(Color.green);
                button.setLabel("continue");
                return;
            }
            this.runner.resume();
            this.running = 1;
            button.setBackground(Color.red);
            button.setLabel("pause");
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

