/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import java.awt.Color;
import java.awt.Graphics;
import java.io.Serializable;
import simulate.Molecule;
import simulate.Phase;
import simulate.Potential;
import simulate.Potential1;
import simulate.Potential2;
import simulate.Species;

public class Atom {
    public final double[] r = new double[2];
    public final double[] p = new double[2];
    public final double[] f = new double[2];
    double diameter;
    double radius;
    double mass;
    double rm;
    Color color = Color.black;
    double COMFraction;
    Molecule parentMolecule;
    int atomIndex;
    public double time0;
    double collisionTime = Double.MAX_VALUE;
    Atom collisionPartner;
    Atom nextAtom;
    Atom previousAtom;
    Potential collisionPotential;
    private final double[] partnerForce = new double[2];
    public final double[] rLast = new double[2];

    public Atom(Molecule molecule, int n) {
        this.parentMolecule = molecule;
        this.atomIndex = n;
        double[] dArray = this.r;
        dArray[1] = 0.0;
        dArray[0] = 0.0;
        dArray = this.p;
        dArray[1] = 0.0;
        dArray[0] = 0.0;
        dArray = this.f;
        dArray[1] = 0.0;
        dArray[0] = 0.0;
        this.mass = 1.0;
        this.rm = 1.0;
        this.diameter = 0.1;
        this.radius = 0.05;
    }

    public Atom(Molecule molecule, int n, double d, double d2) {
        this.parentMolecule = molecule;
        this.atomIndex = n;
        double[] dArray = this.r;
        dArray[1] = 0.0;
        dArray[0] = 0.0;
        dArray = this.p;
        dArray[1] = 0.0;
        dArray[0] = 0.0;
        dArray = this.f;
        dArray[1] = 0.0;
        dArray[0] = 0.0;
        this.mass = d;
        this.rm = d == Double.MAX_VALUE ? 0.0 : 1.0 / d;
        this.diameter = d2;
        this.radius = 0.5 * d2;
    }

    public final Molecule getMolecule() {
        return this.parentMolecule;
    }

    public final int getSpeciesIndex() {
        Molecule molecule = this.parentMolecule;
        Species species = molecule.parentSpecies;
        return species.speciesIndex;
    }

    public final int getAtomIndex() {
        return this.atomIndex;
    }

    public final Color getColor() {
        return this.color;
    }

    public final void setColor(Color color) {
        this.color = color;
    }

    public final double getRm() {
        return this.rm;
    }

    public final void setRm(double d) {
        this.rm = d;
        this.mass = d == 0.0 ? Double.MAX_VALUE : 1.0 / d;
    }

    public final double getMass() {
        return this.mass;
    }

    public final void setMass(double d) {
        this.mass = d;
        this.rm = d == Double.MAX_VALUE ? 0.0 : 1.0 / d;
    }

    public final double getDiameter() {
        return this.diameter;
    }

    public final void setDiameter(double d) {
        this.diameter = d;
        this.radius = 0.5 * d;
    }

    public final double getRadius() {
        return this.radius;
    }

    public final void setRadius(double d) {
        double d2;
        this.diameter = d2 = 2.0 * d;
        this.radius = 0.5 * d2;
    }

    public final void zeroForce() {
        double[] dArray = this.f;
        dArray[1] = 0.0;
        dArray[0] = 0.0;
    }

    public final void addForce(double[] dArray) {
        double[] dArray2 = this.f;
        dArray2[0] = dArray2[0] + dArray[0];
        dArray2[1] = dArray2[1] + dArray[1];
    }

    public final void subtractForce(double[] dArray) {
        double[] dArray2 = this.f;
        dArray2[0] = dArray2[0] - dArray[0];
        dArray2[1] = dArray2[1] - dArray[1];
    }

    public final void translate(double[] dArray) {
        double[] dArray2 = this.r;
        dArray2[0] = dArray2[0] + dArray[0];
        dArray2[1] = dArray2[1] + dArray[1];
    }

    public final void translate(int n, double d) {
        int n2 = n;
        this.r[n2] = this.r[n2] + d;
    }

    public final void displace(double[] dArray) {
        double[] dArray2 = this.rLast;
        double[] dArray3 = this.r;
        dArray2[0] = dArray3[0];
        dArray2[1] = dArray3[1];
        dArray2 = this.r;
        dArray2[0] = dArray2[0] + dArray[0];
        dArray2[1] = dArray2[1] + dArray[1];
    }

    public final void replace() {
        double[] dArray = this.r;
        double[] dArray2 = this.rLast;
        dArray[0] = dArray2[0];
        dArray[1] = dArray2[1];
    }

    public double kineticEnergy() {
        double[] dArray = this.p;
        return 0.5 * this.rm * (dArray[0] * dArray[0] + dArray[1] * dArray[1]);
    }

    public final double potentialEnergy() {
        return this.intraPotentialEnergy() + this.interPotentialEnergy();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    public final double intraPotentialEnergy() {
        double d;
        block4: {
            Atom atom;
            Atom atom2;
            Serializable serializable;
            block3: {
                serializable = this.parentMolecule;
                Species species = ((Molecule)serializable).parentSpecies;
                serializable = ((Molecule)serializable).parentSpecies.parentPhase.potential1[species.speciesIndex];
                d = 0.0;
                atom2 = this.parentMolecule.firstAtom;
                if (!true) break block3;
                atom = this.parentMolecule.lastAtom;
                if (atom2 == atom.nextAtom) break block4;
            }
            do {
                if (atom2 != this) {
                    d += ((Potential1)serializable).getPotential(this, atom2).energy(this, atom2);
                }
                atom2 = atom2.nextAtom;
                atom = this.parentMolecule.lastAtom;
            } while (atom2 != atom.nextAtom);
        }
        return d;
    }

    public final double interPotentialEnergy() {
        Serializable serializable;
        Object object;
        Potential2[] potential2Array = this.parentMolecule;
        Species species = potential2Array.parentSpecies;
        potential2Array = potential2Array.parentSpecies.parentPhase.potential2[species.speciesIndex];
        double d = 0.0;
        Atom atom = this.parentMolecule.firstAtom;
        Object object2 = this.parentMolecule;
        object2 = ((Molecule)object2).parentSpecies.parentPhase.firstAtom;
        while (object2 != atom && object2 != null) {
            object = ((Atom)object2).parentMolecule;
            serializable = ((Molecule)object).parentSpecies;
            if ((d += potential2Array[serializable.speciesIndex].getPotential(this, (Atom)object2).energy(this, (Atom)object2)) >= Double.MAX_VALUE) {
                return Double.MAX_VALUE;
            }
            object2 = ((Atom)object2).nextAtom;
        }
        object = this.parentMolecule.lastAtom;
        object = ((Atom)object).nextAtom;
        while (object != null) {
            serializable = ((Atom)object).parentMolecule;
            Species species2 = ((Molecule)serializable).parentSpecies;
            if ((d += potential2Array[species2.speciesIndex].getPotential(this, (Atom)object).energy(this, (Atom)object)) >= Double.MAX_VALUE) {
                return Double.MAX_VALUE;
            }
            object = ((Atom)object).nextAtom;
        }
        return d;
    }

    public final void setCollision(double d, Atom atom, Potential potential) {
        this.collisionTime = d;
        this.collisionPartner = atom;
        this.collisionPotential = potential;
    }

    public final double getCollisionTime() {
        return this.collisionTime;
    }

    public final void decrementCollisionTime(double d) {
        this.collisionTime -= d;
        this.time0 += d;
    }

    public final Potential getCollisionPotential() {
        return this.collisionPotential;
    }

    public final Atom getCollisionPartner() {
        return this.collisionPartner;
    }

    public final Atom getNextAtom() {
        return this.nextAtom;
    }

    public final void setNextAtom(Atom atom) {
        this.nextAtom = atom;
        if (atom != null) {
            atom.previousAtom = this;
        }
    }

    public final Atom getPreviousAtom() {
        return this.previousAtom;
    }

    public final void updateCOMFraction() {
        Molecule molecule = this.parentMolecule;
        this.COMFraction = this.mass / molecule.mass;
    }

    public final double getCOMFraction() {
        return this.COMFraction;
    }

    public void draw(Graphics graphics, int[] nArray, double d) {
        double d2 = d * Phase.TO_PIXELS;
        int n = (int)(d2 * this.diameter);
        graphics.setColor(this.color);
        int n2 = nArray[0] + (int)(d2 * (this.r[0] - this.radius));
        int n3 = nArray[1] + (int)(d2 * (this.r[1] - this.radius));
        graphics.fillOval(n2, n3, n, n);
    }
}

