/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import simulate.Atom;
import simulate.Molecule;
import simulate.Phase;
import simulate.Space;

public final class AtomPair {
    public Atom atom1;
    public Atom atom2;
    public final Space.CoordinatePair cPair;

    public AtomPair(Atom a1, Atom a2) {
        this.cPair = a1.parentPhase().space().makeCoordinatePair(a1.parentPhase().boundary());
        this.reset(a1, a2);
    }

    public AtomPair(Atom a1, Atom a2, Space.CoordinatePair c) {
        this.atom1 = a1;
        this.atom2 = a2;
        this.cPair = c;
    }

    public AtomPair(Phase phase) {
        this.cPair = phase.space().makeCoordinatePair(phase.boundary());
    }

    public final Atom atom1() {
        return this.atom1;
    }

    public final Atom atom2() {
        return this.atom2;
    }

    public AtomPair copy() {
        return new AtomPair(this.atom1, this.atom2, this.cPair.copy());
    }

    public static Linker distanceSort(Iterator api) {
        if (!api.hasNext()) {
            return null;
        }
        Linker firstLink = new Linker(api.next().copy());
        while (api.hasNext()) {
            AtomPair nextPair = api.next().copy();
            Linker previous = null;
            boolean inserted = false;
            Linker link = firstLink;
            while (link != null) {
                if (nextPair.r2() < link.pair().r2()) {
                    if (previous == null) {
                        firstLink = new Linker(nextPair, firstLink);
                    } else {
                        previous.setNext(new Linker(nextPair, link));
                    }
                    inserted = true;
                    break;
                }
                previous = link;
                link = link.next();
            }
            if (inserted) continue;
            previous.setNext(new Linker(nextPair));
        }
        return firstLink;
    }

    public final Space.Vector dr() {
        return this.cPair.dr();
    }

    public final double dr(int i) {
        return this.cPair.dr(i);
    }

    public final double dv(int i) {
        return this.cPair.dv(i);
    }

    public final double r2() {
        return this.cPair.r2();
    }

    public void reset() {
        this.cPair.reset(this.atom1.coordinate(), this.atom2.coordinate());
    }

    public void reset(Atom a1, Atom a2) {
        this.atom1 = a1;
        this.atom2 = a2;
        this.reset();
    }

    public final double v2() {
        return this.cPair.v2();
    }

    public final double vDotr() {
        return this.cPair.vDotr();
    }

    public static interface Action {
        public void action(AtomPair var1);
    }

    public static final class ActionWrapper
    implements Atom.Action {
        Atom atom1;
        Action pairAction;
        final AtomPair pair;

        public ActionWrapper(AtomPair p) {
            this.pair = p;
        }

        public void action(Atom a) {
            this.pair.atom2 = a;
            this.pair.reset();
            this.pairAction.action(this.pair);
        }
    }

    public static class Iterator {
        private AtomPair pair;
        protected Atom.Iterator ai1;
        protected Atom.Iterator ai2;
        protected ActionWrapper actionWrapper;
        protected boolean hasNext;
        protected boolean needUpdate1;
        private Atom atom1;

        public Iterator(Phase p) {
            this.pair = new AtomPair(p);
            this.actionWrapper = new ActionWrapper(this.pair);
            this.hasNext = false;
        }

        public Iterator(Phase p, Atom.Iterator iter1, Atom.Iterator iter2) {
            this.pair = new AtomPair(p);
            this.actionWrapper = new ActionWrapper(this.pair);
            this.hasNext = false;
            this.ai1 = iter1;
            this.ai2 = iter2;
        }

        public Iterator(Phase p, ActionWrapper wrap) {
            this.pair = new AtomPair(p);
            this.actionWrapper = wrap;
            this.hasNext = false;
        }

        public void allPairs(Action act) {
            this.reset();
            this.ai1.reset();
            this.actionWrapper.pairAction = act;
            while (this.ai1.hasNext()) {
                this.pair.atom1 = this.ai1.next();
                this.ai2.reset(this.pair.atom1);
                this.ai2.allAtoms(this.actionWrapper);
            }
        }

        public final boolean hasNext() {
            return this.hasNext;
        }

        public AtomPair next() {
            if (this.needUpdate1) {
                this.pair.atom1 = this.atom1;
                this.needUpdate1 = false;
            }
            this.pair.atom2 = this.ai2.next();
            this.pair.reset();
            while (!this.ai2.hasNext()) {
                if (this.ai1.hasNext()) {
                    this.atom1 = this.ai1.next();
                    this.ai2.reset(this.atom1);
                    this.needUpdate1 = true;
                    continue;
                }
                this.hasNext = false;
                break;
            }
            return this.pair;
        }

        public void reset() {
            this.reset(null);
        }

        public void reset(Atom a1) {
            if (a1 == null) {
                this.ai1.reset();
            } else {
                this.ai1.reset(a1);
            }
            do {
                if (!this.ai1.hasNext()) {
                    this.hasNext = false;
                    return;
                }
                this.atom1 = this.ai1.next();
                this.ai2.reset(this.atom1);
            } while (!this.ai2.hasNext());
            this.needUpdate1 = true;
            this.hasNext = true;
        }

        public void reset(Atom a1, Atom a2) {
            this.ai1.reset(a1);
            this.ai2.reset(a2);
            this.pair.atom1 = this.ai1.next();
            this.needUpdate1 = false;
            this.hasNext = this.ai1.hasNext() && this.ai2.hasNext();
        }

        public static final class All
        extends Iterator {
            public All(Phase p) {
                super(p);
                this.ai1 = p.iterator.makeAtomIteratorUp();
                this.ai2 = p.iterator.makeAtomIteratorUpNeighbor();
                this.reset();
            }
        }

        public static final class Up
        extends Iterator {
            public Up(Phase p) {
                super(p);
                this.ai1 = new Atom.Iterator.Singlet();
                this.ai2 = p.iterator.makeAtomIteratorUpNeighbor();
                this.reset();
            }

            public Up(Phase p, Atom a) {
                super(p);
                this.ai1 = new Atom.Iterator.Singlet(a);
                this.ai2 = p.iterator.makeAtomIteratorUpNeighbor();
                this.reset();
            }
        }

        public static final class Down
        extends Iterator {
            public Down(Phase p) {
                super(p);
                this.ai1 = new Atom.Iterator.Singlet();
                this.ai2 = p.iterator.makeAtomIteratorDownNeighbor();
                this.reset();
            }

            public Down(Phase p, Atom a) {
                super(p);
                this.ai1 = new Atom.Iterator.Singlet(a);
                this.ai2 = p.iterator.makeAtomIteratorDownNeighbor();
                this.reset();
            }
        }

        public static class MP
        extends Iterator {
            private boolean upDone;
            private final Atom.Iterator aiUp;
            private final Atom.Iterator aiDown;
            private Atom.Iterator apiCurrent;
            private Molecule molecule;

            public MP(Phase p) {
                super(p);
                this.aiUp = p.iterator.makeAtomIteratorUpNeighbor();
                this.aiDown = p.iterator.makeAtomIteratorDownNeighbor();
            }

            public MP(Phase p, Molecule m) {
                super(p);
                this.aiUp = p.iterator.makeAtomIteratorUpNeighbor();
                this.aiDown = p.iterator.makeAtomIteratorDownNeighbor();
                this.reset(m);
            }

            public void allPairs(Action act) {
                this.actionWrapper.pairAction = act;
                while (this.ai1.hasNext()) {
                    ((Iterator)this).pair.atom1 = this.ai1.next();
                    this.aiUp.reset(this.molecule.lastAtom());
                    this.aiDown.reset(this.molecule.firstAtom());
                    this.aiUp.allAtoms(this.actionWrapper);
                    this.aiDown.allAtoms(this.actionWrapper);
                }
            }

            public AtomPair next() {
                AtomPair dummy = super.next();
                if (!this.hasNext && !this.upDone) {
                    this.ai2 = this.aiDown;
                    super.reset();
                    this.upDone = true;
                }
                return ((Iterator)this).pair;
            }

            public void reset() {
                this.reset(this.molecule);
            }

            public void reset(Molecule m) {
                this.molecule = m;
                this.ai1 = m.atomIterator;
                this.aiUp.reset(m.lastAtom());
                this.aiDown.reset(m.firstAtom());
                this.ai2 = this.aiUp;
                super.reset();
                if (this.hasNext) {
                    this.upDone = false;
                } else {
                    this.ai2 = this.aiDown;
                    super.reset();
                    this.upDone = true;
                }
            }
        }
    }

    public static final class Linker {
        private AtomPair pair;
        private Linker next;

        public Linker() {
        }

        public Linker(AtomPair p) {
            this.pair = p;
        }

        public Linker(AtomPair p, Linker l) {
            this.pair = p;
            this.next = l;
        }

        public final Linker next() {
            return this.next;
        }

        public final AtomPair pair() {
            return this.pair;
        }

        public final void setNext(Linker l) {
            this.next = l;
        }

        public final void setPair(AtomPair p) {
            this.pair = p;
        }
    }
}

