/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import java.awt.Color;
import java.awt.Graphics;
import simulate.AtomType;
import simulate.Constants;
import simulate.Integrator;
import simulate.Molecule;
import simulate.Phase;
import simulate.Simulation;
import simulate.Space;

public final class Atom
implements Space.Occupant {
    public Integrator.Agent ia;
    Color color = Color.black;
    private boolean stationary;
    Molecule parentMolecule;
    int atomIndex;
    private Atom nextAtom;
    private Atom previousAtom;
    public final Space.Coordinate coordinate;
    public Space.Vector r;
    public Space.Vector p;
    public AtomType type;
    public Space.Vector workVector;
    public Space.Vector rLast;
    public Space.Vector velocity;
    public Linker[] atomLink;

    public Atom(Molecule parent, AtomType t, int index) {
        this.parentMolecule = parent;
        this.type = t;
        this.atomIndex = index;
        Simulation sim = this.parentMolecule.parentSpecies.parentSimulation;
        this.coordinate = Simulation.space.makeCoordinate(this);
        this.r = this.coordinate.position();
        this.p = this.coordinate.momentum();
        this.workVector = this.coordinate.makeVector();
        this.rLast = this.coordinate.makeVector();
        this.velocity = this.coordinate.makeVector();
        this.setStationary(false);
        this.useTypeColor();
        if (sim.hasIntegrator()) {
            this.setIntegratorAgent(sim.integrator().makeAgent(this));
        }
    }

    public final void accelerateBy(double d, Space.Vector u) {
        this.p.PEa1Tv1(d, u);
    }

    public final void accelerateBy(Space.Vector u) {
        this.p.PE(u);
    }

    public final int atomIndex() {
        return this.atomIndex;
    }

    public final void clearPreviousAtom() {
        this.previousAtom = null;
    }

    public final Space.Coordinate coordinate() {
        return this.coordinate;
    }

    public final void displaceBy(double d, Space.Vector u) {
        this.rLast.E(this.r);
        this.translateBy(d, u);
    }

    public final void displaceBy(Space.Vector u) {
        this.rLast.E(this.r);
        this.translateBy(u);
    }

    public final void displaceTo(Space.Vector u) {
        this.rLast.E(this.r);
        this.translateTo(u);
    }

    public final void displaceToRandom(Phase p) {
        this.rLast.E(this.r);
        this.translateToRandom(p);
    }

    public final void displaceWithin(double d) {
        this.workVector.setRandomCube();
        this.displaceBy(d, this.workVector);
    }

    public void draw(Graphics g, int[] origin, double scale) {
        this.type.draw(g, origin, scale, this);
    }

    public final Color getColor() {
        return this.color;
    }

    public final boolean isStationary() {
        return this.stationary;
    }

    public final double kineticEnergy() {
        return this.coordinate.kineticEnergy(this.type.mass());
    }

    public final double mass() {
        return this.type.mass();
    }

    public final Space.Vector momentum() {
        return this.p;
    }

    public final double momentum(int i) {
        return this.p.component(i);
    }

    public final Atom nextAtom() {
        return this.nextAtom;
    }

    public final Atom nextMoleculeFirstAtom() {
        return this.parentMolecule.lastAtom.nextAtom();
    }

    public final Molecule parentMolecule() {
        return this.parentMolecule;
    }

    public final Phase parentPhase() {
        return this.parentMolecule.parentPhase();
    }

    public final Space.Vector position() {
        return this.r;
    }

    public final double position(int i) {
        return this.r.component(i);
    }

    public final Atom previousAtom() {
        return this.previousAtom;
    }

    public final Atom previousMoleculeLastAtom() {
        return this.parentMolecule.firstAtom.previousAtom();
    }

    public final void randomizeMomentum(double temperature) {
        double magnitude = Math.sqrt(this.type.mass() * temperature * (double)Simulation.D / 1.2027904738994466) / Constants.SCALE;
        this.p.setRandomSphere();
        this.p.TE(magnitude);
    }

    public final void replace() {
        this.r.E(this.rLast);
    }

    public final double rm() {
        return this.type.rm();
    }

    public final void scaleMomentum(double scale) {
        this.p.TE(scale);
    }

    public final void setColor(Color c) {
        this.color = c;
    }

    public void setIntegratorAgent(Integrator.Agent ia) {
        this.ia = ia;
    }

    public final void setNextAtom(Atom atom) {
        this.nextAtom = atom;
        if (atom != null) {
            atom.previousAtom = this;
        }
    }

    public void setStationary(boolean b) {
        this.stationary = b;
        if (!this.stationary) {
            this.scaleMomentum(0.0);
        }
    }

    public final int speciesIndex() {
        return this.parentMolecule.speciesIndex();
    }

    public final void translateBy(double d, Space.Vector u) {
        this.r.PEa1Tv1(d, u);
    }

    public final void translateBy(Space.Vector u) {
        this.r.PE(u);
    }

    public final void translateTo(Space.Vector u) {
        this.r.E(u);
    }

    public final void translateToRandom(Phase p) {
        this.translateTo(p.boundary().randomPosition());
    }

    public final void useTypeColor() {
        this.color = this.type.color();
    }

    public final Space.Vector velocity() {
        this.velocity.E(this.p);
        this.velocity.TE(this.type.rm());
        return this.velocity;
    }

    public static interface Action {
        public void action(Atom var1);
    }

    public static interface Iterator {
        public void allAtoms(Action var1);

        public boolean hasNext();

        public Atom next();

        public void reset();

        public void reset(Atom var1);

        public static final class Singlet
        implements Iterator {
            private Atom atom;
            private boolean hasNext;

            public Singlet() {
                this.hasNext = false;
            }

            public Singlet(Atom a) {
                this.reset(a);
            }

            public void allAtoms(Action act) {
                act.action(this.atom);
            }

            public boolean hasNext() {
                return this.hasNext;
            }

            public Atom next() {
                this.hasNext = false;
                return this.atom;
            }

            public void reset() {
                this.hasNext = this.atom != null;
            }

            public void reset(Atom a) {
                this.atom = a;
                this.reset();
            }
        }

        public static class Up
        implements Iterator {
            protected Atom atom;
            protected Atom nextAtom;
            protected boolean hasNext;
            private Phase phase;

            public Up(Phase p) {
                this.phase = p;
                this.hasNext = false;
            }

            public Up(Phase p, Atom a) {
                this.phase = p;
                this.reset(a);
            }

            public void allAtoms(Action act) {
                Atom a = this.atom;
                while (a != null) {
                    act.action(a);
                    a = a.nextAtom();
                }
            }

            public boolean hasNext() {
                return this.hasNext;
            }

            public Atom next() {
                this.nextAtom = this.atom;
                this.atom = this.atom.nextAtom();
                this.hasNext = this.atom != null;
                return this.nextAtom;
            }

            public Phase phase() {
                return this.phase;
            }

            public void reset() {
                this.reset(this.phase.firstAtom());
            }

            public void reset(Atom a) {
                this.atom = a;
                if (a == null) {
                    this.hasNext = false;
                    return;
                }
                this.hasNext = true;
            }
        }

        public static final class UpNeighbor
        extends Up {
            private Atom first;

            public UpNeighbor(Phase p) {
                super(p);
            }

            public UpNeighbor(Phase p, Atom a) {
                super(p, a);
            }

            public void reset() {
                super.reset(this.first);
            }

            public void reset(Atom a) {
                this.atom = a;
                if (a == null) {
                    this.hasNext = false;
                    return;
                }
                this.first = a.nextAtom();
                super.reset(this.first);
            }
        }

        public static class Down
        implements Iterator {
            protected Atom atom;
            protected Atom nextAtom;
            protected boolean hasNext;
            private Phase phase;

            public Down(Phase p) {
                this.phase = p;
                this.hasNext = false;
            }

            public Down(Phase p, Atom a) {
                this.phase = p;
                this.reset(a);
            }

            public void allAtoms(Action act) {
                Atom a = this.atom;
                while (a != null) {
                    act.action(a);
                    a = a.previousAtom();
                }
            }

            public boolean hasNext() {
                return this.hasNext;
            }

            public Atom next() {
                this.nextAtom = this.atom;
                this.atom = this.atom.previousAtom();
                if (this.atom == null) {
                    this.hasNext = false;
                }
                return this.nextAtom;
            }

            public Phase phase() {
                return this.phase;
            }

            public void reset() {
                this.reset(this.phase.firstAtom());
            }

            public void reset(Atom a) {
                this.atom = a;
                if (a == null) {
                    this.hasNext = false;
                    return;
                }
                this.hasNext = true;
            }
        }

        public static final class DownNeighbor
        extends Down {
            private Atom first;

            public DownNeighbor(Phase p) {
                super(p);
            }

            public DownNeighbor(Phase p, Atom a) {
                super(p, a);
            }

            public void reset() {
                super.reset(this.first);
            }

            public void reset(Atom a) {
                this.atom = a;
                if (a == null) {
                    this.hasNext = false;
                    return;
                }
                this.first = a.previousAtom();
                super.reset(this.first);
            }
        }
    }

    public static class Linker {
        private Atom atom;
        private Linker next;

        public Linker() {
        }

        public Linker(Atom a) {
            this.atom = a;
        }

        public Linker(Atom a, Linker l) {
            this.atom = a;
            this.next = l;
        }

        public final Atom atom() {
            return this.atom;
        }

        public final Linker next() {
            return this.next;
        }

        public final void setAtom(Atom a) {
            this.atom = a;
        }

        public final void setNext(Linker l) {
            this.next = l;
        }
    }
}

