/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import java.awt.Component;
import java.awt.Graphics;
import simulate.IntegrationIntervalEvent;
import simulate.IntegrationIntervalListener;
import simulate.Phase;

public abstract class Meter
extends Component
implements IntegrationIntervalListener {
    int updateInterval;
    int iieCount;
    boolean firstCall = true;
    double sum;
    double sumSquare;
    int count = 0;
    private Meter nextMeter;
    private Meter previousMeter;
    protected Phase phase;
    String label;

    public Meter() {
        this.setUpdateInterval(1);
        this.label = "Property";
    }

    public double average() {
        return this.count > 0 ? this.sum / (double)this.count : 0.0;
    }

    public abstract double currentValue();

    public void draw(Graphics g, int[] origin, double scale) {
    }

    public double error() {
        double avg = this.average();
        return this.count > 1 ? Math.sqrt((this.sumSquare / (double)this.count - avg * avg) / (double)(this.count - 1)) : 0.0;
    }

    public String getLabel() {
        return this.label;
    }

    public final int getUpdateInterval() {
        return this.updateInterval;
    }

    public void initialize() {
    }

    public void integrationIntervalAction(IntegrationIntervalEvent evt) {
        this.updateStatistics();
    }

    public final Meter nextMeter() {
        return this.nextMeter;
    }

    public final Meter previousMeter() {
        return this.previousMeter;
    }

    public void reset() {
        this.count = 0;
        this.sum = 0.0;
        this.sumSquare = 0.0;
    }

    public void setLabel(String s) {
        this.label = s;
    }

    public final void setNextMeter(Meter meter) {
        this.nextMeter = meter;
        if (meter != null) {
            meter.previousMeter = this;
        }
    }

    public void setPhase(Phase p) {
        this.phase = p;
    }

    public final void setUpdateInterval(int i) {
        if (i > 0) {
            this.iieCount = this.updateInterval = i;
        }
    }

    public void updateStatistics() {
        if (this.firstCall) {
            this.firstCall = false;
        }
        if (--this.iieCount == 0) {
            this.iieCount = this.updateInterval;
            double value = this.currentValue();
            if (!Double.isNaN(value)) {
                this.sum += value;
                this.sumSquare += value * value;
                ++this.count;
            }
        }
    }
}

