/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import java.awt.Color;
import java.util.Observable;
import simulate.Atom;
import simulate.AtomPair;
import simulate.Constants;
import simulate.Gravity;
import simulate.IntegrationIntervalEvent;
import simulate.Integrator;
import simulate.Phase;
import simulate.PotentialHard;
import simulate.Simulation;

public final class IntegratorHard
extends Integrator {
    Agent nextCollider;
    private AtomPair.Iterator upPairIterator;
    private AtomPair.Iterator downPairIterator;
    private Atom.Iterator upAtomIterator;
    private Atom.Iterator downAtomIterator;
    private AtomPair atomPair;
    private PotentialHard spacePotential;
    Meter firstIMeter = null;

    protected void advanceAcrossTimeStep(double tStep) {
        if (this.firstPhase.noGravity) {
            Atom a = this.firstPhase.firstAtom();
            while (a != null) {
                ((Agent)a.ia).decrementCollisionTime(tStep);
                if (!a.isStationary()) {
                    a.translateBy(tStep * a.rm(), a.momentum());
                }
                a = a.nextAtom();
            }
        } else {
            double t2 = tStep * tStep;
            Atom a = this.firstPhase.firstAtom();
            while (a != null) {
                ((Agent)a.ia).decrementCollisionTime(tStep);
                if (!a.isStationary()) {
                    a.translateBy(tStep * a.rm(), a.momentum());
                    a.translateBy(t2, this.firstPhase.gravity.gVector);
                    a.accelerateBy(tStep * a.mass(), this.firstPhase.gravity.gVector);
                }
                a = a.nextAtom();
            }
        }
    }

    protected void advanceToCollision() {
        this.advanceAcrossTimeStep(this.nextCollider.getCollisionTime());
        Atom partner = this.nextCollider.getCollisionPartner();
        if (partner == this.nextCollider.atom) {
            Atom a = this.nextCollider.atom;
            this.atomPair.reset(a, a);
            this.nextCollider.getCollisionPotential().bump(this.atomPair);
            this.upList(a);
            this.downList(a);
            this.upPairIterator.reset(a);
            while (this.upPairIterator.hasNext()) {
                AtomPair pair = this.upPairIterator.next();
                if (((Agent)pair.atom2().ia).getCollisionPartner() != a) continue;
                this.upList(pair.atom2());
            }
        } else {
            Object partnerNextAtom = null;
            this.atomPair.reset(this.nextCollider.atom, partner);
            PotentialHard potential = this.nextCollider.getCollisionPotential();
            potential.bump(this.atomPair);
            Meter m = this.firstIMeter;
            while (m != null) {
                m.collisionAction(potential);
                m = m.nextIMeter;
            }
            Atom a1N = this.atomPair.atom1();
            Atom a2P = this.atomPair.atom2();
            this.upAtomIterator.reset();
            while (this.upAtomIterator.hasNext()) {
                Atom a = this.upAtomIterator.next();
                if (a == a1N || a == a2P) continue;
                if (a == partnerNextAtom) break;
                Atom aPartner = ((Agent)a.ia).getCollisionPartner();
                if (aPartner != this.nextCollider.atom && aPartner != partner) continue;
                this.upList(a);
            }
            this.upList(a1N);
            this.upList(a2P);
            this.downList(a1N);
            this.downList(a2P);
        }
        this.findNextCollider();
    }

    private void debugMethod() {
        AtomPair pair;
        Atom a = this.firstPhase.firstAtom();
        while (a != null) {
            a.setColor(Color.black);
            a = a.nextAtom();
        }
        Atom central = this.firstPhase.firstAtom();
        this.upPairIterator.reset(central);
        while (this.upPairIterator.hasNext()) {
            pair = this.upPairIterator.next();
            pair.atom2.setColor(Color.blue);
        }
        this.downPairIterator.reset(central);
        while (this.downPairIterator.hasNext()) {
            pair = this.downPairIterator.next();
            pair.atom2.setColor(Color.green);
        }
        central.setColor(Color.red);
    }

    public void doStep(double tStep) {
        if (tStep < this.nextCollider.getCollisionTime()) {
            this.advanceAcrossTimeStep(tStep);
            if (this.isothermal) {
                this.scaleMomenta(Math.sqrt(this.temperature / (this.firstPhase.kineticTemperature() * Constants.SCALE * Constants.SCALE)));
            }
            return;
        }
        double tStepNew = tStep - this.nextCollider.getCollisionTime();
        this.advanceToCollision();
        this.doStep(tStepNew);
    }

    protected void downList(Atom atom) {
        this.downPairIterator.reset(atom);
        while (this.downPairIterator.hasNext()) {
            AtomPair pair = this.downPairIterator.next();
            Agent aia = (Agent)pair.atom2().ia;
            PotentialHard potential = (PotentialHard)this.simulation().getPotential(pair);
            double time = potential.collisionTime(pair);
            if (!(time < aia.getCollisionTime())) continue;
            aia.setCollision(time, atom, potential);
        }
    }

    protected void findNextCollider() {
        double minCollisionTime = Double.MAX_VALUE;
        Atom a = this.firstPhase.firstAtom();
        while (a != null) {
            Agent ia = (Agent)a.ia;
            double ct = ia.getCollisionTime();
            if (ct < minCollisionTime) {
                minCollisionTime = ct;
                this.nextCollider = ia;
            }
            a = a.nextAtom();
        }
    }

    public void initialize() {
        this.deployAgents();
        if (this.isothermal) {
            this.scaleMomenta(Math.sqrt(this.temperature / (this.firstPhase.kineticTemperature() * Constants.SCALE * Constants.SCALE)));
        }
        Atom.Iterator iterator = this.firstPhase.iterator.makeAtomIteratorUp();
        iterator.reset();
        while (iterator.hasNext()) {
            this.upList(iterator.next());
        }
        this.findNextCollider();
    }

    public final Integrator.Agent makeAgent(Atom a) {
        return new Agent(a);
    }

    public void registerPhase(Phase p) {
        super.registerPhase(p);
        this.upPairIterator = p.iterator.makeAtomPairIteratorUp();
        this.downPairIterator = p.iterator.makeAtomPairIteratorDown();
        this.upAtomIterator = p.iterator.makeAtomIteratorUp();
        this.downAtomIterator = p.iterator.makeAtomIteratorDown();
        this.atomPair = new AtomPair(p);
        this.spacePotential = (PotentialHard)p.space().makePotential(p);
    }

    public void scaleMomenta(double s) {
        double rs = 1.0 / s;
        Atom a = this.firstPhase.firstAtom();
        while (a != null) {
            a.coordinate.scaleMomentum(s);
            Agent agent = (Agent)a.ia;
            agent.collisionTime = agent.collisionTime * rs;
            a = a.nextAtom();
        }
    }

    protected void upList(Atom atom) {
        double minCollisionTime = Double.MAX_VALUE;
        Agent aia = (Agent)atom.ia;
        aia.setCollision(minCollisionTime, null, null);
        this.upPairIterator.reset(atom);
        while (this.upPairIterator.hasNext()) {
            AtomPair pair = this.upPairIterator.next();
            PotentialHard potential = (PotentialHard)this.simulation().getPotential(pair);
            double time = potential.collisionTime(pair);
            if (!(time < minCollisionTime)) continue;
            minCollisionTime = time;
            aia.setCollision(time, pair.atom2(), potential);
        }
        this.atomPair.reset(atom, atom);
        double time = this.spacePotential.collisionTime(this.atomPair);
        if (time < minCollisionTime) {
            minCollisionTime = time;
            aia.setCollision(time, atom, this.spacePotential);
        }
    }

    public void update(Observable o, Object arg) {
        if (o instanceof Gravity) {
            Atom a = this.firstPhase.firstAtom();
            while (a != null) {
                if (a.isStationary() || ((Agent)a.ia).getCollisionPartner().isStationary()) {
                    this.upList(a);
                }
                if (a.isStationary()) {
                    this.downList(a);
                }
                a = a.nextAtom();
            }
            this.findNextCollider();
        }
    }

    public static final class Agent
    implements Integrator.Agent {
        public Atom atom;
        public double time0;
        private double collisionTime = Double.MAX_VALUE;
        private Atom collisionPartner;
        private PotentialHard collisionPotential;
        public double pAccumulator;
        public double qAccumulator;

        public Agent(Atom a) {
            this.atom = a;
            this.zeroAccumulators();
        }

        public final void decrementCollisionTime(double interval) {
            this.collisionTime -= interval;
            this.time0 += interval;
        }

        public final Atom getCollisionPartner() {
            return this.collisionPartner;
        }

        public final PotentialHard getCollisionPotential() {
            return this.collisionPotential;
        }

        public final double getCollisionTime() {
            return this.collisionTime;
        }

        public final void setCollision(double time, Atom partner, PotentialHard p) {
            this.collisionTime = time;
            this.collisionPartner = partner;
            this.collisionPotential = p;
        }

        public final void zeroAccumulators() {
            this.qAccumulator = 0.0;
            this.pAccumulator = 0.0;
        }
    }

    public class HighlightColliders
    extends Phase.ColorScheme {
        public Color colliderColor = Color.red;
        public Color partnerColor = Color.blue;

        public HighlightColliders() {
        }

        public HighlightColliders(Phase p) {
            super(p);
        }

        public void colorAtoms() {
            this.iterator.reset();
            while (this.iterator.hasNext()) {
                Atom a = this.iterator.next();
                if (a == IntegratorHard.this.nextCollider.atom) {
                    a.setColor(this.colliderColor);
                    continue;
                }
                if (a == IntegratorHard.this.nextCollider.collisionPartner) {
                    a.setColor(this.partnerColor);
                    continue;
                }
                a.setColor(this.baseColor);
            }
        }
    }

    public abstract class Meter
    extends simulate.Meter {
        public Meter nextIMeter;

        public Meter() {
            this.nextIMeter = IntegratorHard.this.firstIMeter;
            IntegratorHard.this.firstIMeter = this;
        }

        public abstract void collisionAction(PotentialHard var1);
    }

    public class MeterPressure
    extends Meter {
        double accumulator;
        double timeSum;

        public MeterPressure() {
            this.setLabel("PV/N (K)");
            this.accumulator = 0.0;
            this.timeSum = 0.0;
        }

        public void collisionAction(PotentialHard p) {
            this.accumulator += p.lastCollisionVirial();
        }

        public double currentValue() {
            double flux = -this.accumulator / (this.timeSum * (double)Simulation.space().D());
            flux *= Constants.SCALE * Constants.SCALE / (double)this.phase.atomCount();
            return IntegratorHard.this.temperature + (flux *= 1.2027904738994466);
        }

        public void integrationIntervalAction(IntegrationIntervalEvent evt) {
            this.timeSum += IntegratorHard.this.drawTimeStep * (double)IntegratorHard.this.integrationInterval;
            this.updateStatistics();
            this.timeSum = 0.0;
            this.accumulator = 0.0;
        }
    }
}

