/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import java.awt.Button;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import simulate.Display;
import simulate.Meter;
import simulate.MeterKineticEnergy;
import simulate.MeterPotentialEnergy;
import simulate.Phase;

public class DisplayTable
extends Display {
    public JTable table;
    MyTableData dataSource;
    Meter[] meter = new Meter[0];
    int nMeters = 0;
    private boolean showingPE = false;
    private boolean showingKE = false;
    Box panel = Box.createVerticalBox();
    Button resetButton = new Button("Reset averages");
    private boolean showAverages = true;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Double;

    public DisplayTable() {
        this(true);
    }

    public DisplayTable(boolean showAvgs) {
        this.showAverages = showAvgs;
        this.panel.setSize(100, 150);
        this.dataSource = new MyTableData();
        this.table = new JTable(this.dataSource);
        this.panel.add(new JScrollPane(this.table));
        if (this.showAverages) {
            this.resetButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    DisplayTable.this.resetAverages();
                }
            });
            this.panel.add(this.resetButton);
        }
        this.add(this.panel);
    }

    public void addMeter(Meter m) {
        if (m instanceof MeterPotentialEnergy && !this.showingPE) {
            return;
        }
        if (m instanceof MeterKineticEnergy && !this.showingKE) {
            return;
        }
        ++this.nMeters;
        Meter[] temp = new Meter[this.nMeters];
        int i = 0;
        while (i < this.meter.length) {
            temp[i] = this.meter[i];
            ++i;
        }
        temp[this.nMeters - 1] = m;
        this.meter = temp;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void doUpdate() {
    }

    public boolean getResetVisible() {
        return this.resetButton.isVisible();
    }

    public boolean isShowingKE() {
        return this.showingKE;
    }

    public boolean isShowingPE() {
        return this.showingPE;
    }

    public void repaint() {
        this.table.repaint();
    }

    public void resetAverages() {
        int i = 0;
        while (i < this.nMeters) {
            this.meter[i].reset();
            ++i;
        }
    }

    public void setPhase(Phase p) {
        Meter m = p.firstMeter;
        while (m != null) {
            this.addMeter(m);
            m = m.nextMeter();
        }
    }

    public void setResetVisible(boolean b) {
        this.resetButton.setVisible(b);
    }

    public void setShowingKE(boolean b) {
        this.showingKE = b;
    }

    public void setShowingPE(boolean b) {
        this.showingPE = b;
    }

    class MyTableData
    extends AbstractTableModel {
        String[] columnNames = new String[]{"Property", "Average", "Error"};
        Class[] columnClasses = new Class[]{class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = DisplayTable.class$("java.lang.String")), class$java$lang$Double != null ? class$java$lang$Double : (class$java$lang$Double = DisplayTable.class$("java.lang.Double")), class$java$lang$Double != null ? class$java$lang$Double : (class$java$lang$Double = DisplayTable.class$("java.lang.Double"))};

        MyTableData() {
            if (DisplayTable.this.showAverages) {
                this.columnNames = new String[]{"Property", "Average", "Error"};
                this.columnClasses = new Class[]{class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = DisplayTable.class$("java.lang.String")), class$java$lang$Double != null ? class$java$lang$Double : (class$java$lang$Double = DisplayTable.class$("java.lang.Double")), class$java$lang$Double != null ? class$java$lang$Double : (class$java$lang$Double = DisplayTable.class$("java.lang.Double"))};
            } else {
                this.columnNames = new String[]{"Property", "Current"};
                this.columnClasses = new Class[]{class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = DisplayTable.class$("java.lang.String")), class$java$lang$Double != null ? class$java$lang$Double : (class$java$lang$Double = DisplayTable.class$("java.lang.Double"))};
            }
        }

        public Class getColumnClass(int column) {
            return this.columnClasses[column];
        }

        public int getColumnCount() {
            return DisplayTable.this.showAverages ? 3 : 2;
        }

        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        public int getRowCount() {
            return DisplayTable.this.meter.length;
        }

        public Object getValueAt(int row, int column) {
            Meter m = DisplayTable.this.meter[row];
            switch (column) {
                case 0: {
                    return m.getLabel();
                }
                case 1: {
                    return new Double(DisplayTable.this.showAverages ? m.average() : m.currentValue());
                }
                case 2: {
                    return new Double(m.error());
                }
            }
            return null;
        }
    }
}

