/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import java.awt.Color;
import java.awt.Graphics;
import simulate.Atom;
import simulate.DisplayConfiguration;
import simulate.Space;
import simulate.Space1D;

public abstract class AtomType {
    private double mass;
    private double rm;
    private Color color;

    public AtomType(double m, Color c) {
        this.setMass(m);
        this.setColor(c);
    }

    public final Color color() {
        return this.color;
    }

    public abstract void draw(Graphics var1, int[] var2, double var3, Atom var5);

    public final double mass() {
        return this.mass;
    }

    public final double rm() {
        return this.rm;
    }

    public final void setColor(Color c) {
        this.color = c;
    }

    public final void setMass(double mass) {
        this.mass = mass;
        this.rm = mass == Double.MAX_VALUE ? 0.0 : 1.0 / mass;
    }

    public final void setRm(double rm) {
        this.rm = rm;
        this.mass = rm == 0.0 ? Double.MAX_VALUE : 1.0 / rm;
    }

    public static class Rod
    extends Disk {
        private int dh2 = Space1D.drawingHeight / 2;

        public Rod(double m, Color c, double d) {
            super(m, c, d);
        }

        public void draw(Graphics g, int[] origin, double scale, Atom atom) {
            Space.Vector r = atom.coordinate().position();
            double toPixels = scale * DisplayConfiguration.SIM2PIXELS;
            int sigmaP = (int)(toPixels * this.diameter);
            int xP = origin[0] + (int)(toPixels * (r.component(0) - this.radius));
            int yP = origin[1] - this.dh2;
            g.setColor(atom.color);
            g.fillRect(xP, yP, sigmaP, Space1D.drawingHeight);
        }
    }

    public static class Disk
    extends AtomType {
        double diameter;
        double radius;

        public Disk(double m, Color c, double d) {
            super(m, c);
            this.setDiameter(d);
        }

        public final double diameter() {
            return this.diameter;
        }

        public void draw(Graphics g, int[] origin, double scale, Atom atom) {
            Space.Vector r = atom.coordinate().position();
            double toPixels = scale * DisplayConfiguration.SIM2PIXELS;
            int sigmaP = (int)(toPixels * this.diameter);
            int xP = origin[0] + (int)(toPixels * (r.component(0) - this.radius));
            int yP = origin[1] + (int)(toPixels * (r.component(1) - this.radius));
            g.setColor(atom.color);
            g.fillOval(xP, yP, sigmaP, sigmaP);
        }

        public final double radius() {
            return this.radius;
        }

        public void setDiameter(double d) {
            this.diameter = d;
            this.radius = 0.5 * d;
        }
    }

    public static final class Well
    extends Disk {
        private double lambda;
        private double wellDiameter;
        private double wellRadius;

        public Well(double m, Color c, double d, double l) {
            super(m, c, d);
            this.setDiameter(d);
            this.setLambda(l);
        }

        public void draw(Graphics g, int[] origin, double scale, Atom atom) {
            Space.Vector r = atom.coordinate().position();
            double toPixels = scale * DisplayConfiguration.SIM2PIXELS;
            int sigmaP = (int)(toPixels * this.diameter);
            int xP = origin[0] + (int)(toPixels * (r.component(0) - this.radius));
            int yP = origin[1] + (int)(toPixels * (r.component(1) - this.radius));
            g.setColor(atom.color);
            g.fillOval(xP, yP, sigmaP, sigmaP);
            sigmaP = (int)(toPixels * this.wellDiameter);
            xP = origin[0] + (int)(toPixels * (r.component(0) - this.wellRadius));
            yP = origin[1] + (int)(toPixels * (r.component(1) - this.wellRadius));
            g.setColor(Color.lightGray);
            g.drawOval(xP, yP, sigmaP, sigmaP);
        }

        public final double lambda() {
            return this.lambda;
        }

        public final void setDiameter(double d) {
            super.setDiameter(d);
            this.setLambda(this.lambda);
        }

        public final void setLambda(double l) {
            this.lambda = l;
            this.wellDiameter = this.lambda * this.diameter();
            this.wellRadius = 0.5 * this.wellDiameter;
        }

        public final double wellDiameter() {
            return this.wellDiameter;
        }

        public final double wellRadius() {
            return this.wellRadius;
        }
    }

    public static final class Wall
    extends AtomType {
        int thickness = 4;
        private boolean vertical;
        private boolean horizontal;
        private double cosA;
        private double sinA;
        protected int angle;
        protected double length;
        protected boolean longWall;
        protected double temperature = 300.0;
        protected boolean adiabatic = true;

        public Wall(double m, Color c, double l, int a) {
            super(m, c);
            this.setLength(l);
            this.setAngle(a);
        }

        public void draw(Graphics g, int[] origin, double scale, Atom atom) {
            double toPixels = scale * DisplayConfiguration.SIM2PIXELS;
            Space.Vector r = atom.coordinate().position();
            int xP = origin[0] + (int)(toPixels * r.component(0));
            int yP = origin[1] + (int)(toPixels * r.component(1));
            g.setColor(atom.color);
            if (!this.horizontal && !this.vertical) {
                int x1 = xP + (int)(toPixels * this.length * this.cosA);
                int y1 = yP + (int)(toPixels * this.length * this.sinA);
                g.drawLine(xP, yP, x1, y1);
            } else {
                int wP = this.vertical ? this.thickness : (int)(toPixels * this.length);
                int hP = this.horizontal ? this.thickness : (int)(toPixels * this.length);
                g.fillRect(xP, yP, wP, hP);
            }
        }

        public final int getAngle() {
            return this.angle;
        }

        public final double getLength() {
            return this.length;
        }

        public final double getTemperature() {
            return this.temperature;
        }

        public final int getThickness() {
            return this.thickness;
        }

        public final boolean isAdiabatic() {
            return this.adiabatic;
        }

        public final boolean isHorizontal() {
            return this.horizontal;
        }

        public final boolean isLongWall() {
            return this.longWall;
        }

        public final boolean isVertical() {
            return this.vertical;
        }

        public final void setAdiabatic(boolean a) {
            this.adiabatic = a;
        }

        public void setAngle(int t) {
            this.angle = t <= 360 ? t : t % 360;
            this.horizontal = this.angle == 0 || Math.abs(this.angle) == 180;
            this.vertical = Math.abs(this.angle) == 90 || Math.abs(this.angle) == 270;
            this.cosA = Math.cos((double)this.angle * Math.PI / 180.0);
            this.sinA = Math.sin((double)this.angle * Math.PI / 180.0);
        }

        public final void setLength(double length) {
            this.length = length;
            this.longWall = length == Double.MAX_VALUE;
        }

        public final void setTemperature(double t) {
            this.temperature = t;
        }

        public final void setThickness(int thickness) {
            this.thickness = thickness;
        }
    }

    public static class Sphere
    extends AtomType {
        private double diameter;
        private double radius;

        public Sphere(double m, Color c, double d) {
            super(m, c);
            this.setDiameter(d);
        }

        public final double diameter() {
            return this.diameter;
        }

        public void draw(Graphics g, int[] origin, double scale, Atom atom) {
        }

        public final double radius() {
            return this.radius;
        }

        public final void setDiameter(double d) {
            this.diameter = d;
            this.radius = 0.5 * d;
        }

        public final void setRadius(double r) {
            this.setDiameter(2.0 * r);
        }
    }

    public static final class Carbon
    extends Sphere {
        public Carbon() {
            super(12.0, Color.black, 1.1);
        }
    }
}

