/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import simulate.AtomPair;
import simulate.PotentialSoft;
import simulate.Simulation;
import simulate.Space;

public class PotentialLJ
implements PotentialSoft {
    private double sigma;
    private double sigmaSquared;
    private double cutoffRadius;
    private double cutoffRadiusSquared;
    private double epsilon;
    private double cutoff;
    private double epsilon4;
    private double epsilon48;
    private double eLRC;
    private double pLRC;
    private Space.Vector force;
    Simulation parentSimulation;

    public PotentialLJ(double sigma, double epsilon, double cutoff) {
        this.setSigma(sigma);
        this.setCutoff(cutoff);
        this.setEpsilon(epsilon);
    }

    private void calculateLRC() {
        if (this.parentSimulation == null) {
            return;
        }
        double A = Simulation.space.sphereArea(1.0);
        int D = Simulation.D;
        double sigmaD = 1.0;
        double rcD = 1.0;
        double rc = this.sigma / this.cutoffRadius;
        int i = D;
        while (i > 0) {
            sigmaD *= this.sigma;
            rcD *= rc;
            --i;
        }
        double rc3 = rc * rc * rc;
        double rc6 = rc3 * rc3;
        double rc12 = rc6 * rc6;
        this.eLRC = 2.0 * this.epsilon * sigmaD * A * (rc12 / (12.0 - (double)D) - rc6 / (6.0 - (double)D)) / rcD;
        this.pLRC = 2.0 * this.epsilon * sigmaD * A * (12.0 * rc12 / (12.0 - (double)D) - 6.0 * rc6 / (6.0 - (double)D)) / ((double)D * rcD);
    }

    public double energy(AtomPair pair) {
        double r2 = pair.r2();
        if (r2 > this.cutoffRadiusSquared) {
            return 0.0;
        }
        double s2 = this.sigmaSquared / r2;
        double s6 = s2 * s2 * s2;
        return this.epsilon4 * s6 * (s6 - 1.0);
    }

    public double energyLRC(int n1, int n2, double V) {
        return (double)(n1 * n2) * this.eLRC / V;
    }

    public Space.Vector force(AtomPair pair) {
        double r2 = pair.r2();
        if (r2 > this.cutoffRadiusSquared) {
            this.force.E(0.0);
        } else {
            double s2 = this.sigmaSquared / r2;
            double s6 = s2 * s2 * s2;
            this.force.E(pair.dr());
            this.force.TE(-this.epsilon48 * s6 * (s6 - 0.5) / r2);
        }
        return this.force;
    }

    public double getCutoff() {
        return this.cutoff;
    }

    public double getEpsilon() {
        return this.epsilon;
    }

    public Simulation getParentSimulation() {
        return this.parentSimulation;
    }

    public double getSigma() {
        return this.sigma;
    }

    public boolean overlap(AtomPair pair) {
        return false;
    }

    public double pressureLRC(int n1, int n2, double V) {
        return (double)(n1 * n2) * this.pLRC / (V * V);
    }

    public void setCutoff(double rc) {
        this.cutoff = rc;
        this.cutoffRadius = this.sigma * this.cutoff;
        this.cutoffRadiusSquared = this.cutoffRadius * this.cutoffRadius;
        this.calculateLRC();
    }

    public void setEpsilon(double eps) {
        this.epsilon = eps;
        this.epsilon4 = eps * 4.0;
        this.epsilon48 = eps * 48.0;
        this.calculateLRC();
    }

    public void setParentSimulation(Simulation s) {
        this.parentSimulation = s;
        this.force = Simulation.space().makeVector();
        this.calculateLRC();
    }

    public void setSigma(double s) {
        this.sigma = s;
        this.sigmaSquared = s * s;
        this.setCutoff(this.cutoff);
    }

    public double virial(AtomPair pair) {
        double r2 = pair.r2();
        if (r2 > this.cutoffRadiusSquared) {
            return 0.0;
        }
        double s2 = this.sigmaSquared / r2;
        double s6 = s2 * s2 * s2;
        return -this.epsilon48 * s6 * (s6 - 0.5);
    }
}

