/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import simulate.Atom;
import simulate.Configuration;
import simulate.ConfigurationSequential;
import simulate.Gravity;
import simulate.Integrator;
import simulate.Iterator;
import simulate.MeterAbstract;
import simulate.MeterEnergy;
import simulate.MeterKineticEnergy;
import simulate.MeterPotentialEnergy;
import simulate.Molecule;
import simulate.Potential;
import simulate.Simulation;
import simulate.Space;
import simulate.Species;

public final class Phase
extends Container
implements Molecule.Container {
    protected Space.Boundary boundary;
    private int iBoundary = -1;
    Potential potential;
    public Gravity gravity;
    public boolean noGravity = true;
    private Species.Agent firstSpecies;
    Species.Agent lastSpecies;
    public int atomCount;
    public int moleculeCount;
    Simulation parentSimulation;
    MeterAbstract firstMeter;
    MeterAbstract lastMeter;
    private int meterCount = 0;
    public Configuration configuration;
    private Phase nextPhase;
    private Phase previousPhase;
    public Integrator integrator;
    public Iterator iterator;
    public MeterPotentialEnergy potentialEnergy;
    public MeterKineticEnergy kineticEnergy;
    public MeterEnergy energy;
    private ColorScheme colorScheme;

    public Phase() {
    }

    public Phase(Simulation sim) {
        this.iBoundary = -1;
        this.initialize(sim);
    }

    public void add(Configuration c) {
        c.parentPhase = this;
        this.configuration = c;
        Species.Agent s = this.firstSpecies;
        while (s != null) {
            this.configuration.add(s);
            s = s.nextSpecies();
        }
        this.iterator.reset();
    }

    public void add(Iterator it) {
        this.setIterator(it);
    }

    public void add(MeterAbstract m) {
        if (this.lastMeter != null) {
            this.lastMeter.setNextMeter(m);
        } else {
            this.firstMeter = m;
        }
        this.lastMeter = m;
        ++this.meterCount;
        m.setPhase(this);
        m.initialize();
        if (this.parentSimulation != null && this.parentSimulation.hasIntegrator()) {
            this.parentSimulation.controller.integrator().addIntegrationIntervalListener(m);
        }
    }

    public void add(ColorScheme csp) {
        this.colorScheme = csp;
        csp.setPhase(this);
        csp.initialColorAtoms();
    }

    public void add(Species.Agent species) {
        if (species.parentSpecies().configurationMolecule != null) {
            species.parentSpecies().configurationMolecule.initializeCoordinates(this);
        }
        if (this.lastSpecies != null) {
            this.lastSpecies.setNextSpecies(species);
        } else {
            this.firstSpecies = species;
        }
        this.lastSpecies = species;
        Molecule m = species.firstMolecule();
        while (m != null) {
            ++this.moleculeCount;
            m = m.nextMolecule();
        }
        Atom a = species.firstAtom();
        while (a != null) {
            ++this.atomCount;
            a = a.nextAtom();
        }
        this.configuration.add(species);
        this.iterator.reset();
    }

    public void add(Species s) {
        s.parentSimulation = this.parentSimulation;
        Species.Agent agent = s.makeAgent(this);
        agent.setNMolecules(20);
        this.add(agent);
    }

    public void addMolecule(Molecule m) {
        this.addMolecule(m, m.parentSpecies().getAgent(this));
    }

    public void addMolecule(Molecule m, Species.Agent s) {
        m.container().removeMolecule(m);
        m.setParentPhase(this);
        ++this.moleculeCount;
        this.atomCount += m.atomCount;
        s.addMolecule(m);
        this.iterator.addMolecule(m);
    }

    public final synchronized void addMoleculeSafely(Molecule m) {
        this.addMolecule(m);
    }

    public final int atomCount() {
        return this.atomCount;
    }

    public final Space.Boundary boundary() {
        return this.boundary;
    }

    public final ColorScheme colorScheme() {
        return this.colorScheme;
    }

    public void deleteMolecule(Molecule m) {
        m.parentSpecies().reservoir().addMolecule(m);
    }

    public final synchronized void deleteMoleculeSafely(Molecule m) {
        this.deleteMolecule(m);
    }

    public final Space.Vector dimensions() {
        return this.boundary.dimensions();
    }

    public final Atom firstAtom() {
        Molecule m = this.firstMolecule();
        return m != null ? m.firstAtom() : null;
    }

    public final Molecule firstMolecule() {
        Species.Agent s = this.firstSpecies;
        while (s != null) {
            Molecule m = s.firstMolecule();
            if (m != null) {
                return m;
            }
            s = s.nextSpecies();
        }
        return null;
    }

    public final Species.Agent firstSpecies() {
        return this.firstSpecies;
    }

    public final int getBoundary() {
        return this.iBoundary;
    }

    public final double getG() {
        return this.gravity.getG();
    }

    public MeterAbstract getMeter(int i) {
        if (i >= this.meterCount) {
            return null;
        }
        MeterAbstract m = this.firstMeter;
        int j = i;
        while (--j >= 0) {
            m = m.nextMeter();
        }
        return m;
    }

    public void inflate(double scale) {
        this.boundary.inflate(scale);
        Molecule m = this.firstMolecule();
        while (m != null) {
            m.inflate(scale);
            m = m.nextMolecule();
        }
    }

    public void initialize(Simulation ps) {
        if (this.iBoundary < 0) {
            this.iBoundary = 1;
        }
        this.moleculeCount = 0;
        this.atomCount = 0;
        this.gravity = new Gravity(0.0);
        this.noGravity = true;
        this.parentSimulation = ps;
        if (Simulation.space() instanceof Iterator.Maker) {
            this.setIterator(((Iterator.Maker)((Object)Simulation.space())).makeIterator(this));
        } else if (this.iterator == null) {
            this.setIterator(new Iterator(this));
        }
        this.setBoundary(this.iBoundary);
        this.add(new ConfigurationSequential());
        this.potentialEnergy = new MeterPotentialEnergy();
        this.potentialEnergy.setUpdateInterval(Integer.MAX_VALUE);
        this.kineticEnergy = new MeterKineticEnergy();
        this.kineticEnergy.setUpdateInterval(Integer.MAX_VALUE);
        this.energy = new MeterEnergy();
        this.energy.setUpdateInterval(Integer.MAX_VALUE);
        this.add(this.potentialEnergy);
        this.add(this.kineticEnergy);
        this.add(this.energy);
        if (this.colorScheme == null) {
            this.colorScheme = new ColorScheme.BySpecies(this);
        }
        this.colorScheme.initialColorAtoms();
    }

    public final Integrator integrator() {
        return this.integrator;
    }

    public final Iterator iterator() {
        return this.iterator;
    }

    public double kineticTemperature() {
        return 2.0 / (double)(this.atomCount * Simulation.space.D()) * this.kineticEnergy.currentValue();
    }

    public final Atom lastAtom() {
        Molecule m = this.lastMolecule();
        return m != null ? m.lastAtom() : null;
    }

    public final Molecule lastMolecule() {
        Species.Agent s = this.lastSpecies;
        while (s != null) {
            Molecule m = s.lastMolecule();
            if (m != null) {
                return m;
            }
            s = s.previousSpecies();
        }
        return null;
    }

    public final Species.Agent lastSpecies() {
        return this.lastSpecies;
    }

    public final int moleculeCount() {
        return this.moleculeCount;
    }

    public final Phase nextPhase() {
        return this.nextPhase;
    }

    public void paint(Graphics g, int[] origin, double scale) {
    }

    public Simulation parentSimulation() {
        return this.parentSimulation;
    }

    public Potential potential() {
        return this.potential;
    }

    public final Phase previousPhase() {
        return this.previousPhase;
    }

    public final Space.Vector randomPosition() {
        return this.boundary.randomPosition();
    }

    public void reflate(double scale) {
        this.boundary.inflate(1.0 / scale);
        Molecule m = this.firstMolecule();
        while (m != null) {
            m.replace();
            m = m.nextMolecule();
        }
    }

    public void removeMolecule(Molecule m) {
        this.removeMolecule(m, m.parentSpecies().getAgent(this));
    }

    public void removeMolecule(Molecule m, Species.Agent s) {
        m.setParentPhase(null);
        --this.moleculeCount;
        this.atomCount -= m.atomCount;
        s.deleteMolecule(m);
        this.iterator.deleteMolecule(m);
    }

    public final void setBoundary(int b) {
        this.iBoundary = b;
        if (this.parentSimulation != null) {
            this.boundary = Simulation.space.makeBoundary(this.iBoundary);
            this.setPotential();
        }
    }

    public void setG(double g) {
        this.gravity.setG(g);
        this.noGravity = g == 0.0;
    }

    public final void setIterator(Iterator it) {
        this.iterator = it;
    }

    public final void setNextPhase(Phase p) {
        this.nextPhase = p;
        p.previousPhase = this;
    }

    public void setPotential() {
        if (this.parentSimulation != null) {
            this.potential = Simulation.space.makePotential(this);
        }
    }

    public final Space space() {
        return Simulation.space();
    }

    public void updateCounts() {
        this.moleculeCount = 0;
        this.atomCount = 0;
        Molecule m = this.firstMolecule();
        while (m != null) {
            ++this.moleculeCount;
            m = m.nextMolecule();
        }
        Atom a = this.firstAtom();
        while (a != null) {
            ++this.atomCount;
            a = a.nextAtom();
        }
    }

    public final double volume() {
        return this.boundary.volume();
    }

    public static class ColorScheme
    extends Component {
        public Color baseColor = Color.black;
        protected Phase phase;
        protected Atom.Iterator iterator;

        public ColorScheme() {
            this(Color.black);
        }

        public ColorScheme(Color c) {
            this.setBaseColor(c);
        }

        public ColorScheme(Phase p) {
            this();
            this.setPhase(p);
        }

        public ColorScheme(Phase p, Color c) {
            this(c);
            this.setPhase(p);
        }

        public void colorAtoms() {
        }

        public final Color getBaseColor() {
            return this.baseColor;
        }

        public void initialColorAtoms() {
            if (this.iterator == null) {
                return;
            }
            this.iterator.reset();
            while (this.iterator.hasNext()) {
                this.iterator.next().setColor(this.baseColor);
            }
        }

        public Phase phase() {
            return this.phase;
        }

        public final void setBaseColor(Color c) {
            this.baseColor = c;
            this.initialColorAtoms();
        }

        public void setPhase(Phase p) {
            this.phase = p;
            this.iterator = this.phase.iterator().makeAtomIteratorUp();
            this.initialColorAtoms();
        }

        public static class BySpecies
        extends ColorScheme {
            public BySpecies() {
            }

            public BySpecies(Phase p) {
                super(p);
            }

            public void colorAtoms() {
                Species.Agent s = this.phase.firstSpecies();
                while (s != null) {
                    if (s.firstAtom() != null) {
                        simulate.ColorScheme cs = s.colorScheme();
                        Atom nextSpeciesAtom = s.terminationAtom();
                        Atom a = s.firstAtom();
                        while (a != nextSpeciesAtom) {
                            cs.setAtomColor(a);
                            a = a.nextAtom();
                        }
                    }
                    s = s.nextSpecies();
                }
            }

            public void initialColorAtoms() {
                if (this.phase == null) {
                    return;
                }
                Species.Agent s = this.phase.firstSpecies();
                while (s != null) {
                    if (s.firstAtom() != null) {
                        simulate.ColorScheme cs = s.colorScheme();
                        Atom nextSpeciesAtom = s.terminationAtom();
                        Atom a = s.firstAtom();
                        while (a != nextSpeciesAtom) {
                            cs.initializeAtomColor(a);
                            a = a.nextAtom();
                        }
                    }
                    s = s.nextSpecies();
                }
            }
        }
    }
}

