/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import simulate.Meter;
import simulate.MeterKineticEnergy;
import simulate.MeterPotentialEnergy;
import simulate.Phase;

public class MeterEnergy
extends Meter {
    private MeterKineticEnergy kinetic;
    private MeterPotentialEnergy potential;

    public MeterEnergy() {
        this.setLabel("Energy");
        this.kinetic = new MeterKineticEnergy();
        this.potential = new MeterPotentialEnergy();
    }

    public double currentValue() {
        return this.kinetic.currentValue() + this.potential.currentValue();
    }

    public double kinetic() {
        return this.kinetic.currentValue();
    }

    public MeterKineticEnergy meterKinetic() {
        return this.kinetic;
    }

    public MeterPotentialEnergy meterPotential() {
        return this.potential;
    }

    public double potential() {
        return this.potential.currentValue();
    }

    public void setPhase(Phase p) {
        super.setPhase(p);
        this.kinetic.setPhase(p);
        this.potential.setPhase(p);
    }
}

