/*
 * Decompiled with CFR 0.152.
 */
package montecarlo;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.Random;
import montecarlo.Histogram;

public class Markov {
    private int nStates;
    double[][] p;
    double[][] pnew;
    double[][] Q;
    public Histogram histogram;
    private Random random = new Random();
    private int currentState = 0;
    private double[][] p3;

    public Markov() {
        this(3);
        this.computeQ();
    }

    public Markov(int n) {
        double[][] dArrayArray = new double[3][];
        dArrayArray[0] = new double[]{0.1, 0.5, 0.4};
        double[] dArray = new double[3];
        dArray[0] = 0.9;
        dArray[1] = 0.1;
        dArrayArray[1] = dArray;
        dArrayArray[2] = new double[]{0.4, 0.2, 0.4};
        this.p3 = dArrayArray;
        this.setNStates(n);
    }

    void computeQ() {
        int n = 0;
        while (n < this.nStates) {
            this.Q[n][0] = this.p[n][0];
            int n2 = 1;
            while (n2 < this.nStates) {
                this.Q[n][n2] = this.Q[n][n2 - 1] + this.p[n][n2];
                ++n2;
            }
            ++n;
        }
    }

    public void doStep() {
        double d = this.random.nextDouble();
        int n = 0;
        while (n < this.nStates) {
            if (d < this.Q[this.currentState][n]) {
                this.currentState = n;
                break;
            }
            ++n;
        }
        this.histogram.addValue((double)this.currentState + 1.0);
    }

    public int getCurrentState() {
        return this.currentState;
    }

    public int getNStates() {
        return this.nStates;
    }

    public double[][] getP() {
        return this.p;
    }

    public void setCurrentState(int n) {
        this.currentState = n;
    }

    public void setNStates(int n) {
        this.nStates = n;
        this.p = new double[n][n];
        this.pnew = new double[n][n];
        this.Q = new double[n][n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            while (n3 < n) {
                this.p[n2][n3] = n == 3 ? this.p3[n2][n3] : 1.0 / (double)n;
                this.pnew[n2][n3] = this.p[n2][n3];
                ++n3;
            }
            ++n2;
        }
        this.computeQ();
        this.histogram = new Histogram(n, 0.5, (double)n + 0.5);
        this.currentState = 0;
    }

    public class StateDisplay
    extends Panel
    implements ItemListener {
        Checkbox[] buttons;
        CheckboxGroup group = new CheckboxGroup();

        public StateDisplay() {
            this.setupDisplay(Markov.this.nStates);
            this.setLayout(new GridLayout(10, 1, 0, 0));
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() != 1) {
                return;
            }
            Checkbox checkbox = (Checkbox)itemEvent.getItemSelectable();
            int n = 0;
            while (n < Markov.this.nStates) {
                if (checkbox == this.buttons[n]) {
                    Markov.this.currentState = n;
                    System.out.println("new state " + n);
                    return;
                }
                ++n;
            }
        }

        public void setupDisplay(int n) {
            this.removeAll();
            this.setLayout(new GridLayout(10, 1, 0, 0));
            this.buttons = new Checkbox[n];
            int n2 = 0;
            while (n2 < n) {
                this.buttons[n2] = new Checkbox();
                this.buttons[n2].setCheckboxGroup(this.group);
                this.buttons[n2].setLabel("State " + Integer.toString(n2 + 1));
                this.add(this.buttons[n2]);
                this.buttons[n2].addItemListener(this);
                ++n2;
            }
            this.update();
        }

        public void update() {
            this.buttons[Markov.this.currentState].setState(true);
        }
    }

    public class Matrix
    extends Panel {
        MyTextField[][] fields;
        Panel matrixPanel = new Panel();
        Panel buttonPanel = new Panel();
        Button resetButton = new Button("Revert to last values");
        Button acceptButton = new Button("Accept new values");

        public Matrix() {
            this.fields = new MyTextField[Markov.this.nStates][Markov.this.nStates];
            int n = 0;
            while (n < Markov.this.nStates) {
                int n2 = 0;
                while (n2 < Markov.this.nStates) {
                    MyTextField[] myTextFieldArray = this.fields[n];
                    Markov markov2 = Markov.this;
                    markov2.getClass();
                    myTextFieldArray[n2] = markov2.new MyTextField(n, n2, Markov.this.p[n][n2]);
                    this.matrixPanel.add(this.fields[n][n2]);
                    ++n2;
                }
                ++n;
            }
            this.matrixPanel.setLayout(new GridLayout(Markov.this.nStates, Markov.this.nStates, 0, 0));
            this.buttonPanel.setLayout(new GridLayout(2, 2, 0, 0));
            this.buttonPanel.setSize(100, 20);
            this.resetButton.setBackground(new Color(204, 204, 153));
            this.acceptButton.setBackground(new Color(204, 204, 153));
            this.buttonPanel.add(this.resetButton);
            this.buttonPanel.add(this.acceptButton);
            this.setLayout(new BorderLayout(5, 5));
            this.add("North", this.matrixPanel);
            this.add("Center", this.buttonPanel);
            this.buttonPanel.add(new Panel());
            this.buttonPanel.add(new Panel());
            this.doLayout();
            this.resetButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ Matrix this$1;
                {
                    this.this$1 = matrix;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.revert();
                }
            });
            this.acceptButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ Matrix this$1;
                {
                    this.this$1 = matrix;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$1.accept();
                }
            });
        }

        public void accept() {
            int n;
            int n2 = 0;
            while (n2 < Markov.this.nStates) {
                n = 0;
                while (n < Markov.this.nStates) {
                    Markov.this.p[n2][n] = Markov.this.pnew[n2][n];
                    ++n;
                }
                ++n2;
            }
            Markov.this.computeQ();
            n = 0;
            while (n < Markov.this.nStates) {
                int n3 = 0;
                while (n3 < Markov.this.nStates) {
                    double[] dArray = Markov.this.p[n];
                    int n4 = n3;
                    dArray[n4] = dArray[n4] / Markov.this.Q[n][Markov.this.nStates - 1];
                    ((TextComponent)this.fields[n][n3]).setText(new Float(Markov.this.p[n][n3]).toString());
                    ++n3;
                }
                ++n;
            }
            Markov.this.computeQ();
            Markov.this.histogram.reset();
            this.getParent().doLayout();
        }

        public void revert() {
            System.out.println("inside revert");
            int n = 0;
            while (n < Markov.this.nStates) {
                int n2 = 0;
                while (n2 < Markov.this.nStates) {
                    Markov.this.pnew[n][n2] = Markov.this.p[n][n2];
                    ((TextComponent)this.fields[n][n2]).setText(new Float(Markov.this.p[n][n2]).toString());
                    ++n2;
                }
                ++n;
            }
            this.repaint();
        }
    }

    class MyTextField
    extends TextField
    implements TextListener {
        int i;
        int j;
        double myP;

        MyTextField(int n, int n2, double d) {
            this.i = n;
            this.j = n2;
            this.myP = d;
            ((TextComponent)this).setText(new Float(d).toString());
            this.addTextListener(this);
        }

        public void textValueChanged(TextEvent textEvent) {
            double d = Double.valueOf(this.getText());
            if (d < 0.0) {
                d = Math.max(0.0, d);
                ((TextComponent)this).setText(new Float(d).toString());
            }
            Markov.this.pnew[this.i][this.j] = d;
            ((Matrix)this.getParent().getParent()).resetButton.setVisible(true);
            ((Matrix)this.getParent().getParent()).acceptButton.setVisible(true);
            this.getParent().getParent().getParent().doLayout();
        }
    }
}

