/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.tree;

import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.Vector;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class VariableHeightLayoutCache
extends AbstractLayoutCache {
    private Vector visibleNodes;
    private boolean updateNodeSizes;
    private TreeStateNode root;
    private Rectangle boundsBuffer;
    private Hashtable treePathMapping;
    private Stack tempStacks = new Stack();

    public VariableHeightLayoutCache() {
        this.visibleNodes = new Vector();
        this.boundsBuffer = new Rectangle();
        this.treePathMapping = new Hashtable();
    }

    static /* synthetic */ boolean access$5(VariableHeightLayoutCache variableHeightLayoutCache) {
        return variableHeightLayoutCache.updateNodeSizes;
    }

    static /* synthetic */ void access$8(VariableHeightLayoutCache variableHeightLayoutCache) {
        variableHeightLayoutCache.visibleNodesChanged();
    }

    private void addMapping(TreeStateNode treeStateNode) {
        this.treePathMapping.put(treeStateNode.getTreePath(), treeStateNode);
    }

    private TreeStateNode createNodeAt(TreeStateNode treeStateNode, int n) {
        boolean bl;
        TreeStateNode treeStateNode2;
        try {
            Object object = this.treeModel.getChild(treeStateNode.getValue(), n);
            treeStateNode2 = this.createNodeForValue(object);
            treeStateNode.insert(treeStateNode2, n);
            treeStateNode2.updatePreferredSize(-1);
        }
        catch (Exception exception) {
            treeStateNode2 = null;
        }
        boolean bl2 = bl = treeStateNode == this.root;
        if (treeStateNode2 != null && treeStateNode.isExpanded() && (treeStateNode.getRow() != -1 || bl)) {
            int n2;
            if (n == 0) {
                n2 = bl && !this.isRootVisible() ? 0 : treeStateNode.getRow() + 1;
            } else if (n == treeStateNode.getChildCount()) {
                n2 = treeStateNode.getLastVisibleNode().getRow() + 1;
            } else {
                TreeStateNode treeStateNode3 = (TreeStateNode)treeStateNode.getChildAt(n - 1);
                n2 = treeStateNode3.getLastVisibleNode().getRow() + 1;
            }
            this.visibleNodes.insertElementAt(treeStateNode2, n2);
        }
        return treeStateNode2;
    }

    private TreeStateNode createNodeForValue(Object object) {
        return new TreeStateNode(object);
    }

    private void ensurePathIsExpanded(TreePath treePath, boolean bl) {
        if (treePath != null) {
            TreeStateNode treeStateNode;
            if (this.treeModel.isLeaf(treePath.getLastPathComponent())) {
                treePath = treePath.getParentPath();
                bl = true;
            }
            if (treePath != null && (treeStateNode = this.getNodeForPath(treePath, false, true)) != null) {
                treeStateNode.makeVisible();
                if (bl) {
                    treeStateNode.expand();
                }
            }
        }
    }

    private Rectangle getBounds(int n, Rectangle rectangle) {
        if (this.updateNodeSizes) {
            this.updateNodeSizes(false);
        }
        if (n >= 0 && n < this.getRowCount()) {
            return this.getNode(n).getNodeBounds(rectangle);
        }
        return null;
    }

    public Rectangle getBounds(TreePath treePath, Rectangle rectangle) {
        TreeStateNode treeStateNode = this.getNodeForPath(treePath, true, false);
        if (treeStateNode != null) {
            if (this.updateNodeSizes) {
                this.updateNodeSizes(false);
            }
            return treeStateNode.getNodeBounds(rectangle);
        }
        return null;
    }

    public boolean getExpandedState(TreePath treePath) {
        TreeStateNode treeStateNode = this.getNodeForPath(treePath, true, false);
        return treeStateNode != null ? treeStateNode.isVisible() && treeStateNode.isExpanded() : false;
    }

    private TreeStateNode getMapping(TreePath treePath) {
        return (TreeStateNode)this.treePathMapping.get(treePath);
    }

    private int getMaxNodeWidth() {
        int n = 0;
        int n2 = this.getRowCount() - 1;
        while (n2 >= 0) {
            TreeStateNode treeStateNode = this.getNode(n2);
            int n3 = treeStateNode.getPreferredWidth() + treeStateNode.getXOrigin();
            if (n3 > n) {
                n = n3;
            }
            --n2;
        }
        return n;
    }

    private TreeStateNode getNode(int n) {
        return (TreeStateNode)this.visibleNodes.elementAt(n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TreeStateNode getNodeForPath(TreePath treePath, boolean bl, boolean bl2) {
        if (treePath == null) return null;
        TreeStateNode treeStateNode = this.getMapping(treePath);
        if (treeStateNode != null) {
            if (!bl) return treeStateNode;
            if (treeStateNode.isVisible()) return treeStateNode;
            return null;
        }
        Stack stack = this.tempStacks.size() == 0 ? new Stack() : (Stack)this.tempStacks.pop();
        try {
            stack.push(treePath);
            treePath = treePath.getParentPath();
            treeStateNode = null;
            while (treePath != null) {
                treeStateNode = this.getMapping(treePath);
                if (treeStateNode != null) {
                    while (true) {
                        if (treeStateNode == null || stack.size() <= 0) break;
                        treePath = (TreePath)stack.pop();
                        treeStateNode.getLoadedChildren(bl2);
                        int n = this.treeModel.getIndexOfChild(treeStateNode.getUserObject(), treePath.getLastPathComponent());
                        if (n == -1 || n >= treeStateNode.getChildCount() || bl && !treeStateNode.isVisible()) {
                            treeStateNode = null;
                            continue;
                        }
                        treeStateNode = (TreeStateNode)treeStateNode.getChildAt(n);
                    }
                    TreeStateNode treeStateNode2 = treeStateNode;
                    Object var8_8 = null;
                    stack.removeAllElements();
                    this.tempStacks.push(stack);
                    return treeStateNode2;
                }
                stack.push(treePath);
                treePath = treePath.getParentPath();
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            stack.removeAllElements();
            this.tempStacks.push(stack);
            throw throwable;
        }
        Object var8_9 = null;
        stack.removeAllElements();
        this.tempStacks.push(stack);
        return null;
    }

    public TreePath getPathClosestTo(int n, int n2) {
        if (this.getRowCount() == 0) {
            return null;
        }
        if (this.updateNodeSizes) {
            this.updateNodeSizes(false);
        }
        int n3 = this.getRowContainingYLocation(n2);
        return this.getNode(n3).getTreePath();
    }

    public TreePath getPathForRow(int n) {
        if (n >= 0 && n < this.getRowCount()) {
            return this.getNode(n).getTreePath();
        }
        return null;
    }

    public int getPreferredWidth(Rectangle rectangle) {
        if (this.updateNodeSizes) {
            this.updateNodeSizes(false);
        }
        return this.getMaxNodeWidth();
    }

    private int getRowContainingYLocation(int n) {
        if (this.isFixedRowHeight()) {
            if (this.getRowCount() == 0) {
                return -1;
            }
            return Math.max(0, Math.min(this.getRowCount() - 1, n / this.getRowHeight()));
        }
        int n2 = this.getRowCount();
        if (n2 <= 0) {
            return -1;
        }
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            n4 = (n2 - n3) / 2 + n3;
            TreeStateNode treeStateNode = (TreeStateNode)this.visibleNodes.elementAt(n4);
            int n5 = treeStateNode.getYOrigin();
            int n6 = n5 + treeStateNode.getPreferredHeight();
            if (n < n5) {
                n2 = n4 - 1;
                continue;
            }
            if (n < n6) break;
            n3 = n4 + 1;
        }
        if (n3 == n2 && (n4 = n3) >= this.getRowCount()) {
            n4 = this.getRowCount() - 1;
        }
        return n4;
    }

    public int getRowCount() {
        return this.visibleNodes.size();
    }

    public int getRowForPath(TreePath treePath) {
        if (treePath == null) {
            return -1;
        }
        TreeStateNode treeStateNode = this.getNodeForPath(treePath, true, false);
        if (treeStateNode != null) {
            return treeStateNode.getRow();
        }
        return -1;
    }

    public int getVisibleChildCount(TreePath treePath) {
        TreeStateNode treeStateNode = this.getNodeForPath(treePath, true, false);
        return treeStateNode != null ? treeStateNode.getVisibleChildCount() : 0;
    }

    public Enumeration getVisiblePathsFrom(TreePath treePath) {
        TreeStateNode treeStateNode = this.getNodeForPath(treePath, true, false);
        if (treeStateNode != null) {
            return new VisibleTreeStateNodeEnumeration(treeStateNode);
        }
        return null;
    }

    public void invalidatePathBounds(TreePath treePath) {
        TreeStateNode treeStateNode = this.getNodeForPath(treePath, true, false);
        if (treeStateNode != null) {
            treeStateNode.markSizeInvalid();
            if (treeStateNode.isVisible()) {
                this.updateYLocationsFrom(treeStateNode.getRow());
            }
        }
    }

    public void invalidateSizes() {
        if (this.root != null) {
            this.root.deepMarkSizeInvalid();
        }
        if (!this.isFixedRowHeight() && this.visibleNodes.size() > 0) {
            this.updateNodeSizes(true);
        }
    }

    public boolean isExpanded(TreePath treePath) {
        if (treePath != null) {
            TreeStateNode treeStateNode = this.getNodeForPath(treePath, true, false);
            return treeStateNode != null && treeStateNode.isExpanded();
        }
        return false;
    }

    private void rebuild() {
        this.treePathMapping.clear();
        if (this.treeModel != null) {
            Object object = this.treeModel.getRoot();
            this.root = this.createNodeForValue(object);
            this.root.path = new TreePath(object);
            this.addMapping(this.root);
            this.root.updatePreferredSize(0);
            this.visibleNodes.removeAllElements();
            if (this.isRootVisible()) {
                this.visibleNodes.addElement(this.root);
            }
            if (!this.root.isExpanded()) {
                this.root.expand();
            } else {
                Enumeration enumeration = this.root.children();
                while (enumeration.hasMoreElements()) {
                    this.visibleNodes.addElement(enumeration.nextElement());
                }
                if (!this.isFixedRowHeight()) {
                    this.updateYLocationsFrom(0);
                }
            }
        } else {
            this.visibleNodes.removeAllElements();
            this.root = null;
        }
        if (this.treeSelectionModel != null) {
            this.treeSelectionModel.clearSelection();
        }
        this.visibleNodesChanged();
    }

    private void removeMapping(TreeStateNode treeStateNode) {
        this.treePathMapping.remove(treeStateNode.getTreePath());
    }

    public void setExpandedState(TreePath treePath, boolean bl) {
        if (treePath != null) {
            if (bl) {
                this.ensurePathIsExpanded(treePath, true);
            } else {
                TreeStateNode treeStateNode = this.getNodeForPath(treePath, false, true);
                if (treeStateNode != null) {
                    treeStateNode.makeVisible();
                    treeStateNode.collapse();
                }
            }
        }
    }

    public void setModel(TreeModel treeModel) {
        super.setModel(treeModel);
        this.rebuild();
    }

    public void setNodeDimensions(AbstractLayoutCache.NodeDimensions nodeDimensions) {
        super.setNodeDimensions(nodeDimensions);
        this.invalidateSizes();
        this.visibleNodesChanged();
    }

    public void setRootVisible(boolean bl) {
        if (this.isRootVisible() != bl && this.root != null) {
            if (bl) {
                this.root.updatePreferredSize(0);
                this.visibleNodes.insertElementAt(this.root, 0);
            } else if (this.visibleNodes.size() > 0) {
                this.visibleNodes.removeElementAt(0);
                if (this.treeSelectionModel != null) {
                    this.treeSelectionModel.removeSelectionPath(this.root.getTreePath());
                }
            }
            if (this.treeSelectionModel != null) {
                this.treeSelectionModel.resetRowSelection();
            }
            if (this.getRowCount() > 0) {
                this.getNode(0).setYOrigin(0);
            }
            this.updateYLocationsFrom(0);
            this.visibleNodesChanged();
        }
        super.setRootVisible(bl);
    }

    public void setRowHeight(int n) {
        if (n != this.getRowHeight()) {
            super.setRowHeight(n);
            this.invalidateSizes();
            this.visibleNodesChanged();
        }
    }

    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        if (treeModelEvent != null) {
            int[] nArray = treeModelEvent.getChildIndices();
            TreeStateNode treeStateNode = this.getNodeForPath(treeModelEvent.getTreePath(), false, false);
            if (treeStateNode != null) {
                int n;
                Object object = treeStateNode.getValue();
                treeStateNode.updatePreferredSize();
                if (nArray != null) {
                    n = 0;
                    while (n < nArray.length) {
                        try {
                            TreeStateNode treeStateNode2 = (TreeStateNode)treeStateNode.getChildAt(nArray[n]);
                            treeStateNode2.setUserObject(this.treeModel.getChild(object, nArray[n]));
                            treeStateNode2.updatePreferredSize();
                        }
                        catch (Exception exception) {}
                        ++n;
                    }
                }
                if (!this.isFixedRowHeight() && (n = treeStateNode.getRow()) != -1) {
                    this.updateYLocationsFrom(n);
                }
                this.visibleNodesChanged();
            }
        }
    }

    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        if (treeModelEvent != null) {
            int[] nArray = treeModelEvent.getChildIndices();
            TreeStateNode treeStateNode = this.getNodeForPath(treeModelEvent.getTreePath(), false, false);
            if (treeStateNode != null && nArray != null && nArray.length > 0) {
                if (treeStateNode.hasBeenExpanded()) {
                    int n = treeStateNode.getChildCount();
                    Object object = treeStateNode.getValue();
                    boolean bl = treeStateNode == this.root && !this.rootVisible || treeStateNode.getRow() != -1 && treeStateNode.isExpanded();
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        TreeStateNode treeStateNode2 = this.createNodeAt(treeStateNode, nArray[n2]);
                        ++n2;
                    }
                    if (n == 0) {
                        treeStateNode.updatePreferredSize();
                    }
                    if (this.treeSelectionModel != null) {
                        this.treeSelectionModel.resetRowSelection();
                    }
                    if (!this.isFixedRowHeight() && (bl || n == 0 && treeStateNode.isVisible())) {
                        if (treeStateNode == this.root) {
                            this.updateYLocationsFrom(0);
                        } else {
                            this.updateYLocationsFrom(treeStateNode.getRow());
                        }
                        this.visibleNodesChanged();
                    } else if (bl) {
                        this.visibleNodesChanged();
                    }
                } else if (this.treeModel.getChildCount(treeStateNode.getValue()) - nArray.length == 0) {
                    treeStateNode.updatePreferredSize();
                    if (!this.isFixedRowHeight() && treeStateNode.isVisible()) {
                        this.updateYLocationsFrom(treeStateNode.getRow());
                    }
                }
            }
        }
    }

    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        if (treeModelEvent != null) {
            int[] nArray = treeModelEvent.getChildIndices();
            TreeStateNode treeStateNode = this.getNodeForPath(treeModelEvent.getTreePath(), false, false);
            if (treeStateNode != null && nArray != null && nArray.length > 0) {
                if (treeStateNode.hasBeenExpanded()) {
                    boolean bl = treeStateNode == this.root && !this.rootVisible || treeStateNode.getRow() != -1 && treeStateNode.isExpanded();
                    int n = nArray.length - 1;
                    while (n >= 0) {
                        try {
                            int n2;
                            TreeStateNode treeStateNode2 = (TreeStateNode)treeStateNode.getChildAt(nArray[n]);
                            if (treeStateNode2.isExpanded()) {
                                treeStateNode2.collapse(false);
                            }
                            if (bl && (n2 = treeStateNode2.getRow()) != -1) {
                                this.visibleNodes.removeElementAt(n2);
                                if (this.treeSelectionModel != null) {
                                    TreePath treePath = treeStateNode2.getTreePath();
                                    this.treeSelectionModel.removeSelectionPath(treePath);
                                }
                            }
                            treeStateNode.remove(nArray[n]);
                        }
                        catch (Exception exception) {
                            System.err.println("Exception removing node" + exception);
                        }
                        --n;
                    }
                    if (treeStateNode.getChildCount() == 0) {
                        treeStateNode.updatePreferredSize();
                    }
                    if (this.treeSelectionModel != null) {
                        this.treeSelectionModel.resetRowSelection();
                    }
                    if (!this.isFixedRowHeight() && (bl || treeStateNode.getChildCount() == 0 && treeStateNode.isVisible())) {
                        if (treeStateNode == this.root) {
                            if (this.getRowCount() > 0) {
                                this.getNode(0).setYOrigin(0);
                            }
                            this.updateYLocationsFrom(0);
                        } else {
                            this.updateYLocationsFrom(treeStateNode.getRow());
                        }
                        this.visibleNodesChanged();
                    } else if (bl) {
                        this.visibleNodesChanged();
                    }
                } else if (this.treeModel.getChildCount(treeStateNode.getValue()) == 0) {
                    treeStateNode.updatePreferredSize();
                    if (!this.isFixedRowHeight() && treeStateNode.isVisible()) {
                        this.updateYLocationsFrom(treeStateNode.getRow());
                    }
                }
            }
        }
    }

    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        if (treeModelEvent != null) {
            TreePath treePath = treeModelEvent.getTreePath();
            TreeStateNode treeStateNode = this.getNodeForPath(treePath, false, false);
            if (treeStateNode == null && treePath != null && treePath.getPathCount() == 1) {
                treeStateNode = this.root;
            }
            if (treeStateNode != null) {
                boolean bl;
                boolean bl2 = treeStateNode.isExpanded();
                boolean bl3 = bl = treeStateNode.getRow() != -1;
                if (treeStateNode == this.root) {
                    this.rebuild();
                } else {
                    TreeStateNode treeStateNode2 = (TreeStateNode)treeStateNode.getParent();
                    int n = treeStateNode2.getIndex(treeStateNode);
                    if (bl && bl2) {
                        treeStateNode.collapse(false);
                    }
                    if (bl) {
                        this.visibleNodes.removeElement(treeStateNode);
                    }
                    treeStateNode.removeFromParent();
                    this.createNodeAt(treeStateNode2, n);
                    TreeStateNode treeStateNode3 = (TreeStateNode)treeStateNode2.getChildAt(n);
                    if (bl && bl2) {
                        treeStateNode3.expand(false);
                    }
                    int n2 = treeStateNode3.getRow();
                    if (!this.isFixedRowHeight() && bl) {
                        if (n2 == 0) {
                            this.updateYLocationsFrom(n2);
                        } else {
                            this.updateYLocationsFrom(n2 - 1);
                        }
                        this.visibleNodesChanged();
                    } else if (bl) {
                        this.visibleNodesChanged();
                    }
                }
            }
        }
    }

    private void updateNodeSizes(boolean bl) {
        this.updateNodeSizes = false;
        int n = 0;
        int n2 = 0;
        int n3 = this.visibleNodes.size();
        while (n < n3) {
            TreeStateNode treeStateNode = (TreeStateNode)this.visibleNodes.elementAt(n);
            treeStateNode.setYOrigin(n2);
            if (bl || !treeStateNode.hasValidSize()) {
                treeStateNode.updatePreferredSize(n);
            }
            n2 += treeStateNode.getPreferredHeight();
            ++n;
        }
    }

    private void updateYLocationsFrom(int n) {
        if (n >= 0 && n < this.getRowCount()) {
            TreeStateNode treeStateNode = this.getNode(n);
            int n2 = treeStateNode.getYOrigin() + treeStateNode.getPreferredHeight();
            int n3 = n + 1;
            int n4 = this.visibleNodes.size();
            while (n3 < n4) {
                treeStateNode = (TreeStateNode)this.visibleNodes.elementAt(n3);
                treeStateNode.setYOrigin(n2);
                n2 += treeStateNode.getPreferredHeight();
                ++n3;
            }
        }
    }

    private void visibleNodesChanged() {
    }

    private class TreeStateNode
    extends DefaultMutableTreeNode {
        protected int preferredWidth;
        protected int preferredHeight;
        protected int xOrigin;
        protected int yOrigin;
        protected boolean expanded;
        protected boolean hasBeenExpanded;
        protected TreePath path;

        public TreeStateNode(Object object) {
            super(object);
        }

        public Enumeration children() {
            if (!this.isExpanded()) {
                return DefaultMutableTreeNode.EMPTY_ENUMERATION;
            }
            return super.children();
        }

        public void collapse() {
            this.collapse(true);
        }

        /*
         * Unable to fully structure code
         */
        protected void collapse(boolean var1_1) {
            block14: {
                block15: {
                    if (!this.isExpanded()) break block14;
                    var2_2 = null;
                    var3_3 = this.preorderEnumeration();
                    var3_3.nextElement();
                    var4_4 = 0;
                    var5_5 = VariableHeightLayoutCache.this.isFixedRowHeight();
                    var6_6 = var5_5 != false ? 0 : this.getPreferredHeight() + this.getYOrigin();
                    var7_7 = this.getPreferredHeight();
                    var8_8 = var6_6;
                    var9_9 = this.getRow();
                    this.expanded = false;
                    if (var9_9 == -1) {
                        this.markSizeInvalid();
                    } else {
                        this.updatePreferredSize(var9_9);
                    }
                    if (var5_5) ** GOTO lbl38
                    while (var3_3.hasMoreElements()) {
                        var10_10 = (TreeStateNode)var3_3.nextElement();
                        if (!VariableHeightLayoutCache.access$1(VariableHeightLayoutCache.this).contains(var10_10)) continue;
                        if (VariableHeightLayoutCache.this.treeSelectionModel != null && VariableHeightLayoutCache.this.treeSelectionModel.isRowSelected(++var4_4 + var9_9)) {
                            if (var2_2 == null) {
                                var2_2 = new Vector<E>();
                            }
                            var2_2.addElement(var10_10.getTreePath());
                        }
                        VariableHeightLayoutCache.access$1(VariableHeightLayoutCache.this).removeElement(var10_10);
                        var6_6 = var10_10.getYOrigin() + var10_10.getPreferredHeight();
                    }
                    break block15;
lbl-1000:
                    // 1 sources

                    {
                        var10_10 = (TreeStateNode)var3_3.nextElement();
                        if (!VariableHeightLayoutCache.access$1(VariableHeightLayoutCache.this).contains(var10_10)) continue;
                        if (VariableHeightLayoutCache.this.treeSelectionModel != null && VariableHeightLayoutCache.this.treeSelectionModel.isRowSelected(++var4_4 + var9_9)) {
                            if (var2_2 == null) {
                                var2_2 = new Vector<TreePath>();
                            }
                            var2_2.addElement(var10_10.getTreePath());
                        }
                        VariableHeightLayoutCache.access$1(VariableHeightLayoutCache.this).removeElement(var10_10);
lbl38:
                        // 3 sources

                        ** while (var3_3.hasMoreElements())
                    }
                }
                if (var9_9 != -1 && var1_1 && (var4_4 > 0 || var7_7 != this.getPreferredHeight())) {
                    if (!var5_5 && var9_9 + 1 < VariableHeightLayoutCache.this.getRowCount() && (var8_8 += this.getPreferredHeight() - var7_7) != var6_6) {
                        var12_13 = var8_8 - var6_6;
                        var10_11 = var9_9 + 1;
                        var11_14 = VariableHeightLayoutCache.access$1(VariableHeightLayoutCache.this).size();
                        while (var10_11 < var11_14) {
                            ((TreeStateNode)VariableHeightLayoutCache.access$1(VariableHeightLayoutCache.this).elementAt(var10_11)).shiftYOriginBy(var12_13);
                            ++var10_11;
                        }
                    }
                    this.didAdjustTree();
                    VariableHeightLayoutCache.access$8(VariableHeightLayoutCache.this);
                }
                if (VariableHeightLayoutCache.this.treeSelectionModel != null && var4_4 > 0 && var9_9 != -1) {
                    if (var2_2 != null) {
                        var10_12 = var2_2.size();
                        var11_15 = new TreePath[var10_12];
                        var2_2.copyInto(var11_15);
                        VariableHeightLayoutCache.this.treeSelectionModel.removeSelectionPaths((TreePath[])var11_15);
                        VariableHeightLayoutCache.this.treeSelectionModel.addSelectionPath(this.getTreePath());
                    } else {
                        VariableHeightLayoutCache.this.treeSelectionModel.resetRowSelection();
                    }
                }
            }
        }

        protected void deepMarkSizeInvalid() {
            this.markSizeInvalid();
            int n = this.getChildCount() - 1;
            while (n >= 0) {
                ((TreeStateNode)this.getChildAt(n)).deepMarkSizeInvalid();
                --n;
            }
        }

        protected void didAdjustTree() {
        }

        public void expand() {
            this.expand(true);
        }

        /*
         * Unable to fully structure code
         */
        protected void expand(boolean var1_1) {
            block12: {
                block13: {
                    if (this.isExpanded() || this.isLeaf()) break block12;
                    var2_2 = VariableHeightLayoutCache.this.isFixedRowHeight();
                    var3_3 = this.getPreferredHeight();
                    var4_4 = this.getRow();
                    this.expanded = true;
                    this.updatePreferredSize(var4_4);
                    if (!this.hasBeenExpanded) {
                        var6_5 = this.getValue();
                        var7_6 = VariableHeightLayoutCache.this.getModel();
                        var8_8 = var7_6.getChildCount(var6_5);
                        this.hasBeenExpanded = true;
                        if (var4_4 == -1) {
                            var9_11 = 0;
                            while (var9_11 < var8_8) {
                                var5_12 = VariableHeightLayoutCache.access$7(VariableHeightLayoutCache.this, var7_6.getChild(var6_5, var9_11));
                                this.add(var5_12);
                                var5_12.updatePreferredSize(-1);
                                ++var9_11;
                            }
                        } else {
                            var9_11 = var4_4 + 1;
                            var10_14 = 0;
                            while (var10_14 < var8_8) {
                                var5_12 = VariableHeightLayoutCache.access$7(VariableHeightLayoutCache.this, var7_6.getChild(var6_5, var10_14));
                                this.add(var5_12);
                                var5_12.updatePreferredSize(var9_11);
                                ++var10_14;
                            }
                        }
                    }
                    var5_13 = var4_4;
                    var6_5 = this.preorderEnumeration();
                    var6_5.nextElement();
                    var7_7 = var2_2 != false ? 0 : (this == VariableHeightLayoutCache.access$2(VariableHeightLayoutCache.this) && VariableHeightLayoutCache.this.isRootVisible() == false ? 0 : this.getYOrigin() + this.getPreferredHeight());
                    if (var2_2) ** GOTO lbl46
                    while (var6_5.hasMoreElements()) {
                        var8_9 = (TreeStateNode)var6_5.nextElement();
                        if (!VariableHeightLayoutCache.access$5(VariableHeightLayoutCache.this) && !var8_9.hasValidSize()) {
                            var8_9.updatePreferredSize(var5_13 + 1);
                        }
                        var8_9.setYOrigin(var7_7);
                        var7_7 += var8_9.getPreferredHeight();
                        VariableHeightLayoutCache.access$1(VariableHeightLayoutCache.this).insertElementAt(var8_9, ++var5_13);
                    }
                    break block13;
lbl-1000:
                    // 1 sources

                    {
                        var8_10 = (TreeStateNode)var6_5.nextElement();
                        VariableHeightLayoutCache.access$1(VariableHeightLayoutCache.this).insertElementAt(var8_10, ++var5_13);
lbl46:
                        // 2 sources

                        ** while (var6_5.hasMoreElements())
                    }
                }
                if (var1_1 && (var4_4 != var5_13 || this.getPreferredHeight() != var3_3)) {
                    if (!var2_2 && ++var5_13 < VariableHeightLayoutCache.this.getRowCount()) {
                        var10_14 = var7_7 - (this.getYOrigin() + this.getPreferredHeight()) + (this.getPreferredHeight() - var3_3);
                        var9_11 = VariableHeightLayoutCache.access$1(VariableHeightLayoutCache.this).size() - 1;
                        while (var9_11 >= var5_13) {
                            ((TreeStateNode)VariableHeightLayoutCache.access$1(VariableHeightLayoutCache.this).elementAt(var9_11)).shiftYOriginBy(var10_14);
                            --var9_11;
                        }
                    }
                    this.didAdjustTree();
                    VariableHeightLayoutCache.access$8(VariableHeightLayoutCache.this);
                }
                if (VariableHeightLayoutCache.this.treeSelectionModel != null) {
                    VariableHeightLayoutCache.this.treeSelectionModel.resetRowSelection();
                }
            }
        }

        protected void expandParentAndReceiver() {
            TreeStateNode treeStateNode = (TreeStateNode)this.getParent();
            if (treeStateNode != null) {
                treeStateNode.expandParentAndReceiver();
            }
            this.expand();
        }

        public TreeStateNode getLastVisibleNode() {
            TreeStateNode treeStateNode = this;
            while (treeStateNode.isExpanded() && treeStateNode.getChildCount() > 0) {
                treeStateNode = (TreeStateNode)treeStateNode.getLastChild();
            }
            return treeStateNode;
        }

        protected Enumeration getLoadedChildren(boolean bl) {
            if (!bl || this.hasBeenExpanded) {
                return super.children();
            }
            Object object = this.getValue();
            TreeModel treeModel = VariableHeightLayoutCache.this.getModel();
            int n = treeModel.getChildCount(object);
            this.hasBeenExpanded = true;
            int n2 = this.getRow();
            if (n2 == -1) {
                int n3 = 0;
                while (n3 < n) {
                    TreeStateNode treeStateNode = VariableHeightLayoutCache.this.createNodeForValue(treeModel.getChild(object, n3));
                    this.add(treeStateNode);
                    treeStateNode.updatePreferredSize(-1);
                    ++n3;
                }
            } else {
                ++n2;
                int n4 = 0;
                while (n4 < n) {
                    TreeStateNode treeStateNode = VariableHeightLayoutCache.this.createNodeForValue(treeModel.getChild(object, n4));
                    this.add(treeStateNode);
                    treeStateNode.updatePreferredSize(n2++);
                    ++n4;
                }
            }
            return super.children();
        }

        public int getModelChildCount() {
            if (this.hasBeenExpanded) {
                return super.getChildCount();
            }
            return VariableHeightLayoutCache.this.getModel().getChildCount(this.getValue());
        }

        public Rectangle getNodeBounds(Rectangle rectangle) {
            if (rectangle == null) {
                rectangle = new Rectangle(this.getXOrigin(), this.getYOrigin(), this.getPreferredWidth(), this.getPreferredHeight());
            } else {
                rectangle.x = this.getXOrigin();
                rectangle.y = this.getYOrigin();
                rectangle.width = this.getPreferredWidth();
                rectangle.height = this.getPreferredHeight();
            }
            return rectangle;
        }

        public int getPreferredHeight() {
            if (VariableHeightLayoutCache.this.isFixedRowHeight()) {
                return VariableHeightLayoutCache.this.getRowHeight();
            }
            if (!this.hasValidSize()) {
                this.updatePreferredSize(this.getRow());
            }
            return this.preferredHeight;
        }

        public int getPreferredWidth() {
            if (!this.hasValidSize()) {
                this.updatePreferredSize(this.getRow());
            }
            return this.preferredWidth;
        }

        public int getRow() {
            return VariableHeightLayoutCache.this.visibleNodes.indexOf(this);
        }

        public TreePath getTreePath() {
            return this.path;
        }

        public Object getValue() {
            return this.getUserObject();
        }

        public int getVisibleChildCount() {
            int n = 0;
            if (this.isExpanded()) {
                int n2 = this.getChildCount();
                n += n2;
                int n3 = 0;
                while (n3 < n2) {
                    ((TreeStateNode)this.getChildAt(n3)).getVisibleChildCount();
                    ++n3;
                }
            }
            return n;
        }

        public int getXOrigin() {
            if (!this.hasValidSize()) {
                this.updatePreferredSize(this.getRow());
            }
            return this.xOrigin;
        }

        public int getYOrigin() {
            if (VariableHeightLayoutCache.this.isFixedRowHeight()) {
                int n = this.getRow();
                if (n == -1) {
                    return -1;
                }
                return VariableHeightLayoutCache.this.getRowHeight() * n;
            }
            return this.yOrigin;
        }

        public boolean hasBeenExpanded() {
            return this.hasBeenExpanded;
        }

        public boolean hasValidSize() {
            return this.preferredHeight != 0;
        }

        public boolean isExpanded() {
            return this.expanded;
        }

        public boolean isLeaf() {
            return VariableHeightLayoutCache.this.getModel().isLeaf(this.getValue());
        }

        public boolean isVisible() {
            if (this == VariableHeightLayoutCache.this.root) {
                return true;
            }
            TreeStateNode treeStateNode = (TreeStateNode)this.getParent();
            return treeStateNode != null && treeStateNode.isExpanded() && treeStateNode.isVisible();
        }

        public void makeVisible() {
            TreeStateNode treeStateNode = (TreeStateNode)this.getParent();
            if (treeStateNode != null) {
                treeStateNode.expandParentAndReceiver();
            }
        }

        protected void markSizeInvalid() {
            this.preferredHeight = 0;
        }

        public void remove(int n) {
            TreeStateNode treeStateNode = (TreeStateNode)this.getChildAt(n);
            treeStateNode.removeFromMapping();
            super.remove(n);
        }

        protected void removeFromMapping() {
            if (this.path != null) {
                VariableHeightLayoutCache.this.removeMapping(this);
                int n = this.getChildCount() - 1;
                while (n >= 0) {
                    ((TreeStateNode)this.getChildAt(n)).removeFromMapping();
                    --n;
                }
            }
        }

        protected void resetChildrenPaths(TreePath treePath) {
            VariableHeightLayoutCache.this.removeMapping(this);
            this.path = treePath == null ? new TreePath(this.getUserObject()) : treePath.pathByAddingChild(this.getUserObject());
            VariableHeightLayoutCache.this.addMapping(this);
            int n = this.getChildCount() - 1;
            while (n >= 0) {
                ((TreeStateNode)this.getChildAt(n)).resetChildrenPaths(this.path);
                --n;
            }
        }

        public void setParent(MutableTreeNode mutableTreeNode) {
            super.setParent(mutableTreeNode);
            if (mutableTreeNode != null) {
                this.path = ((TreeStateNode)mutableTreeNode).getTreePath().pathByAddingChild(this.getUserObject());
                VariableHeightLayoutCache.this.addMapping(this);
            }
        }

        public void setUserObject(Object object) {
            super.setUserObject(object);
            if (this.path != null) {
                TreeStateNode treeStateNode = (TreeStateNode)this.getParent();
                if (treeStateNode != null) {
                    this.resetChildrenPaths(treeStateNode.getTreePath());
                } else {
                    this.resetChildrenPaths(null);
                }
            }
        }

        protected void setYOrigin(int n) {
            this.yOrigin = n;
        }

        protected void shiftYOriginBy(int n) {
            this.yOrigin += n;
        }

        public void toggleExpanded() {
            if (this.isExpanded()) {
                this.collapse();
            } else {
                this.expand();
            }
        }

        protected void updatePreferredSize() {
            this.updatePreferredSize(this.getRow());
        }

        protected void updatePreferredSize(int n) {
            Rectangle rectangle = VariableHeightLayoutCache.this.getNodeDimensions(this.getUserObject(), n, this.getLevel(), this.isExpanded(), VariableHeightLayoutCache.this.boundsBuffer);
            if (rectangle == null) {
                this.xOrigin = 0;
                this.preferredHeight = 0;
                this.preferredWidth = 0;
                VariableHeightLayoutCache.this.updateNodeSizes = true;
            } else if (rectangle.height == 0) {
                this.xOrigin = 0;
                this.preferredHeight = 0;
                this.preferredWidth = 0;
                VariableHeightLayoutCache.this.updateNodeSizes = true;
            } else {
                this.xOrigin = rectangle.x;
                this.preferredWidth = rectangle.width;
                this.preferredHeight = VariableHeightLayoutCache.this.isFixedRowHeight() ? VariableHeightLayoutCache.this.getRowHeight() : rectangle.height;
            }
        }
    }

    private class VisibleTreeStateNodeEnumeration
    implements Enumeration {
        protected TreeStateNode parent;
        protected int nextIndex;
        protected int childCount;

        protected VisibleTreeStateNodeEnumeration(TreeStateNode treeStateNode) {
            this(treeStateNode, -1);
        }

        protected VisibleTreeStateNodeEnumeration(TreeStateNode treeStateNode, int n) {
            this.parent = treeStateNode;
            this.nextIndex = n;
            this.childCount = this.parent.getChildCount();
        }

        /*
         * Unable to fully structure code
         */
        protected boolean findNextValidParent() {
            if (this.parent != VariableHeightLayoutCache.access$2(VariableHeightLayoutCache.this)) ** GOTO lbl12
            this.parent = null;
            return false;
lbl-1000:
            // 1 sources

            {
                var1_1 = (TreeStateNode)this.parent.getParent();
                if (var1_1 != null) {
                    this.nextIndex = var1_1.getIndex(this.parent);
                    this.parent = var1_1;
                    this.childCount = this.parent.getChildCount();
                    if (!this.updateNextIndex()) continue;
                    return true;
                }
                this.parent = null;
lbl12:
                // 3 sources

                ** while (this.parent != null)
            }
lbl13:
            // 1 sources

            return false;
        }

        public boolean hasMoreElements() {
            return this.parent != null;
        }

        public Object nextElement() {
            TreePath treePath;
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException("No more visible paths");
            }
            if (this.nextIndex == -1) {
                treePath = this.parent.getTreePath();
            } else {
                TreeStateNode treeStateNode = (TreeStateNode)this.parent.getChildAt(this.nextIndex);
                treePath = treeStateNode.getTreePath();
            }
            this.updateNextObject();
            return treePath;
        }

        protected boolean updateNextIndex() {
            if (this.nextIndex == -1 && !this.parent.isExpanded()) {
                return false;
            }
            if (this.childCount == 0) {
                return false;
            }
            if (++this.nextIndex >= this.childCount) {
                return false;
            }
            TreeStateNode treeStateNode = (TreeStateNode)this.parent.getChildAt(this.nextIndex);
            if (treeStateNode != null && treeStateNode.isExpanded()) {
                this.parent = treeStateNode;
                this.nextIndex = -1;
                this.childCount = treeStateNode.getChildCount();
            }
            return true;
        }

        protected void updateNextObject() {
            if (!this.updateNextIndex()) {
                this.findNextValidParent();
            }
        }
    }
}

