/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.FontMetrics;
import java.text.BreakIterator;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.LabelView;
import javax.swing.text.Segment;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;

public class InlineView
extends LabelView {
    AttributeSet attr;
    static Segment buff = new Segment();

    public InlineView(Element element) {
        super(element);
        StyleSheet styleSheet = this.getStyleSheet();
        this.attr = styleSheet.getViewAttributes(this);
    }

    public AttributeSet getAttributes() {
        return this.attr;
    }

    float getLongestWordSpan() {
        float f = 0.0f;
        try {
            Object object;
            Document document = this.getDocument();
            int n = this.getStartOffset();
            int n2 = this.getEndOffset();
            String string = document.getText(n, n2 - n);
            int n3 = n;
            int n4 = n;
            if (string != null && string.length() > 0) {
                object = BreakIterator.getWordInstance();
                ((BreakIterator)object).setText(string);
                int n5 = ((BreakIterator)object).first();
                int n6 = ((BreakIterator)object).next();
                while (n6 != -1) {
                    if (n6 - n5 > n4 - n3) {
                        n3 = n5;
                        n4 = n6;
                    }
                    n5 = n6;
                    n6 = ((BreakIterator)object).next();
                }
            }
            if (n4 - n3 > 0) {
                object = this.getFontMetrics();
                String string2 = string.substring(n3, n4);
                f = ((FontMetrics)object).stringWidth(string2);
            }
        }
        catch (BadLocationException badLocationException) {}
        return f;
    }

    protected StyleSheet getStyleSheet() {
        HTMLDocument hTMLDocument = (HTMLDocument)this.getDocument();
        return hTMLDocument.getStyleSheet();
    }

    public boolean isVisible() {
        int n = this.getStartOffset();
        int n2 = this.getEndOffset();
        if (n2 - n == 1) {
            Document document = this.getDocument();
            try {
                document.getText(n, n2 - n, buff);
                if (Character.isWhitespace(InlineView.buff.array[InlineView.buff.offset])) {
                    return false;
                }
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
        }
        return true;
    }

    protected void setPropertiesFromAttributes() {
        super.setPropertiesFromAttributes();
        AttributeSet attributeSet = this.getAttributes();
        String string = (String)attributeSet.getAttribute(CSS.Attribute.TEXT_DECORATION);
        boolean bl = string != null ? string.indexOf("underline") >= 0 : false;
        this.setUnderline(bl);
        boolean bl2 = string != null ? string.indexOf("line-through") >= 0 : false;
        this.setStrikeThrough(bl2);
        String string2 = (String)attributeSet.getAttribute(CSS.Attribute.VERTICAL_ALIGN);
        bl2 = string2 != null ? string2.indexOf("sup") >= 0 : false;
        this.setSuperscript(bl2);
        bl2 = string2 != null ? string2.indexOf("sub") >= 0 : false;
        this.setSubscript(bl2);
    }
}

