/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.SizeRequirements;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.CompositeView;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class BoxView
extends CompositeView {
    int axis;
    int width;
    int height;
    boolean xValid;
    boolean yValid;
    SizeRequirements xRequest;
    SizeRequirements yRequest;
    boolean xAllocValid;
    int[] xOffsets;
    int[] xSpans;
    boolean yAllocValid;
    int[] yOffsets;
    int[] ySpans;

    public BoxView(Element element, int n) {
        super(element);
        this.axis = n;
    }

    protected void baselineLayout(int n, int n2, int[] nArray, int[] nArray2) {
        int n3 = (int)((float)n * this.getAlignment(n2));
        int n4 = n - n3;
        int n5 = this.getViewCount();
        int n6 = 0;
        while (n6 < n5) {
            View view = this.getView(n6);
            float f = view.getAlignment(n2);
            int n7 = (int)view.getPreferredSpan(n2);
            int n8 = (int)((float)n7 * f);
            int n9 = n7 - n8;
            if (n7 > n) {
                if ((int)view.getMinimumSpan(n2) < n7) {
                    n8 = n3;
                    n9 = n4;
                } else if (view.getResizeWeight(n2) > 0 && view.getMaximumSpan(n2) != (float)n7) {
                    throw new Error("should not happen: " + view.getClass());
                }
            } else if (n7 < n && (int)view.getMaximumSpan(n2) > n7) {
                n8 = n3;
                n9 = n4;
            }
            nArray[n6] = n3 - n8;
            nArray2[n6] = n8 + n9;
            ++n6;
        }
    }

    protected SizeRequirements baselineRequirements(int n, SizeRequirements sizeRequirements) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.getViewCount();
        int n6 = 0;
        while (n6 < n5) {
            View view = this.getView(n6);
            int n7 = (int)view.getPreferredSpan(n);
            int n8 = (int)(view.getAlignment(n) * (float)n7);
            int n9 = n7 - n8;
            n2 = Math.max(n9, n2);
            n3 = Math.max(n8, n3);
            n4 += view.getResizeWeight(n);
            ++n6;
        }
        if (sizeRequirements == null) {
            sizeRequirements = new SizeRequirements();
        }
        sizeRequirements.preferred = n2 + n3;
        if (n4 != 0) {
            sizeRequirements.maximum = Integer.MAX_VALUE;
            sizeRequirements.minimum = 0;
        } else {
            sizeRequirements.maximum = sizeRequirements.preferred;
            sizeRequirements.minimum = sizeRequirements.preferred;
        }
        sizeRequirements.alignment = sizeRequirements.preferred > 0 ? (float)n3 / (float)sizeRequirements.preferred : 0.5f;
        return sizeRequirements;
    }

    protected SizeRequirements calculateMajorAxisRequirements(int n, SizeRequirements sizeRequirements) {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        int n2 = this.getViewCount();
        int n3 = 0;
        while (n3 < n2) {
            View view = this.getView(n3);
            f += view.getMinimumSpan(n);
            f2 += view.getPreferredSpan(n);
            f3 += view.getMaximumSpan(n);
            ++n3;
        }
        if (sizeRequirements == null) {
            sizeRequirements = new SizeRequirements();
        }
        sizeRequirements.alignment = 0.5f;
        sizeRequirements.minimum = (int)f;
        sizeRequirements.preferred = (int)f2;
        sizeRequirements.maximum = (int)f3;
        return sizeRequirements;
    }

    protected SizeRequirements calculateMinorAxisRequirements(int n, SizeRequirements sizeRequirements) {
        int n2 = 0;
        long l = 0L;
        int n3 = Integer.MAX_VALUE;
        int n4 = this.getViewCount();
        int n5 = 0;
        while (n5 < n4) {
            View view = this.getView(n5);
            n2 = Math.max((int)view.getMinimumSpan(n), n2);
            l = Math.max((long)((int)view.getPreferredSpan(n)), l);
            n3 = Math.max((int)view.getMaximumSpan(n), n3);
            ++n5;
        }
        if (sizeRequirements == null) {
            sizeRequirements = new SizeRequirements();
            sizeRequirements.alignment = 0.5f;
        }
        sizeRequirements.preferred = (int)l;
        sizeRequirements.minimum = n2;
        sizeRequirements.maximum = n3;
        return sizeRequirements;
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        Object object;
        Object object2;
        Element element = this.getElement();
        Rectangle rectangle = shape != null && this.isAllocationValid() ? this.getInsideAllocation(shape) : null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (rectangle != null) {
            n = rectangle.x;
            n2 = rectangle.y;
            n3 = rectangle.width;
            n4 = rectangle.height;
        }
        int n5 = element.getElementIndex(documentEvent.getOffset());
        int n6 = element.getElementIndex(documentEvent.getOffset() + Math.max(documentEvent.getLength() - 1, 0));
        int n7 = n5;
        while (n7 <= n6) {
            object2 = this.getView(n7);
            if (rectangle != null) {
                rectangle.x = n + this.xOffsets[n7];
                rectangle.y = n2 + this.yOffsets[n7];
                rectangle.width = this.xSpans[n7];
                rectangle.height = this.ySpans[n7];
            }
            ((View)object2).changedUpdate(documentEvent, rectangle, viewFactory);
            ++n7;
        }
        object2 = documentEvent.getChange(element);
        if (object2 != null) {
            object = object2.getChildrenRemoved();
            Element[] elementArray = object2.getChildrenAdded();
            View[] viewArray = new View[elementArray.length];
            int n8 = 0;
            while (n8 < elementArray.length) {
                viewArray[n8] = viewFactory.create(elementArray[n8]);
                ++n8;
            }
            this.replace(object2.getIndex(), ((Object)object).length, viewArray);
        }
        if (shape != null && !this.isAllocationValid()) {
            object = this.getContainer();
            ((Component)object).repaint(n, n2, n3, n4);
        }
    }

    void checkRequests() {
        if (this.axis == 0) {
            if (!this.xValid) {
                this.xRequest = this.calculateMajorAxisRequirements(0, this.xRequest);
            }
            if (!this.yValid) {
                this.yRequest = this.calculateMinorAxisRequirements(1, this.yRequest);
            }
        } else {
            if (!this.xValid) {
                this.xRequest = this.calculateMinorAxisRequirements(0, this.xRequest);
            }
            if (!this.yValid) {
                this.yRequest = this.calculateMajorAxisRequirements(1, this.yRequest);
            }
        }
        this.yValid = true;
        this.xValid = true;
    }

    protected void childAllocation(int n, Rectangle rectangle) {
        rectangle.x += this.xOffsets[n];
        rectangle.y += this.yOffsets[n];
        rectangle.width = this.xSpans[n];
        rectangle.height = this.ySpans[n];
    }

    protected boolean flipEastAndWestAtEnds(int n, Position.Bias bias) {
        View view;
        int n2;
        int n3;
        if (this.axis == 1 && (n3 = this.getViewIndexAtPosition(n2 = bias == Position.Bias.Backward ? Math.max(0, n - 1) : n)) != -1 && (view = this.getView(n3)) != null && view instanceof CompositeView) {
            return ((CompositeView)view).flipEastAndWestAtEnds(n, bias);
        }
        return false;
    }

    public float getAlignment(int n) {
        this.checkRequests();
        switch (n) {
            case 0: {
                return this.xRequest.alignment;
            }
            case 1: {
                return this.yRequest.alignment;
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + n);
    }

    SizeRequirements[] getChildRequests(int n) {
        int n2 = this.getViewCount();
        SizeRequirements[] sizeRequirementsArray = new SizeRequirements[n2];
        int n3 = 0;
        while (n3 < n2) {
            View view = this.getView(n3);
            int n4 = (int)view.getMinimumSpan(n);
            int n5 = (int)view.getPreferredSpan(n);
            int n6 = (int)view.getMaximumSpan(n);
            float f = view.getAlignment(n);
            sizeRequirementsArray[n3] = new SizeRequirements(n4, n5, n6, f);
            ++n3;
        }
        return sizeRequirementsArray;
    }

    public final int getHeight() {
        return this.height;
    }

    public float getMaximumSpan(int n) {
        this.checkRequests();
        switch (n) {
            case 0: {
                return (float)this.xRequest.maximum + (float)this.getLeftInset() + (float)this.getRightInset();
            }
            case 1: {
                return (float)this.yRequest.maximum + (float)this.getTopInset() + (float)this.getBottomInset();
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + n);
    }

    public float getMinimumSpan(int n) {
        this.checkRequests();
        switch (n) {
            case 0: {
                return (float)this.xRequest.minimum + (float)this.getLeftInset() + (float)this.getRightInset();
            }
            case 1: {
                return (float)this.yRequest.minimum + (float)this.getTopInset() + (float)this.getBottomInset();
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + n);
    }

    protected final int getOffset(int n, int n2) {
        int[] nArray = n == 0 ? this.xOffsets : this.yOffsets;
        return nArray[n2];
    }

    public float getPreferredSpan(int n) {
        this.checkRequests();
        switch (n) {
            case 0: {
                return (float)this.xRequest.preferred + (float)this.getLeftInset() + (float)this.getRightInset();
            }
            case 1: {
                return (float)this.yRequest.preferred + (float)this.getTopInset() + (float)this.getBottomInset();
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + n);
    }

    public int getResizeWeight(int n) {
        this.checkRequests();
        switch (n) {
            case 0: {
                if (this.xRequest.preferred != this.xRequest.minimum && this.xRequest.preferred != this.xRequest.maximum) {
                    return 1;
                }
                return 0;
            }
            case 1: {
                if (this.yRequest.preferred != this.yRequest.minimum && this.yRequest.preferred != this.yRequest.maximum) {
                    return 1;
                }
                return 0;
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + n);
    }

    protected final int getSpan(int n, int n2) {
        int[] nArray = n == 0 ? this.xSpans : this.ySpans;
        return nArray[n2];
    }

    protected View getViewAtPoint(int n, int n2, Rectangle rectangle) {
        int n3 = this.getViewCount();
        if (this.axis == 0) {
            if (n < rectangle.x + this.xOffsets[0]) {
                this.childAllocation(0, rectangle);
                return this.getView(0);
            }
            int n4 = 0;
            while (n4 < n3) {
                if (n < rectangle.x + this.xOffsets[n4]) {
                    this.childAllocation(n4 - 1, rectangle);
                    return this.getView(n4 - 1);
                }
                ++n4;
            }
            this.childAllocation(n3 - 1, rectangle);
            return this.getView(n3 - 1);
        }
        if (n2 < rectangle.y + this.yOffsets[0]) {
            this.childAllocation(0, rectangle);
            return this.getView(0);
        }
        int n5 = 0;
        while (n5 < n3) {
            if (n2 < rectangle.y + this.yOffsets[n5]) {
                this.childAllocation(n5 - 1, rectangle);
                return this.getView(n5 - 1);
            }
            ++n5;
        }
        this.childAllocation(n3 - 1, rectangle);
        return this.getView(n3 - 1);
    }

    public final int getWidth() {
        return this.width;
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        Object object;
        Element[] elementArray;
        Element element = this.getElement();
        DocumentEvent.ElementChange elementChange = documentEvent.getChange(element);
        boolean bl = true;
        if (elementChange != null) {
            elementArray = elementChange.getChildrenRemoved();
            Element[] elementArray2 = elementChange.getChildrenAdded();
            object = new View[elementArray2.length];
            int n = 0;
            while (n < elementArray2.length) {
                object[n] = viewFactory.create(elementArray2[n]);
                ++n;
            }
            int n2 = elementChange.getIndex();
            this.replace(n2, elementArray.length, (View[])object);
            if (((Object)object).length > 0) {
                View view;
                int n3;
                View view2;
                Element element2;
                int n4 = documentEvent.getOffset();
                if (n2 > 0 && (element2 = element.getElement(n2 - 1)).getEndOffset() >= n4 && (view2 = this.getViewAtPosition(element2.getStartOffset(), null)) != null) {
                    view2.insertUpdate(documentEvent, null, viewFactory);
                }
                if (n2 + ((Object)object).length < this.getViewCount() && (n3 = (element2 = element.getElement(n2 + ((Object)object).length)).getStartOffset()) >= n4 && n3 <= n4 + documentEvent.getLength() && (view = this.getViewAtPosition(element2.getStartOffset(), null)) != null) {
                    view.insertUpdate(documentEvent, null, viewFactory);
                }
                bl = false;
            }
            if (shape != null) {
                this.preferenceChanged(null, true, true);
                this.getContainer().repaint();
            }
        }
        if (bl) {
            elementArray = shape != null && this.isAllocationValid() ? this.getInsideAllocation(shape) : null;
            int n = documentEvent.getOffset();
            object = this.getViewAtPosition(n, (Rectangle)elementArray);
            if (object != null) {
                Rectangle rectangle;
                View view;
                if (((View)object).getStartOffset() == n && n > 0 && (view = this.getViewAtPosition(n - 1, rectangle = shape != null && this.isAllocationValid() ? this.getInsideAllocation(shape) : null)) != object && view != null) {
                    view.insertUpdate(documentEvent, rectangle, viewFactory);
                }
                ((View)object).insertUpdate(documentEvent, (Shape)elementArray, viewFactory);
            }
        }
    }

    protected boolean isAfter(int n, int n2, Rectangle rectangle) {
        if (this.axis == 0) {
            return n > rectangle.width + rectangle.x;
        }
        return n2 > rectangle.height + rectangle.y;
    }

    protected boolean isAllocationValid() {
        return this.xAllocValid && this.yAllocValid;
    }

    protected boolean isBefore(int n, int n2, Rectangle rectangle) {
        if (this.axis == 0) {
            return n < rectangle.x;
        }
        return n2 < rectangle.y;
    }

    protected void layout(int n, int n2) {
        int n3;
        this.checkRequests();
        if (this.xSpans == null) {
            n3 = this.getViewCount();
            this.xSpans = new int[n3];
            this.ySpans = new int[n3];
            this.xOffsets = new int[n3];
            this.yOffsets = new int[n3];
        }
        if (this.axis == 0) {
            if (!this.xAllocValid) {
                this.layoutMajorAxis(n, 0, this.xOffsets, this.xSpans);
            }
            if (!this.yAllocValid) {
                this.layoutMinorAxis(n2, 1, this.yOffsets, this.ySpans);
            }
        } else {
            if (!this.xAllocValid) {
                this.layoutMinorAxis(n, 0, this.xOffsets, this.xSpans);
            }
            if (!this.yAllocValid) {
                this.layoutMajorAxis(n2, 1, this.yOffsets, this.ySpans);
            }
        }
        this.xAllocValid = true;
        this.yAllocValid = true;
        n3 = this.getViewCount();
        int n4 = 0;
        while (n4 < n3) {
            View view = this.getView(n4);
            view.setSize(this.xSpans[n4], this.ySpans[n4]);
            ++n4;
        }
    }

    protected void layoutMajorAxis(int n, int n2, int[] nArray, int[] nArray2) {
        SizeRequirements.calculateTiledPositions(n, null, this.getChildRequests(n2), nArray, nArray2);
    }

    protected void layoutMinorAxis(int n, int n2, int[] nArray, int[] nArray2) {
        int n3 = this.getViewCount();
        int n4 = 0;
        while (n4 < n3) {
            View view = this.getView(n4);
            int n5 = (int)view.getMinimumSpan(n2);
            int n6 = (int)view.getMaximumSpan(n2);
            if (n6 < n) {
                float f = view.getAlignment(n2);
                nArray[n4] = (int)((float)(n - n6) * f);
                nArray2[n4] = n6;
            } else {
                nArray[n4] = 0;
                nArray2[n4] = Math.max(n5, n);
            }
            ++n4;
        }
    }

    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        if (!this.isAllocationValid()) {
            Rectangle rectangle = shape.getBounds();
            this.setSize(rectangle.width, rectangle.height);
        }
        return super.modelToView(n, shape, bias);
    }

    public void paint(Graphics graphics, Shape shape) {
        Rectangle rectangle = shape.getBounds();
        this.setSize(rectangle.width, rectangle.height);
        int n = this.getViewCount();
        int n2 = rectangle.x + this.getLeftInset();
        int n3 = rectangle.y + this.getTopInset();
        Rectangle rectangle2 = graphics.getClipBounds();
        int n4 = 0;
        while (n4 < n) {
            rectangle.x = n2 + this.xOffsets[n4];
            rectangle.y = n3 + this.yOffsets[n4];
            rectangle.width = this.xSpans[n4];
            rectangle.height = this.ySpans[n4];
            if (rectangle.intersects(rectangle2)) {
                this.paintChild(graphics, rectangle, n4);
            }
            ++n4;
        }
    }

    protected void paintChild(Graphics graphics, Rectangle rectangle, int n) {
        View view = this.getView(n);
        view.paint(graphics, rectangle);
    }

    public void preferenceChanged(View view, boolean bl, boolean bl2) {
        if (bl) {
            this.xValid = false;
            this.xAllocValid = false;
        }
        if (bl2) {
            this.yValid = false;
            this.yAllocValid = false;
        }
        super.preferenceChanged(view, bl, bl2);
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        Object object;
        Element[] elementArray;
        Element element = this.getElement();
        DocumentEvent.ElementChange elementChange = documentEvent.getChange(element);
        boolean bl = true;
        if (elementChange != null) {
            elementArray = elementChange.getChildrenRemoved();
            Element[] elementArray2 = elementChange.getChildrenAdded();
            object = new View[elementArray2.length];
            int n = 0;
            while (n < elementArray2.length) {
                object[n] = viewFactory.create(elementArray2[n]);
                ++n;
            }
            this.replace(elementChange.getIndex(), elementArray.length, (View[])object);
            if (((Object)object).length != 0) {
                bl = false;
            }
            if (shape != null) {
                this.preferenceChanged(null, true, true);
                this.getContainer().repaint();
            }
        }
        if (bl) {
            elementArray = shape != null && this.isAllocationValid() ? this.getInsideAllocation(shape) : null;
            int n = documentEvent.getOffset();
            object = this.getViewAtPosition(n, (Rectangle)elementArray);
            if (object != null) {
                Rectangle rectangle;
                View view;
                if (((View)object).getStartOffset() == n && n > 0 && (view = this.getViewAtPosition(n - 1, rectangle = shape != null && this.isAllocationValid() ? this.getInsideAllocation(shape) : null)) != object && view != null) {
                    view.removeUpdate(documentEvent, rectangle, viewFactory);
                }
                ((View)object).removeUpdate(documentEvent, (Shape)elementArray, viewFactory);
            }
        }
    }

    public void replace(int n, int n2, View[] viewArray) {
        super.replace(n, n2, viewArray);
        this.xOffsets = null;
        this.xSpans = null;
        this.xValid = false;
        this.xAllocValid = false;
        this.yOffsets = null;
        this.ySpans = null;
        this.yValid = false;
        this.yAllocValid = false;
    }

    public void setSize(float f, float f2) {
        if ((int)f != this.width) {
            this.xAllocValid = false;
        }
        if ((int)f2 != this.height) {
            this.yAllocValid = false;
        }
        if (!this.xAllocValid || !this.yAllocValid) {
            this.width = (int)f;
            this.height = (int)f2;
            this.layout(this.width - this.getLeftInset() - this.getRightInset(), this.height - this.getTopInset() - this.getBottomInset());
        }
    }

    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        if (!this.isAllocationValid()) {
            Rectangle rectangle = shape.getBounds();
            this.setSize(rectangle.width, rectangle.height);
        }
        return super.viewToModel(f, f2, shape, biasArray);
    }
}

