/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TableUI;
import javax.swing.plaf.UIResource;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.Keymap;

public class BasicTableUI
extends TableUI {
    protected JTable table;
    protected CellRendererPane rendererPane;
    protected KeyListener keyListener;
    protected FocusListener focusListener;
    protected MouseInputListener mouseInputListener;

    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    protected KeyListener createKeyListener() {
        return new KeyHandler();
    }

    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler();
    }

    private Dimension createTableSize(long l) {
        int n = this.table.getRowCount() * (this.table.getRowHeight() + this.table.getRowMargin());
        int n2 = this.table.getColumnModel().getColumnMargin() * this.table.getColumnCount();
        long l2 = Math.abs(l) + (long)n2;
        if (l2 > Integer.MAX_VALUE) {
            l2 = Integer.MAX_VALUE;
        }
        return new Dimension((int)l2, n);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicTableUI();
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        long l = 0L;
        Enumeration enumeration = this.table.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = (TableColumn)enumeration.nextElement();
            l += (long)tableColumn.getMaxWidth();
        }
        return this.createTableSize(l);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        long l = 0L;
        Enumeration enumeration = this.table.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = (TableColumn)enumeration.nextElement();
            l += (long)tableColumn.getMinWidth();
        }
        return this.createTableSize(l);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        long l = 0L;
        Enumeration enumeration = this.table.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = (TableColumn)enumeration.nextElement();
            l += (long)tableColumn.getPreferredWidth();
        }
        return this.createTableSize(l);
    }

    protected void installDefaults() {
        Container container;
        Color color;
        Color color2;
        LookAndFeel.installColorsAndFont(this.table, "Table.background", "Table.foreground", "Table.font");
        Color color3 = this.table.getSelectionBackground();
        if (color3 == null || color3 instanceof UIResource) {
            this.table.setSelectionBackground(UIManager.getColor("Table.selectionBackground"));
        }
        if ((color2 = this.table.getSelectionForeground()) == null || color2 instanceof UIResource) {
            this.table.setSelectionForeground(UIManager.getColor("Table.selectionForeground"));
        }
        if ((color = this.table.getGridColor()) == null || color instanceof UIResource) {
            this.table.setGridColor(UIManager.getColor("Table.gridColor"));
        }
        if ((container = this.table.getParent()) != null && (container = container.getParent()) != null && container instanceof JScrollPane) {
            LookAndFeel.installBorder((JScrollPane)container, "Table.scrollPaneBorder");
        }
    }

    protected void installKeyboardActions() {
        int n = 1;
        int n2 = 2;
        this.registerKey(39, 0, 1, 0);
        this.registerKey(37, 0, -1, 0);
        this.registerKey(40, 0, 0, 1);
        this.registerKey(38, 0, 0, -1);
        this.registerKey(39, n, 1, 0);
        this.registerKey(37, n, -1, 0);
        this.registerKey(40, n, 0, 1);
        this.registerKey(38, n, 0, -1);
        this.registerKey(9, 0, 1, 0, true, false, true, true);
        this.registerKey(9, n, -1, 0, true, false, true, true);
        this.registerKey(10, 0, 0, 1, true, false, true, true);
        this.registerKey(10, n, 0, -1, true, false, true, true);
        this.table.registerKeyboardAction(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                BasicTableUI.this.table.selectAll();
            }
        }, KeyStroke.getKeyStroke(65, n2), 0);
        this.table.registerKeyboardAction(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                BasicTableUI.this.table.removeEditor();
            }
        }, KeyStroke.getKeyStroke(27, 0), 0);
    }

    protected void installListeners() {
        this.focusListener = this.createFocusListener();
        this.keyListener = this.createKeyListener();
        this.mouseInputListener = this.createMouseInputListener();
        this.table.addFocusListener(this.focusListener);
        this.table.addKeyListener(this.keyListener);
        this.table.addMouseListener(this.mouseInputListener);
        this.table.addMouseMotionListener(this.mouseInputListener);
    }

    public void installUI(JComponent jComponent) {
        this.table = (JTable)jComponent;
        this.rendererPane = new CellRendererPane();
        this.table.add(this.rendererPane);
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    private int lastVisibleRow(Rectangle rectangle) {
        int n = this.table.rowAtPoint(new Point(0, rectangle.y + rectangle.height - 1));
        if (n == -1) {
            n = this.table.getRowCount() - 1;
        }
        return n;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Rectangle rectangle = graphics.getClipBounds();
        Rectangle rectangle2 = new Rectangle(rectangle);
        int n = this.table.getColumnModel().getTotalColumnWidth();
        rectangle2.width = Math.min(rectangle2.width, n);
        graphics.setClip(rectangle2);
        this.paintGrid(graphics);
        int n2 = this.table.rowAtPoint(new Point(0, rectangle2.y));
        int n3 = this.lastVisibleRow(rectangle2);
        Rectangle rectangle3 = new Rectangle(0, 0, n, this.table.getRowHeight() + this.table.getRowMargin());
        rectangle3.y = n2 * rectangle3.height;
        int n4 = n2;
        while (n4 <= n3) {
            if (rectangle3.intersects(rectangle2)) {
                this.paintRow(graphics, n4);
            }
            rectangle3.y += rectangle3.height;
            ++n4;
        }
        graphics.setClip(rectangle);
    }

    private void paintCell(Graphics graphics, Rectangle rectangle, int n, int n2) {
        int n3 = this.table.getRowMargin();
        int n4 = this.table.getColumnModel().getColumnMargin();
        rectangle.setBounds(rectangle.x + n4 / 2, rectangle.y + n3 / 2, rectangle.width - n4, rectangle.height - n3);
        if (this.table.isEditing() && this.table.getEditingRow() == n && this.table.getEditingColumn() == n2) {
            Component component = this.table.getEditorComponent();
            component.setBounds(rectangle);
            component.validate();
        } else {
            TableCellRenderer tableCellRenderer = this.table.getCellRenderer(n, n2);
            Component component = this.table.prepareRenderer(tableCellRenderer, n, n2);
            if (component.getParent() == null) {
                this.rendererPane.add(component);
            }
            this.rendererPane.paintComponent(graphics, component, this.table, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
        }
        rectangle.setBounds(rectangle.x - n4 / 2, rectangle.y - n3 / 2, rectangle.width + n4, rectangle.height + n3);
    }

    private void paintGrid(Graphics graphics) {
        graphics.setColor(this.table.getGridColor());
        if (this.table.getShowHorizontalLines()) {
            this.paintHorizontalLines(graphics);
        }
        if (this.table.getShowVerticalLines()) {
            this.paintVerticalLines(graphics);
        }
    }

    private void paintHorizontalLines(Graphics graphics) {
        Rectangle rectangle;
        Rectangle rectangle2 = rectangle = graphics.getClipBounds();
        int n = this.table.getRowHeight() + this.table.getRowMargin();
        int n2 = this.table.rowAtPoint(new Point(0, rectangle.y));
        int n3 = this.lastVisibleRow(rectangle);
        int n4 = n * n2 + (n - 1);
        int n5 = n2;
        while (n5 <= n3) {
            if (n4 >= rectangle2.y && n4 <= rectangle2.y + rectangle2.height) {
                graphics.drawLine(rectangle2.x, n4, rectangle2.x + rectangle2.width - 1, n4);
            }
            n4 += n;
            ++n5;
        }
    }

    private void paintRow(Graphics graphics, int n) {
        Rectangle rectangle = graphics.getClipBounds();
        int n2 = 0;
        boolean bl = false;
        int n3 = -1;
        Rectangle rectangle2 = null;
        Dimension dimension = this.table.getIntercellSpacing();
        JTableHeader jTableHeader = this.table.getTableHeader();
        Rectangle rectangle3 = new Rectangle();
        rectangle3.height = this.table.getRowHeight() + dimension.height;
        rectangle3.y = n * rectangle3.height;
        Enumeration enumeration = this.table.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = (TableColumn)enumeration.nextElement();
            rectangle3.width = tableColumn.getWidth() + dimension.width;
            if (rectangle3.intersects(rectangle)) {
                bl = true;
                if (jTableHeader == null || tableColumn != jTableHeader.getDraggedColumn()) {
                    this.paintCell(graphics, rectangle3, n, n2);
                } else {
                    graphics.setColor(this.table.getParent().getBackground());
                    graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                    rectangle2 = new Rectangle(rectangle3);
                    n3 = n2;
                }
            } else if (bl) break;
            rectangle3.x += rectangle3.width;
            ++n2;
        }
        if (n3 != -1 && rectangle2 != null) {
            rectangle2.x += jTableHeader.getDraggedDistance();
            graphics.setColor(this.table.getBackground());
            graphics.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            graphics.setColor(this.table.getGridColor());
            int n4 = rectangle2.x;
            int n5 = rectangle2.y;
            int n6 = n4 + rectangle2.width - 1;
            int n7 = n5 + rectangle2.height - 1;
            if (this.table.getShowVerticalLines()) {
                graphics.drawLine(n6, n5, n6, n7);
            }
            if (this.table.getShowHorizontalLines()) {
                graphics.drawLine(n4, n7, n6, n7);
            }
            this.paintCell(graphics, rectangle2, n, n3);
        }
    }

    private void paintVerticalLines(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        int n = 0;
        int n2 = this.table.getColumnCount();
        int n3 = this.table.getIntercellSpacing().width;
        int n4 = 0;
        while (n4 <= n2) {
            if (n > 0 && n - 1 >= rectangle.x && n - 1 <= rectangle.x + rectangle.width) {
                graphics.drawLine(n - 1, rectangle.y, n - 1, rectangle.y + rectangle.height - 1);
            }
            if (n4 < n2) {
                n += this.table.getColumnModel().getColumn(n4).getWidth() + n3;
            }
            ++n4;
        }
    }

    private void registerKey(int n, int n2, int n3, int n4) {
        boolean bl = (n2 & 2) != 0;
        boolean bl2 = (n2 & 1) != 0;
        boolean bl3 = bl2 ^ true;
        this.registerKey(n, n2, n3, n4, bl, bl2, bl3, false);
    }

    private void registerKey(int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        class Javax_swing_plaf_basic_BasicTableUI$3 {
            /* synthetic */ Javax_swing_plaf_basic_BasicTableUI$3() {
            }
        }
        this.table.registerKeyboardAction(new NavigationalAction(null, n3, n4, bl, bl2, bl3, bl4), KeyStroke.getKeyStroke(n, n2), 0);
    }

    protected void uninstallDefaults() {
    }

    protected void uninstallKeyboardActions() {
        int n = 1;
        int n2 = 2;
        this.table.unregisterKeyboardAction(KeyStroke.getKeyStroke(38, 0));
        this.table.unregisterKeyboardAction(KeyStroke.getKeyStroke(40, 0));
        this.table.unregisterKeyboardAction(KeyStroke.getKeyStroke(39, 0));
        this.table.unregisterKeyboardAction(KeyStroke.getKeyStroke(37, 0));
        this.table.unregisterKeyboardAction(KeyStroke.getKeyStroke(38, n));
        this.table.unregisterKeyboardAction(KeyStroke.getKeyStroke(40, n));
        this.table.unregisterKeyboardAction(KeyStroke.getKeyStroke(39, n));
        this.table.unregisterKeyboardAction(KeyStroke.getKeyStroke(37, n));
        this.table.unregisterKeyboardAction(KeyStroke.getKeyStroke(9, 0));
        this.table.unregisterKeyboardAction(KeyStroke.getKeyStroke(9, n));
        this.table.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
        this.table.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, n));
        this.table.unregisterKeyboardAction(KeyStroke.getKeyStroke(65, n2));
        this.table.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0));
    }

    protected void uninstallListeners() {
        this.table.removeFocusListener(this.focusListener);
        this.table.removeKeyListener(this.keyListener);
        this.table.removeMouseListener(this.mouseInputListener);
        this.table.removeMouseMotionListener(this.mouseInputListener);
        this.focusListener = null;
        this.keyListener = null;
        this.mouseInputListener = null;
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.table.remove(this.rendererPane);
        this.rendererPane = null;
        this.table = null;
    }

    private void updateSelection(int n, int n2, boolean bl, boolean bl2) {
        Rectangle rectangle = this.table.getCellRect(n, n2, false);
        if (rectangle != null) {
            this.table.scrollRectToVisible(rectangle);
        }
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        ListSelectionModel listSelectionModel2 = this.table.getColumnModel().getSelectionModel();
        this.updateSelectionModel(listSelectionModel2, n2, bl, bl2);
        this.updateSelectionModel(listSelectionModel, n, bl, bl2);
    }

    private void updateSelectionModel(ListSelectionModel listSelectionModel, int n, boolean bl, boolean bl2) {
        if (!bl2) {
            if (!bl) {
                listSelectionModel.setSelectionInterval(n, n);
            } else if (listSelectionModel.isSelectedIndex(n)) {
                listSelectionModel.removeSelectionInterval(n, n);
            } else {
                listSelectionModel.addSelectionInterval(n, n);
            }
        } else {
            listSelectionModel.setLeadSelectionIndex(n);
        }
    }

    private class NavigationalAction
    extends AbstractAction {
        private int dx;
        private int dy;
        private boolean toggle;
        private boolean extend;
        private boolean moveAnchor;
        private boolean inSelection;
        private int anchorRow;
        private int anchorColumn;
        private int leadRow;
        private int leadColumn;

        private NavigationalAction(int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            this.dx = n;
            this.dy = n2;
            this.toggle = bl;
            this.extend = bl2;
            this.moveAnchor = bl3;
            this.inSelection = bl4;
        }

        /* synthetic */ NavigationalAction(3 var2_2, int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            this(n, n2, bl, bl2, bl3, bl4);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl;
            ListSelectionModel listSelectionModel = BasicTableUI.this.table.getSelectionModel();
            this.anchorRow = listSelectionModel.getAnchorSelectionIndex();
            this.leadRow = listSelectionModel.getLeadSelectionIndex();
            ListSelectionModel listSelectionModel2 = BasicTableUI.this.table.getColumnModel().getSelectionModel();
            this.anchorColumn = listSelectionModel2.getAnchorSelectionIndex();
            this.leadColumn = listSelectionModel2.getLeadSelectionIndex();
            int n = this.anchorRow;
            int n2 = this.anchorColumn;
            boolean bl2 = bl = this.selectionSpan(listSelectionModel) * this.selectionSpan(listSelectionModel2) == 1;
            if (!this.inSelection || bl) {
                if (this.moveAnchor) {
                    this.anchorRow += this.dy;
                    this.anchorColumn += this.dx;
                    if (this.inTableRange(this.anchorRow, this.anchorColumn)) {
                        BasicTableUI.this.updateSelection(this.anchorRow, this.anchorColumn, false, this.extend);
                    }
                } else {
                    this.leadRow += this.dy;
                    this.leadColumn += this.dx;
                    if (this.inTableRange(this.leadRow, this.leadColumn)) {
                        BasicTableUI.this.updateSelection(this.leadRow, this.leadColumn, false, this.extend);
                    }
                }
            } else {
                this.anchorRow += this.dy;
                this.anchorColumn += this.dx;
                this.limitToSelectedRange(false);
                listSelectionModel.setAnchorSelectionIndex(this.anchorRow);
                listSelectionModel2.setAnchorSelectionIndex(this.anchorColumn);
            }
            if (BasicTableUI.this.table.isEditing() && (n != listSelectionModel.getAnchorSelectionIndex() || n2 != listSelectionModel2.getAnchorSelectionIndex())) {
                BasicTableUI.this.table.getCellEditor().stopCellEditing();
            }
        }

        private boolean inRange(int n, int n2, int n3) {
            return n >= n2 && n < n3;
        }

        private boolean inTableRange(int n, int n2) {
            return this.inRange(n, 0, BasicTableUI.this.table.getRowCount()) && this.inRange(n2, 0, BasicTableUI.this.table.getColumnCount());
        }

        private int indexSign(int n, ListSelectionModel listSelectionModel) {
            if (n < listSelectionModel.getMinSelectionIndex()) {
                return -1;
            }
            if (n > listSelectionModel.getMaxSelectionIndex()) {
                return 1;
            }
            return 0;
        }

        private void limitToSelectedRange(boolean bl) {
            ListSelectionModel listSelectionModel = BasicTableUI.this.table.getSelectionModel();
            ListSelectionModel listSelectionModel2 = BasicTableUI.this.table.getColumnModel().getSelectionModel();
            int n = this.indexSign(this.anchorRow, listSelectionModel);
            int n2 = this.indexSign(this.anchorColumn, listSelectionModel2);
            this.anchorRow -= this.selectionSpan(listSelectionModel) * n;
            this.anchorColumn -= this.selectionSpan(listSelectionModel2) * n2;
            if (!bl) {
                this.anchorRow += n2;
                this.anchorColumn += n;
                this.limitToSelectedRange(true);
            }
        }

        private int selectionSpan(ListSelectionModel listSelectionModel) {
            return listSelectionModel.getMaxSelectionIndex() - listSelectionModel.getMinSelectionIndex() + 1;
        }
    }

    public class KeyHandler
    implements KeyListener {
        public void keyPressed(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
            if (keyEvent.getKeyChar() == '\t' || keyEvent.getKeyChar() == '\n') {
                return;
            }
            int n = BasicTableUI.this.table.getSelectedRow();
            int n2 = BasicTableUI.this.table.getSelectedColumn();
            if (n != -1 && n2 != -1 && !BasicTableUI.this.table.isEditing()) {
                boolean bl = BasicTableUI.this.table.editCellAt(n, n2);
                BasicTableUI.this.table.requestFocus();
                if (!bl) {
                    return;
                }
            }
            Component component = BasicTableUI.this.table.getEditorComponent();
            if (BasicTableUI.this.table.isEditing() && component != null) {
                char c = keyEvent.getKeyChar();
                if (component instanceof JTextField) {
                    KeyStroke keyStroke;
                    JTextField jTextField = (JTextField)component;
                    Keymap keymap = jTextField.getKeymap();
                    Action action = keymap.getAction(keyStroke = KeyStroke.getKeyStroke((int)c, 0));
                    if (action == null) {
                        action = keymap.getDefaultAction();
                    }
                    if (action != null) {
                        ActionEvent actionEvent = new ActionEvent(jTextField, 1001, String.valueOf(c));
                        action.actionPerformed(actionEvent);
                        keyEvent.consume();
                    }
                }
            }
        }
    }

    public class FocusHandler
    implements FocusListener {
        public void focusGained(FocusEvent focusEvent) {
            if (BasicTableUI.this.table.getRowCount() <= 0) {
                return;
            }
            if (BasicTableUI.this.table.getSelectedColumn() == -1) {
                BasicTableUI.this.table.setColumnSelectionInterval(0, 0);
            }
            if (BasicTableUI.this.table.getSelectedRow() == -1) {
                BasicTableUI.this.table.setRowSelectionInterval(0, 0);
            }
            this.repaintAnchorCell();
        }

        public void focusLost(FocusEvent focusEvent) {
            this.repaintAnchorCell();
        }

        private void repaintAnchorCell() {
            int n = BasicTableUI.this.table.getSelectedRow();
            int n2 = BasicTableUI.this.table.getSelectedColumn();
            Rectangle rectangle = BasicTableUI.this.table.getCellRect(n, n2, false);
            BasicTableUI.this.table.repaint(rectangle);
        }
    }

    public class MouseInputHandler
    implements MouseInputListener {
        private boolean phantomMousePressed = false;
        private Component dispatchComponent;

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            if (this.repostEvent(mouseEvent)) {
                return;
            }
            Point point = mouseEvent.getPoint();
            int n = BasicTableUI.this.table.rowAtPoint(point);
            int n2 = BasicTableUI.this.table.columnAtPoint(point);
            if (n2 == -1 || n == -1) {
                return;
            }
            BasicTableUI.this.updateSelection(n, n2, false, true);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            this.dispatchComponent = null;
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.dispatchComponent = null;
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            this.dispatchComponent = null;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            boolean bl;
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            if (this.phantomMousePressed) {
                return;
            }
            this.phantomMousePressed = true;
            Point point = mouseEvent.getPoint();
            int n = BasicTableUI.this.table.rowAtPoint(point);
            int n2 = BasicTableUI.this.table.columnAtPoint(point);
            if (n2 == -1 || n == -1) {
                return;
            }
            boolean bl2 = BasicTableUI.this.table.editCellAt(n, n2, mouseEvent);
            boolean bl3 = bl = BasicTableUI.this.table.isEditing() && bl2;
            if (bl) {
                Component component = BasicTableUI.this.table.getEditorComponent();
                Point point2 = SwingUtilities.convertPoint(BasicTableUI.this.table, point, component);
                this.dispatchComponent = SwingUtilities.getDeepestComponentAt(component, point2.x, point2.y);
                this.repostEvent(mouseEvent);
            }
            if (!bl || BasicTableUI.this.table.getCellEditor().shouldSelectCell(mouseEvent)) {
                BasicTableUI.this.table.requestFocus();
                this.setValueIsAdjusting(true);
                BasicTableUI.this.updateSelection(n, n2, mouseEvent.isControlDown(), mouseEvent.isShiftDown());
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            this.phantomMousePressed = false;
            this.repostEvent(mouseEvent);
            this.dispatchComponent = null;
            this.setValueIsAdjusting(false);
        }

        private boolean repostEvent(MouseEvent mouseEvent) {
            if (this.dispatchComponent == null) {
                return false;
            }
            MouseEvent mouseEvent2 = SwingUtilities.convertMouseEvent(BasicTableUI.this.table, mouseEvent, this.dispatchComponent);
            this.dispatchComponent.dispatchEvent(mouseEvent2);
            return true;
        }

        private void setValueIsAdjusting(boolean bl) {
            BasicTableUI.this.table.getSelectionModel().setValueIsAdjusting(bl);
            BasicTableUI.this.table.getColumnModel().getSelectionModel().setValueIsAdjusting(bl);
        }
    }
}

