/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.peer.ComponentPeer;
import java.awt.peer.LightweightPeer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.SplitPaneUI;
import javax.swing.plaf.basic.BasicSplitPaneDivider;

public class BasicSplitPaneUI
extends SplitPaneUI {
    protected static final String NON_CONTINUOUS_DIVIDER = "nonContinuousDivider";
    protected static int KEYBOARD_DIVIDER_MOVE_OFFSET = 3;
    protected JSplitPane splitPane;
    protected BasicHorizontalLayoutManager layoutManager;
    protected BasicSplitPaneDivider divider;
    protected PropertyChangeListener propertyChangeListener;
    protected FocusListener focusListener;
    protected int dividerSize;
    protected Component nonContinuousLayoutDivider;
    protected boolean draggingHW;
    protected int beginDragDividerLocation;
    protected KeyStroke upKey;
    protected KeyStroke downKey;
    protected KeyStroke leftKey;
    protected KeyStroke rightKey;
    protected KeyStroke homeKey;
    protected KeyStroke endKey;
    protected KeyStroke dividerResizeToggleKey;
    protected ActionListener keyboardUpLeftListener;
    protected ActionListener keyboardDownRightListener;
    protected ActionListener keyboardHomeListener;
    protected ActionListener keyboardEndListener;
    protected ActionListener keyboardResizeToggleListener;
    private int orientation;
    private int lastDragLocation;
    private boolean continuousLayout;
    private boolean dividerKeyboardResize;
    private boolean dividerLocationIsSet;

    public BasicSplitPaneDivider createDefaultDivider() {
        return new BasicSplitPaneDivider(this);
    }

    protected Component createDefaultNonContinuousLayoutDivider() {
        return new Canvas(){

            public void paint(Graphics graphics) {
                if (!BasicSplitPaneUI.this.isContinuousLayout() && BasicSplitPaneUI.this.getLastDragLocation() != -1) {
                    Dimension dimension = BasicSplitPaneUI.this.splitPane.getSize();
                    graphics.setColor(Color.darkGray);
                    if (BasicSplitPaneUI.this.orientation == 1) {
                        graphics.fillRect(0, 0, BasicSplitPaneUI.this.dividerSize - 1, dimension.height - 1);
                    } else {
                        graphics.fillRect(0, 0, dimension.width - 1, BasicSplitPaneUI.this.dividerSize - 1);
                    }
                }
            }
        };
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    protected ActionListener createKeyboardDownRightListener() {
        return new KeyboardDownRightHandler();
    }

    protected ActionListener createKeyboardEndListener() {
        return new KeyboardEndHandler();
    }

    protected ActionListener createKeyboardHomeListener() {
        return new KeyboardHomeHandler();
    }

    protected ActionListener createKeyboardResizeToggleListener() {
        return new KeyboardResizeToggleHandler();
    }

    protected ActionListener createKeyboardUpLeftListener() {
        return new KeyboardUpLeftHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyHandler();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicSplitPaneUI();
    }

    protected void dragDividerTo(int n) {
        if (this.getLastDragLocation() != n) {
            if (this.isContinuousLayout()) {
                Component component = this.splitPane.getLeftComponent();
                Rectangle rectangle = component.getBounds();
                if (this.orientation == 1) {
                    component.setSize(n - rectangle.x, rectangle.height);
                } else {
                    component.setSize(rectangle.width, n - rectangle.y);
                }
                this.splitPane.revalidate();
                this.splitPane.repaint();
                this.setLastDragLocation(n);
            } else {
                int n2 = this.getLastDragLocation();
                this.setLastDragLocation(n);
                if (this.orientation == 1) {
                    int n3 = this.splitPane.getSize().height;
                    if (this.draggingHW) {
                        this.nonContinuousLayoutDivider.setLocation(this.getLastDragLocation(), 0);
                    } else {
                        this.splitPane.repaint(n2, 0, this.dividerSize, n3);
                        this.splitPane.repaint(n, 0, this.dividerSize, n3);
                    }
                } else {
                    int n4 = this.splitPane.getSize().width;
                    if (this.draggingHW) {
                        this.nonContinuousLayoutDivider.setLocation(0, this.getLastDragLocation());
                    } else {
                        this.splitPane.repaint(0, n2, n4, this.dividerSize);
                        this.splitPane.repaint(0, n, n4, this.dividerSize);
                    }
                }
            }
        }
    }

    protected void finishDraggingTo(int n) {
        this.dragDividerTo(n);
        this.setLastDragLocation(-1);
        if (!this.isContinuousLayout()) {
            Component component = this.splitPane.getLeftComponent();
            Rectangle rectangle = component.getBounds();
            if (this.orientation == 1) {
                int n2 = this.splitPane.getSize().height;
                component.setSize(n - rectangle.x, rectangle.height);
                if (this.draggingHW) {
                    this.nonContinuousLayoutDivider.setLocation(-this.dividerSize, 0);
                }
                this.splitPane.paintImmediately(n, 0, this.dividerSize, n2);
            } else {
                int n3 = this.splitPane.getSize().width;
                component.setSize(rectangle.width, n - rectangle.y);
                if (this.draggingHW) {
                    this.nonContinuousLayoutDivider.setLocation(0, -this.dividerSize);
                }
                this.splitPane.paintImmediately(0, n, n3, this.dividerSize);
            }
            this.splitPane.revalidate();
            this.splitPane.repaint();
        }
        this.splitPane.setLastDividerLocation(this.beginDragDividerLocation);
    }

    public void finishedPaintingChildren(JSplitPane jSplitPane, Graphics graphics) {
        if (jSplitPane == this.splitPane && this.getLastDragLocation() != -1 && !this.isContinuousLayout() && !this.draggingHW) {
            Dimension dimension = this.splitPane.getSize();
            graphics.setColor(Color.darkGray);
            if (this.orientation == 1) {
                graphics.fillRect(this.getLastDragLocation(), 0, this.dividerSize - 1, dimension.height - 1);
            } else {
                graphics.fillRect(0, this.lastDragLocation, dimension.width - 1, this.dividerSize - 1);
            }
        }
    }

    public BasicSplitPaneDivider getDivider() {
        return this.divider;
    }

    protected int getDividerBorderSize() {
        return 1;
    }

    public int getDividerLocation(JSplitPane jSplitPane) {
        if (this.orientation == 1) {
            return this.divider.getLocation().x;
        }
        return this.divider.getLocation().y;
    }

    public Insets getInsets(JComponent jComponent) {
        return null;
    }

    public int getLastDragLocation() {
        return this.lastDragLocation;
    }

    public int getMaximumDividerLocation(JSplitPane jSplitPane) {
        Dimension dimension = this.splitPane.getSize();
        int n = 0;
        Component component = this.splitPane.getRightComponent();
        if (component != null) {
            Insets insets = this.splitPane.getInsets();
            Dimension dimension2 = component.getMinimumSize();
            n = this.orientation == 1 ? dimension.width - dimension2.width : dimension.height - dimension2.height;
            n -= this.dividerSize + this.getDividerBorderSize();
            if (insets != null) {
                n = this.orientation == 1 ? (n += insets.left) : (n += insets.top);
            }
        }
        return Math.max(this.getMinimumDividerLocation(this.splitPane), n);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        if (this.splitPane != null) {
            return this.layoutManager.maximumLayoutSize(this.splitPane);
        }
        return new Dimension(0, 0);
    }

    public int getMinimumDividerLocation(JSplitPane jSplitPane) {
        int n = 0;
        Component component = this.splitPane.getLeftComponent();
        if (component != null) {
            Insets insets = this.splitPane.getInsets();
            Dimension dimension = component.getMinimumSize();
            n = this.orientation == 1 ? dimension.width : dimension.height;
            n += this.getDividerBorderSize();
            if (insets != null) {
                n = this.orientation == 1 ? (n += insets.left) : (n += insets.top);
            }
        }
        return n;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        if (this.splitPane != null) {
            return this.layoutManager.minimumLayoutSize(this.splitPane);
        }
        return new Dimension(0, 0);
    }

    public Component getNonContinuousLayoutDivider() {
        return this.nonContinuousLayoutDivider;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        if (this.splitPane != null) {
            return this.layoutManager.preferredLayoutSize(this.splitPane);
        }
        return new Dimension(0, 0);
    }

    public JSplitPane getSplitPane() {
        return this.splitPane;
    }

    protected void installDefaults() {
        LookAndFeel.installBorder(this.splitPane, "SplitPane.border");
        if (this.divider == null) {
            this.divider = this.createDefaultDivider();
        }
        this.divider.setBasicSplitPaneUI(this);
        this.splitPane.setDividerSize((Integer)UIManager.get("SplitPane.dividerSize"));
        this.divider.setDividerSize(this.splitPane.getDividerSize());
        this.splitPane.add((Component)this.divider, "divider");
        this.setOrientation(this.splitPane.getOrientation());
        this.setContinuousLayout(this.splitPane.isContinuousLayout());
        this.resetLayoutManager();
        if (this.nonContinuousLayoutDivider == null) {
            this.setNonContinuousLayoutDivider(this.createDefaultNonContinuousLayoutDivider(), true);
        } else {
            this.setNonContinuousLayoutDivider(this.nonContinuousLayoutDivider, true);
        }
    }

    protected void installKeyboardActions() {
        this.upKey = KeyStroke.getKeyStroke(38, 0);
        this.splitPane.registerKeyboardAction(this.keyboardUpLeftListener, this.upKey, 1);
        this.downKey = KeyStroke.getKeyStroke(40, 0);
        this.splitPane.registerKeyboardAction(this.keyboardDownRightListener, this.downKey, 1);
        this.leftKey = KeyStroke.getKeyStroke(37, 0);
        this.splitPane.registerKeyboardAction(this.keyboardUpLeftListener, this.leftKey, 1);
        this.rightKey = KeyStroke.getKeyStroke(39, 0);
        this.splitPane.registerKeyboardAction(this.keyboardDownRightListener, this.rightKey, 1);
        this.homeKey = KeyStroke.getKeyStroke(36, 0);
        this.splitPane.registerKeyboardAction(this.keyboardHomeListener, this.homeKey, 1);
        this.endKey = KeyStroke.getKeyStroke(35, 0);
        this.splitPane.registerKeyboardAction(this.keyboardEndListener, this.endKey, 1);
        this.dividerResizeToggleKey = KeyStroke.getKeyStroke(119, 0);
        this.splitPane.registerKeyboardAction(this.keyboardResizeToggleListener, this.dividerResizeToggleKey, 1);
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        if (this.propertyChangeListener != null) {
            this.splitPane.addPropertyChangeListener(this.propertyChangeListener);
        }
        if ((this.focusListener = this.createFocusListener()) != null) {
            this.splitPane.addFocusListener(this.focusListener);
        }
        this.keyboardUpLeftListener = this.createKeyboardUpLeftListener();
        this.keyboardDownRightListener = this.createKeyboardDownRightListener();
        this.keyboardHomeListener = this.createKeyboardHomeListener();
        this.keyboardEndListener = this.createKeyboardEndListener();
        this.keyboardResizeToggleListener = this.createKeyboardResizeToggleListener();
    }

    public void installUI(JComponent jComponent) {
        this.splitPane = (JSplitPane)jComponent;
        this.dividerLocationIsSet = false;
        this.dividerKeyboardResize = false;
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
        this.setLastDragLocation(-1);
        this.splitPane.doLayout();
    }

    public boolean isContinuousLayout() {
        return this.continuousLayout;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
    }

    protected void resetLayoutManager() {
        this.layoutManager = this.orientation == 1 ? new BasicHorizontalLayoutManager() : new BasicVerticalLayoutManager();
        this.splitPane.setLayout(this.layoutManager);
        this.layoutManager.updateComponents();
        this.splitPane.revalidate();
        this.splitPane.repaint();
    }

    public void resetToPreferredSizes(JSplitPane jSplitPane) {
        if (this.splitPane != null) {
            this.layoutManager.resetToPreferredSizes();
            this.splitPane.revalidate();
            this.layoutManager.layoutContainer(this.splitPane);
        }
    }

    public void setContinuousLayout(boolean bl) {
        this.continuousLayout = bl;
    }

    public void setDividerLocation(JSplitPane jSplitPane, int n) {
        Component component = this.splitPane.getLeftComponent();
        Component component2 = this.splitPane.getRightComponent();
        if (component != null && component2 != null) {
            Insets insets = this.splitPane.getInsets();
            if (insets != null) {
                if (this.orientation == 1) {
                    component.setSize(Math.max(0, n - this.getDividerBorderSize() - insets.left), 10);
                } else {
                    component.setSize(10, Math.max(0, n - this.getDividerBorderSize() - insets.top));
                }
            } else if (this.orientation == 1) {
                component.setSize(Math.max(0, n - this.getDividerBorderSize()), 10);
            } else {
                component.setSize(10, Math.max(0, n - this.getDividerBorderSize()));
            }
            if (!this.dividerLocationIsSet) {
                this.dividerLocationIsSet = true;
            }
            this.splitPane.revalidate();
            this.splitPane.repaint();
        }
    }

    public void setLastDragLocation(int n) {
        this.lastDragLocation = n;
    }

    protected void setNonContinuousLayoutDivider(Component component) {
        this.setNonContinuousLayoutDivider(component, true);
    }

    protected void setNonContinuousLayoutDivider(Component component, boolean bl) {
        if (this.nonContinuousLayoutDivider != null && this.splitPane != null) {
            this.splitPane.remove(this.nonContinuousLayoutDivider);
        }
        this.nonContinuousLayoutDivider = component;
        if (this.nonContinuousLayoutDivider != null && this.splitPane != null) {
            this.nonContinuousLayoutDivider.setLocation(-1000, -1000);
            Component component2 = this.splitPane.getLeftComponent();
            Component component3 = this.splitPane.getRightComponent();
            int[] nArray = this.layoutManager.getSizes();
            if (component2 != null) {
                this.splitPane.setLeftComponent(null);
            }
            if (component3 != null) {
                this.splitPane.setRightComponent(null);
            }
            this.splitPane.remove(this.divider);
            this.splitPane.add(this.nonContinuousLayoutDivider, NON_CONTINUOUS_DIVIDER, this.splitPane.getComponentCount());
            this.splitPane.setLeftComponent(component2);
            this.splitPane.setRightComponent(component3);
            this.splitPane.add((Component)this.divider, "divider");
            if (bl) {
                this.layoutManager.setSizes(nArray);
            }
            this.splitPane.revalidate();
            this.splitPane.paintImmediately(this.splitPane.getX(), this.splitPane.getY(), this.splitPane.getWidth(), this.splitPane.getHeight());
        }
    }

    public void setOrientation(int n) {
        this.orientation = n;
    }

    protected void startDragging() {
        ComponentPeer componentPeer;
        Component component = this.splitPane.getLeftComponent();
        Component component2 = this.splitPane.getRightComponent();
        this.beginDragDividerLocation = this.getDividerLocation(this.splitPane);
        this.draggingHW = false;
        if (component != null && (componentPeer = component.getPeer()) != null && !(componentPeer instanceof LightweightPeer)) {
            this.draggingHW = true;
        } else if (component2 != null && (componentPeer = component2.getPeer()) != null && !(componentPeer instanceof LightweightPeer)) {
            this.draggingHW = true;
        }
        if (this.orientation == 1) {
            this.setLastDragLocation(this.divider.getBounds().x);
            this.dividerSize = this.divider.getSize().width + 2 * this.getDividerBorderSize();
            if (!this.isContinuousLayout() && this.draggingHW) {
                this.nonContinuousLayoutDivider.setBounds(this.getLastDragLocation(), 0, this.dividerSize, this.splitPane.getHeight());
            }
        } else {
            this.setLastDragLocation(this.divider.getBounds().y);
            this.dividerSize = this.divider.getSize().height + 2 * this.getDividerBorderSize();
            if (!this.isContinuousLayout() && this.draggingHW) {
                this.nonContinuousLayoutDivider.setBounds(0, this.getLastDragLocation(), this.splitPane.getWidth(), this.dividerSize);
            }
        }
    }

    protected void uninstallDefaults() {
        if (this.splitPane.getLayout() == this.layoutManager) {
            this.splitPane.setLayout(null);
        }
        if (this.nonContinuousLayoutDivider != null) {
            this.splitPane.remove(this.nonContinuousLayoutDivider);
        }
        LookAndFeel.uninstallBorder(this.splitPane);
        this.splitPane.remove(this.divider);
        this.divider.setBasicSplitPaneUI(null);
        this.layoutManager = null;
        this.divider = null;
        this.nonContinuousLayoutDivider = null;
        this.setNonContinuousLayoutDivider(null);
    }

    protected void uninstallKeyboardActions() {
        this.splitPane.unregisterKeyboardAction(this.upKey);
        this.splitPane.unregisterKeyboardAction(this.downKey);
        this.splitPane.unregisterKeyboardAction(this.leftKey);
        this.splitPane.unregisterKeyboardAction(this.rightKey);
        this.splitPane.unregisterKeyboardAction(this.homeKey);
        this.splitPane.unregisterKeyboardAction(this.endKey);
        this.splitPane.unregisterKeyboardAction(this.dividerResizeToggleKey);
        this.upKey = null;
        this.downKey = null;
        this.leftKey = null;
        this.rightKey = null;
        this.homeKey = null;
        this.endKey = null;
        this.dividerResizeToggleKey = null;
    }

    protected void uninstallListeners() {
        if (this.propertyChangeListener != null) {
            this.splitPane.removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
        if (this.focusListener != null) {
            this.splitPane.removeFocusListener(this.focusListener);
            this.focusListener = null;
        }
        this.keyboardUpLeftListener = null;
        this.keyboardDownRightListener = null;
        this.keyboardHomeListener = null;
        this.keyboardEndListener = null;
        this.keyboardResizeToggleListener = null;
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.uninstallDefaults();
        this.dividerLocationIsSet = false;
        this.dividerKeyboardResize = false;
        this.splitPane = null;
    }

    public class PropertyHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() == BasicSplitPaneUI.this.splitPane) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("orientation")) {
                    BasicSplitPaneUI.this.orientation = BasicSplitPaneUI.this.splitPane.getOrientation();
                    BasicSplitPaneUI.this.resetLayoutManager();
                } else if (string.equals("continuousLayout")) {
                    BasicSplitPaneUI.this.setContinuousLayout(BasicSplitPaneUI.this.splitPane.isContinuousLayout());
                    if (!BasicSplitPaneUI.this.isContinuousLayout()) {
                        if (BasicSplitPaneUI.this.nonContinuousLayoutDivider == null) {
                            BasicSplitPaneUI.this.setNonContinuousLayoutDivider(BasicSplitPaneUI.this.createDefaultNonContinuousLayoutDivider(), true);
                        } else if (BasicSplitPaneUI.this.nonContinuousLayoutDivider.getParent() == null) {
                            BasicSplitPaneUI.this.setNonContinuousLayoutDivider(BasicSplitPaneUI.this.nonContinuousLayoutDivider, true);
                        }
                    }
                } else if (string.equals("dividerSize")) {
                    BasicSplitPaneUI.this.divider.setDividerSize(BasicSplitPaneUI.this.splitPane.getDividerSize());
                    BasicSplitPaneUI.this.layoutManager.resetSizeAt(2);
                    BasicSplitPaneUI.this.splitPane.revalidate();
                }
            }
        }
    }

    public class FocusHandler
    extends FocusAdapter {
        public void focusLost(FocusEvent focusEvent) {
            BasicSplitPaneUI.this.dividerKeyboardResize = false;
            BasicSplitPaneUI.this.splitPane.repaint();
        }
    }

    public class KeyboardUpLeftHandler
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (BasicSplitPaneUI.this.dividerKeyboardResize) {
                BasicSplitPaneUI.this.setDividerLocation(BasicSplitPaneUI.this.splitPane, BasicSplitPaneUI.this.getDividerLocation(BasicSplitPaneUI.this.splitPane) - KEYBOARD_DIVIDER_MOVE_OFFSET);
            }
        }
    }

    public class KeyboardDownRightHandler
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (BasicSplitPaneUI.this.dividerKeyboardResize) {
                BasicSplitPaneUI.this.setDividerLocation(BasicSplitPaneUI.this.splitPane, BasicSplitPaneUI.this.getDividerLocation(BasicSplitPaneUI.this.splitPane) + KEYBOARD_DIVIDER_MOVE_OFFSET);
            }
        }
    }

    public class KeyboardHomeHandler
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (BasicSplitPaneUI.this.dividerKeyboardResize) {
                BasicSplitPaneUI.this.setDividerLocation(BasicSplitPaneUI.this.splitPane, 0);
            }
        }
    }

    public class KeyboardEndHandler
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (BasicSplitPaneUI.this.dividerKeyboardResize) {
                if (BasicSplitPaneUI.this.orientation == 0) {
                    BasicSplitPaneUI.this.setDividerLocation(BasicSplitPaneUI.this.splitPane, BasicSplitPaneUI.this.splitPane.getHeight() - BasicSplitPaneUI.this.splitPane.getInsets().bottom);
                } else {
                    BasicSplitPaneUI.this.setDividerLocation(BasicSplitPaneUI.this.splitPane, BasicSplitPaneUI.this.splitPane.getWidth() - BasicSplitPaneUI.this.splitPane.getInsets().right);
                }
            }
        }
    }

    public class KeyboardResizeToggleHandler
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (!BasicSplitPaneUI.this.dividerKeyboardResize) {
                BasicSplitPaneUI.this.splitPane.requestFocus();
                BasicSplitPaneUI.this.dividerKeyboardResize = true;
                BasicSplitPaneUI.this.splitPane.repaint();
            }
        }
    }

    public class BasicHorizontalLayoutManager
    implements LayoutManager2 {
        protected int[] sizes;
        protected Component[] components = new Component[3];

        BasicHorizontalLayoutManager() {
            this.components[2] = null;
            this.components[1] = null;
            this.components[0] = null;
            this.sizes = new int[3];
        }

        public void addLayoutComponent(Component component, Object object) {
            if (object != null && !(object instanceof String)) {
                throw new IllegalArgumentException("cannot add to layout: constraint must be a string (or null)");
            }
            this.addLayoutComponent((String)object, component);
        }

        public void addLayoutComponent(String string, Component component) {
            boolean bl = true;
            if (string != null) {
                if (string.equals("divider")) {
                    this.components[2] = component;
                    this.sizes[2] = -1;
                } else if (string.equals("left") || string.equals("top")) {
                    this.components[0] = component;
                    this.sizes[0] = -1;
                } else if (string.equals("right") || string.equals("bottom")) {
                    this.components[1] = component;
                    this.sizes[1] = -1;
                } else if (!string.equals(BasicSplitPaneUI.NON_CONTINUOUS_DIVIDER)) {
                    bl = false;
                }
            } else {
                bl = false;
            }
            if (!bl) {
                throw new IllegalArgumentException("cannot add to layout: unknown constraint: " + string);
            }
        }

        protected int getAvailableSize(Dimension dimension, Insets insets) {
            if (insets == null) {
                return dimension.width;
            }
            return dimension.width - (insets.left + insets.right + 2 * BasicSplitPaneUI.this.getDividerBorderSize());
        }

        protected int getInitialLocation(Insets insets) {
            if (insets != null) {
                return insets.left;
            }
            return 0;
        }

        public float getLayoutAlignmentX(Container container) {
            return 0.0f;
        }

        public float getLayoutAlignmentY(Container container) {
            return 0.0f;
        }

        int getMinimumSizeOfComponent(Component component) {
            return component.getMinimumSize().width;
        }

        protected int getPreferredSizeOfComponent(Component component) {
            return component.getPreferredSize().width;
        }

        protected int getSizeOfComponent(Component component) {
            return component.getSize().width;
        }

        protected int[] getSizes() {
            int[] nArray = new int[3];
            System.arraycopy(this.sizes, 0, nArray, 0, 3);
            return nArray;
        }

        public void invalidateLayout(Container container) {
        }

        public void layoutContainer(Container container) {
            int n;
            int n2;
            Dimension dimension = container.getSize();
            if (dimension.height == 0 || dimension.width == 0) {
                return;
            }
            Insets insets = BasicSplitPaneUI.this.splitPane.getInsets();
            int n3 = 0;
            int n4 = this.getAvailableSize(dimension, insets);
            int n5 = BasicSplitPaneUI.this.splitPane.getDividerLocation();
            int n6 = 0;
            while (n6 < 3) {
                if (this.components[n6] != null) {
                    if (this.sizes[n6] == -1) {
                        if (BasicSplitPaneUI.this.dividerLocationIsSet && n6 == 0) {
                            this.sizes[n6] = Math.min(n4, this.getSizeOfComponent(this.components[n6]));
                        } else {
                            this.sizes[n6] = Math.min(n4, this.getPreferredSizeOfComponent(this.components[n6]));
                            if (n6 == 2 && this.components[0] != null && this.components[1] != null && this.sizes[0] + this.sizes[n6] + this.getMinimumSizeOfComponent(this.components[1]) > n4) {
                                this.sizes[0] = this.getMinimumSizeOfComponent(this.components[0]) > 0 ? this.getMinimumSizeOfComponent(this.components[0]) : this.getPreferredSizeOfComponent(this.components[0]);
                            }
                        }
                    } else {
                        n2 = this.getSizeOfComponent(this.components[n6]);
                        if (this.sizes[n6] != n2) {
                            if (n6 == 0) {
                                if (this.components[1] != null) {
                                    this.sizes[1] = Math.max(0, this.sizes[1] + (this.sizes[n6] - n2));
                                }
                            } else if (n6 == 1 && this.components[0] != null) {
                                this.sizes[0] = Math.max(0, this.sizes[0] + (this.sizes[n6] - n2));
                            }
                            this.sizes[n6] = n2;
                            if (n6 == 0) {
                                n6 = 1;
                            }
                        }
                    }
                }
                ++n6;
            }
            n6 = 0;
            while (n6 < 3) {
                n3 += this.sizes[n6];
                ++n6;
            }
            if (n3 != n4) {
                n = n4 - n3;
                if (this.components[1] != null) {
                    n2 = Math.max(0, this.sizes[1] + n);
                    if (n2 == 0) {
                        n += this.sizes[1];
                        this.sizes[1] = 0;
                        if (this.components[0] != null) {
                            this.sizes[0] = Math.max(0, this.sizes[0] + n);
                        }
                    } else {
                        this.sizes[1] = n2;
                    }
                } else if (this.components[0] != null) {
                    this.sizes[0] = Math.max(0, this.sizes[0] + n);
                }
            }
            n = this.getInitialLocation(insets);
            int n7 = BasicSplitPaneUI.this.getDividerBorderSize();
            n6 = 0;
            while (n6 < 3) {
                if (this.components[n6] != null) {
                    this.setComponentToSize(this.components[n6], this.sizes[n6], n, insets, dimension);
                    n += this.sizes[n6];
                }
                switch (n6) {
                    case 0: {
                        n6 = 2;
                        n += n7;
                        break;
                    }
                    case 2: {
                        n6 = 1;
                        n += n7;
                        break;
                    }
                    case 1: {
                        n6 = 3;
                        break;
                    }
                }
            }
            if (n5 != BasicSplitPaneUI.this.splitPane.getDividerLocation()) {
                BasicSplitPaneUI.this.splitPane.setLastDividerLocation(n5);
            }
        }

        public Dimension maximumLayoutSize(Container container) {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        public Dimension minimumLayoutSize(Container container) {
            int n = 0;
            int n2 = 0;
            Insets insets = BasicSplitPaneUI.this.splitPane.getInsets();
            int n3 = 0;
            while (n3 < 3) {
                if (this.components[n3] != null) {
                    Dimension dimension = this.components[n3].getMinimumSize();
                    n += dimension.width;
                    if (dimension.height > n2) {
                        n2 = dimension.height;
                    }
                }
                ++n3;
            }
            if (insets != null) {
                n += insets.left + insets.right;
                n2 += insets.bottom + insets.top;
            }
            return new Dimension(n, n2);
        }

        public Dimension preferredLayoutSize(Container container) {
            int n = 0;
            int n2 = 0;
            Insets insets = BasicSplitPaneUI.this.splitPane.getInsets();
            int n3 = 0;
            while (n3 < 3) {
                if (this.components[n3] != null) {
                    Dimension dimension = this.components[n3].getPreferredSize();
                    n += dimension.width;
                    if (dimension.height > n2) {
                        n2 = dimension.height;
                    }
                }
                ++n3;
            }
            if (insets != null) {
                n += insets.left + insets.right;
                n2 += insets.bottom + insets.top;
            }
            return new Dimension(n, n2);
        }

        public void removeLayoutComponent(Component component) {
            int n = 0;
            while (n < 3) {
                if (this.components[n] == component) {
                    this.components[n] = null;
                    this.sizes[n] = 0;
                }
                ++n;
            }
        }

        protected void resetSizeAt(int n) {
            this.sizes[n] = -1;
        }

        public void resetToPreferredSizes() {
            int n = 0;
            while (n < 3) {
                this.sizes[n] = -1;
                ++n;
            }
        }

        protected void setComponentToSize(Component component, int n, int n2, Insets insets, Dimension dimension) {
            if (insets != null) {
                component.setBounds(n2, insets.top, n, dimension.height - (insets.top + insets.bottom));
            } else {
                component.setBounds(n2, 0, n, dimension.height);
            }
        }

        protected void setSizes(int[] nArray) {
            System.arraycopy(nArray, 0, this.sizes, 0, 3);
        }

        protected void updateComponents() {
            Component component = BasicSplitPaneUI.this.splitPane.getLeftComponent();
            if (this.components[0] != component) {
                this.components[0] = component;
                this.sizes[0] = component == null ? 0 : -1;
            }
            if (this.components[1] != (component = BasicSplitPaneUI.this.splitPane.getRightComponent())) {
                this.components[1] = component;
                this.sizes[1] = component == null ? 0 : -1;
            }
            Component[] componentArray = BasicSplitPaneUI.this.splitPane.getComponents();
            Component component2 = this.components[2];
            this.components[2] = null;
            int n = componentArray.length - 1;
            while (n >= 0) {
                if (componentArray[n] != this.components[0] && componentArray[n] != this.components[1] && componentArray[n] != BasicSplitPaneUI.this.nonContinuousLayoutDivider) {
                    if (component2 != componentArray[n]) {
                        this.components[2] = componentArray[n];
                        if (componentArray[n] == null) {
                            this.sizes[2] = 0;
                            break;
                        }
                        this.sizes[2] = -1;
                        break;
                    }
                    this.components[2] = component2;
                    break;
                }
                --n;
            }
            if (this.components[2] == null) {
                this.sizes[2] = 0;
            }
        }
    }

    public class BasicVerticalLayoutManager
    extends BasicHorizontalLayoutManager {
        protected int getAvailableSize(Dimension dimension, Insets insets) {
            if (insets == null) {
                return dimension.height;
            }
            return dimension.height - (insets.bottom + insets.top + 2 * BasicSplitPaneUI.this.getDividerBorderSize());
        }

        protected int getInitialLocation(Insets insets) {
            if (insets != null) {
                return insets.top;
            }
            return 0;
        }

        int getMinimumSizeOfComponent(Component component) {
            return component.getMinimumSize().height;
        }

        protected int getPreferredSizeOfComponent(Component component) {
            return component.getPreferredSize().height;
        }

        protected int getSizeOfComponent(Component component) {
            return component.getSize().height;
        }

        public Dimension minimumLayoutSize(Container container) {
            int n = 0;
            int n2 = 0;
            Insets insets = BasicSplitPaneUI.this.splitPane.getInsets();
            int n3 = 0;
            while (n3 < 3) {
                if (this.components[n3] != null) {
                    Dimension dimension = this.components[n3].getMinimumSize();
                    n2 += dimension.height;
                    if (dimension.width > n) {
                        n = dimension.width;
                    }
                }
                ++n3;
            }
            if (insets != null) {
                n += insets.left + insets.right;
                n2 += insets.bottom + insets.top;
            }
            return new Dimension(n, n2);
        }

        public Dimension preferredLayoutSize(Container container) {
            int n = 0;
            int n2 = 0;
            Insets insets = BasicSplitPaneUI.this.splitPane.getInsets();
            int n3 = 0;
            while (n3 < 3) {
                if (this.components[n3] != null) {
                    Dimension dimension = this.components[n3].getPreferredSize();
                    n2 += dimension.height;
                    if (dimension.width > n) {
                        n = dimension.width;
                    }
                }
                ++n3;
            }
            if (insets != null) {
                n += insets.left + insets.right;
                n2 += insets.bottom + insets.top;
            }
            return new Dimension(n, n2);
        }

        protected void setComponentToSize(Component component, int n, int n2, Insets insets, Dimension dimension) {
            if (insets != null) {
                component.setBounds(insets.left, n2, dimension.width - (insets.left + insets.right), n);
            } else {
                component.setBounds(0, n2, dimension.width, n);
            }
        }
    }
}

