/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import java.awt.Color;
import simulate.AtomType;
import simulate.ColorSchemeByType;
import simulate.ConfigurationMoleculeLinear;
import simulate.Default;
import simulate.Molecule;
import simulate.Phase;
import simulate.Simulation;
import simulate.Species;

public class SpeciesDisks
extends Species {
    public AtomType.Disk protoType;

    public SpeciesDisks() {
        this.setSpeciesIndex(0);
        this.setAtomsPerMolecule(1);
        this.protoType = Simulation.D == 1 ? new AtomType.Rod(40.0, Default.ATOM_COLOR, 3.0) : new AtomType.Disk(40.0, Default.ATOM_COLOR, 3.0);
        this.colorScheme = new ColorSchemeByType();
        this.configurationMolecule = new ConfigurationMoleculeLinear();
        this.setNMolecules(20);
    }

    public SpeciesDisks(Simulation ps) {
        this(ps, 20, 1);
    }

    public SpeciesDisks(Simulation ps, int nM, int nA) {
        this(ps, nM, nA, new AtomType.Disk(40.0, Default.ATOM_COLOR, 3.0));
    }

    public SpeciesDisks(Simulation ps, int nM, int nA, AtomType.Disk type) {
        this.parentSimulation = ps;
        this.setSpeciesIndex(0);
        this.protoType = type;
        this.atomsPerMolecule = nA;
        this.setNMolecules(nM);
        this.colorScheme = new ColorSchemeByType();
        this.add(new ConfigurationMoleculeLinear());
    }

    public final Color getColor() {
        return this.protoType.color();
    }

    public final double getDiameter() {
        return this.protoType.diameter();
    }

    public final double getMass() {
        return this.protoType.mass();
    }

    protected Molecule makeMolecule(Phase phase) {
        return new Molecule(this, phase, this.protoType, this.atomsPerMolecule);
    }

    public final void setColor(Color c) {
        this.protoType.setColor(c);
    }

    public void setDiameter(double d) {
        this.protoType.setDiameter(d);
    }

    public final void setMass(double mass) {
        this.protoType.setMass(mass);
    }
}

