/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import simulate.Atom;
import simulate.AtomPair;
import simulate.Meter;
import simulate.Molecule;
import simulate.Phase;
import simulate.Species;

public class MeterPotentialEnergy
extends Meter {
    AtomPair.Iterator iterator;
    AtomPair.Iterator.MP iteratorMP;
    AtomPair.Iterator.All iteratorAll;
    AtomPair.Iterator apiUp;
    AtomPair.Iterator apiDown;

    public MeterPotentialEnergy() {
        this.setLabel("Potential Energy");
    }

    public final double LRC() {
        double lrc = 0.0;
        double V = this.phase.volume();
        Species.Agent s1 = this.phase.firstSpecies();
        while (s1 != null) {
            int n1 = s1.moleculeCount();
            Molecule m1 = s1.parentSpecies().getMolecule();
            m1.atomIterator.reset();
            while (m1.atomIterator.hasNext()) {
                Atom a1 = m1.atomIterator.next();
                Molecule m2 = s1.parentSpecies().getMolecule();
                m2.atomIterator.reset();
                while (m2.atomIterator.hasNext()) {
                    Atom a2 = m2.atomIterator.next();
                    lrc += this.phase.parentSimulation.getPotential(a1, a2).energyLRC(n1, n1, V);
                }
                Species.Agent s2 = s1.nextSpecies();
                while (s2 != null) {
                    int n2 = s2.moleculeCount();
                    m2 = s2.parentSpecies().getMolecule();
                    m2.atomIterator.reset();
                    while (m2.atomIterator.hasNext()) {
                        Atom a2 = m2.atomIterator.next();
                        lrc += 2.0 * this.phase.parentSimulation.getPotential(a1, a2).energyLRC(n1, n2, V);
                    }
                    s2 = s2.nextSpecies();
                }
            }
            s1 = s1.nextSpecies();
        }
        return lrc;
    }

    public final double currentValue() {
        double pe = 0.0;
        this.iteratorAll.reset();
        while (this.iteratorAll.hasNext()) {
            AtomPair pair = this.iteratorAll.next();
            double energy = this.phase.parentSimulation.getPotential(pair).energy(pair);
            if (energy == Double.MAX_VALUE) {
                return Double.MAX_VALUE;
            }
            pe += energy;
        }
        return pe;
    }

    public final double currentValue(Atom a) {
        double energy;
        AtomPair pair;
        if (this.phase != a.parentPhase()) {
            return 0.0;
        }
        double pe = 0.0;
        this.apiUp.reset(a);
        while (this.apiUp.hasNext()) {
            pair = this.apiUp.next();
            energy = this.phase.parentSimulation.getPotential(pair).energy(pair);
            if (energy == Double.MAX_VALUE) {
                return Double.MAX_VALUE;
            }
            pe += energy;
        }
        this.apiDown.reset(a);
        while (this.apiDown.hasNext()) {
            pair = this.apiDown.next();
            energy = this.phase.parentSimulation.getPotential(pair).energy(pair);
            if (energy == Double.MAX_VALUE) {
                return Double.MAX_VALUE;
            }
            pe += energy;
        }
        return pe;
    }

    public final double currentValue(Molecule m) {
        this.iteratorMP.reset(m);
        double pe = 0.0;
        while (this.iteratorMP.hasNext()) {
            AtomPair pair = this.iteratorMP.next();
            pe += this.phase.parentSimulation.getPotential(pair).energy(pair);
        }
        return pe;
    }

    public final double insertionValue(Molecule m) {
        this.iteratorMP.reset(m);
        double pe = 0.0;
        while (this.iteratorMP.hasNext()) {
            AtomPair pair = this.iteratorMP.next();
            double energy = this.phase.parentSimulation.getPotential(pair).energy(pair);
            if (energy == Double.MAX_VALUE) {
                return Double.MAX_VALUE;
            }
            pe += energy;
        }
        return pe;
    }

    public void setPhase(Phase p) {
        super.setPhase(p);
        this.iteratorMP = new AtomPair.Iterator.MP(p);
        this.iteratorAll = p.iterator.makeAtomPairIteratorAll();
        this.apiUp = p.iterator.makeAtomPairIteratorUp();
        this.apiDown = p.iterator.makeAtomPairIteratorDown();
    }
}

