/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import java.awt.Component;
import java.awt.Graphics;
import simulate.IntegrationIntervalEvent;
import simulate.IntegrationIntervalListener;
import simulate.Phase;

public abstract class MeterAbstract
extends Component
implements IntegrationIntervalListener {
    int updateInterval;
    int iieCount;
    private MeterAbstract nextMeter;
    private MeterAbstract previousMeter;
    protected Phase phase;
    String label;
    protected boolean active;

    public MeterAbstract() {
        this.setUpdateInterval(1);
        this.label = "Property";
    }

    public void draw(Graphics g, int[] origin, double scale) {
    }

    public String getLabel() {
        return this.label;
    }

    public final int getUpdateInterval() {
        return this.updateInterval;
    }

    public void initialize() {
    }

    public void integrationIntervalAction(IntegrationIntervalEvent evt) {
        if (!this.active) {
            return;
        }
        if (--this.iieCount == 0) {
            this.iieCount = this.updateInterval;
            this.updateSums();
        }
    }

    public final boolean isActive() {
        return this.active;
    }

    public final MeterAbstract nextMeter() {
        return this.nextMeter;
    }

    public final MeterAbstract previousMeter() {
        return this.previousMeter;
    }

    public abstract void reset();

    public void setActive(boolean b) {
        this.active = b;
    }

    public void setLabel(String s) {
        this.label = s;
    }

    public final void setNextMeter(MeterAbstract meter) {
        this.nextMeter = meter;
        if (meter != null) {
            meter.previousMeter = this;
        }
    }

    public void setPhase(Phase p) {
        this.phase = p;
    }

    public final void setUpdateInterval(int i) {
        if (i > 0) {
            this.iieCount = this.updateInterval = i;
        }
    }

    public abstract void updateSums();

    public static final class Accumulator {
        private double sum;
        private double sumSquare;
        private double mostRecent;
        private int count;

        public Accumulator() {
            this.reset();
        }

        public void add(double value) {
            this.mostRecent = value;
            if (Double.isNaN(value)) {
                return;
            }
            this.sum += value;
            this.sumSquare += value * value;
            ++this.count;
        }

        public double average() {
            return this.count > 0 ? this.sum / (double)this.count : Double.NaN;
        }

        public double error() {
            double avg = this.average();
            return this.count > 1 ? Math.sqrt((this.sumSquare / (double)this.count - avg * avg) / (double)(this.count - 1)) : Double.NaN;
        }

        public double mostRecent() {
            return this.mostRecent;
        }

        public void reset() {
            this.count = 0;
            this.sum = 0.0;
            this.sumSquare = 0.0;
        }
    }
}

