/*
 * Decompiled with CFR 0.152.
 */
package simulate;

import java.util.Random;
import simulate.Atom;
import simulate.AtomPair;
import simulate.Controller;
import simulate.Integrator;
import simulate.IntegratorMD;
import simulate.Phase;
import simulate.PotentialSoft;
import simulate.Simulation;
import simulate.Space;

public final class IntegratorVelocityVerlet
extends IntegratorMD {
    AtomPair.Iterator.All pairIterator;
    Atom.Iterator atomIterator;
    AtomPair.Action forceSum;
    Random random = new Random();
    double nu = 0.001;
    private double t2;

    public void doStep() {
        Atom a;
        this.atomIterator.reset();
        while (this.atomIterator.hasNext()) {
            a = this.atomIterator.next();
            Agent agent = (Agent)a.ia;
            Space.Vector r = a.position();
            Space.Vector p = a.momentum();
            p.PEa1Tv1(0.5 * this.timeStep, agent.force);
            r.PEa1Tv1(this.timeStep * a.rm(), p);
            agent.force.E(0.0);
        }
        this.pairIterator.allPairs(this.forceSum);
        this.atomIterator.reset();
        while (this.atomIterator.hasNext()) {
            a = this.atomIterator.next();
            a.momentum().PEa1Tv1(0.5 * this.timeStep, ((Agent)a.ia).force);
        }
        if (this.isothermal) {
            this.atomIterator.reset();
            double nut = this.nu * this.timeStep;
            while (this.atomIterator.hasNext()) {
                Atom a2 = this.atomIterator.next();
                if (!(this.random.nextDouble() < nut)) continue;
                a2.randomizeMomentum(this.temperature);
            }
        }
    }

    public double getAndersenNu() {
        return this.nu;
    }

    public void initialize() {
        this.deployAgents();
        this.atomIterator.reset();
        while (this.atomIterator.hasNext()) {
            Atom a = this.atomIterator.next();
            Agent agent = (Agent)a.ia;
            agent.force.E(0.0);
        }
        this.pairIterator.allPairs(this.forceSum);
    }

    public final Integrator.Agent makeAgent(Atom a) {
        return new Agent(a);
    }

    public void registerPhase(Phase p) {
        super.registerPhase(p);
        this.pairIterator = p.iterator.makeAtomPairIteratorAll();
        this.atomIterator = p.iterator.makeAtomIteratorUp();
    }

    public void setAndersenNu(double n) {
        this.nu = n;
    }

    public void setController(Controller c) {
        super.setController(c);
        this.forceSum = new AtomPair.Action(){
            private Space.Vector f;
            {
                IntegratorVelocityVerlet.this.simulation();
                this.f = Simulation.space.makeVector();
            }

            public void action(AtomPair pair) {
                this.f.E(((PotentialSoft)IntegratorVelocityVerlet.this.simulation().getPotential(pair)).force(pair));
                ((Agent)pair.atom1().ia).force.PE(this.f);
                ((Agent)pair.atom2().ia).force.ME(this.f);
            }
        };
    }

    public final void setTimeStep(double t) {
        super.setTimeStep(t);
        this.t2 = this.timeStep * this.timeStep;
    }

    public static final class Agent
    implements Integrator.Agent {
        public Atom atom;
        public Space.Vector force;

        public Agent(Atom a) {
            this.atom = a;
            this.force = Simulation.space.makeVector();
        }
    }
}

